/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.config;

import io.polaris.builder.code.CodeGenerator;
import io.polaris.builder.code.config.CodeEnv;
import io.polaris.builder.code.config.CodeGroup;
import io.polaris.builder.code.config.CodeGroupBuilder;
import io.polaris.builder.code.config.TypeMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CodeEnvBuilder {
    private final CodeGenerator generator;
    private final CodeEnv target;

    public CodeEnvBuilder(CodeGenerator generator, CodeEnv target) {
        this.generator = generator;
        this.target = target;
    }

    public CodeEnv build() {
        return this.target;
    }

    public CodeGenerator end() {
        return this.generator;
    }

    public CodeEnvBuilder outdir(String outdir) {
        this.target.setOutdir(outdir);
        return this;
    }

    public CodeEnvBuilder property(Map<String, String> property) {
        this.target.setProperty(property);
        return this;
    }

    public CodeEnvBuilder property(Supplier<Map<String, String>> property) {
        this.target.setProperty(property.get());
        return this;
    }

    public CodeEnvBuilder property(String key, String value) {
        if (this.target.getProperty() == null) {
            this.target.setProperty(new HashMap<String, String>());
        }
        this.target.getProperty().put(key, value);
        return this;
    }

    public CodeEnvBuilder tablePrefix(String tablePrefix) {
        this.target.setTablePrefix(tablePrefix);
        return this;
    }

    public CodeEnvBuilder tableSuffix(String tableSuffix) {
        this.target.setTableSuffix(tableSuffix);
        return this;
    }

    public CodeEnvBuilder columnPrefix(String columnPrefix) {
        this.target.setColumnPrefix(columnPrefix);
        return this;
    }

    public CodeEnvBuilder columnSuffix(String columnSuffix) {
        this.target.setColumnSuffix(columnSuffix);
        return this;
    }

    public CodeEnvBuilder mappings(Set<TypeMapping> mappings) {
        this.target.setMappings(mappings);
        return this;
    }

    public CodeEnvBuilder mappings(Supplier<Set<TypeMapping>> mappings) {
        this.target.setMappings(mappings.get());
        return this;
    }

    public CodeEnvBuilder mapping(String jdbcType, String javaType) {
        if (this.target.getMappings() == null) {
            this.target.setMappings(new LinkedHashSet<TypeMapping>());
        }
        this.target.getMappings().add(new TypeMapping(jdbcType, javaType));
        return this;
    }

    public CodeEnvBuilder ignoredColumns(Set<String> ignoredColumns) {
        this.target.setIgnoredColumns(ignoredColumns);
        return this;
    }

    public CodeEnvBuilder groups(List<CodeGroup> groups) {
        this.target.setGroups(groups);
        return this;
    }

    public CodeEnvBuilder addGroup(CodeGroup group) {
        if (this.target.getGroups() == null) {
            this.target.setGroups(new ArrayList<CodeGroup>());
        }
        this.target.getGroups().add(group);
        return this;
    }

    public CodeGroupBuilder addGroup() {
        CodeGroup group = new CodeGroup();
        this.addGroup(group);
        return new CodeGroupBuilder(this, group);
    }

    public CodeGroupBuilder group() {
        return this.group(0);
    }

    public CodeGroupBuilder group(int i) {
        if (this.target.getGroups() == null || this.target.getGroups().size() <= i) {
            this.addGroup(new CodeGroup());
        }
        return new CodeGroupBuilder(this, this.target.getGroups().get(i));
    }
}

