/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code;

import io.polaris.builder.code.CodeLogger;
import io.polaris.builder.code.config.CodeEnv;
import io.polaris.builder.code.config.CodeGroup;
import io.polaris.builder.code.config.CodeTable;
import io.polaris.builder.code.config.CodeTemplate;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.builder.velocity.VelocityTemplate;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;

public class CodeWriter {
    private final CodeEnv codeEnv;
    private final Map<CodeTable, TableDto> tables;
    public static final String VM_PREFIX = "#parse(\"/vm/include.vm\")";

    public CodeWriter(CodeEnv codeEnv, Map<CodeTable, TableDto> tables) {
        this.codeEnv = codeEnv;
        this.tables = tables;
    }

    public void write() {
        try {
            List<CodeGroup> groups = this.codeEnv.getGroups();
            if (groups == null) {
                return;
            }
            for (CodeGroup group : groups) {
                List<CodeTable> tableList = group.getTables();
                if (tableList == null) continue;
                for (CodeTable codeTable : tableList) {
                    TableDto table = this.tables.get(codeTable);
                    if (table == null) continue;
                    this.write(group, table);
                }
            }
        }
        catch (IOException e) {
            CodeLogger.error("", e);
            throw new RuntimeException(e);
        }
    }

    private void write(CodeGroup group, TableDto table) throws IOException {
        String baseOutdir = this.codeEnv.getOutdir();
        List<CodeTemplate> templates = group.getTemplates();
        if (templates == null) {
            return;
        }
        for (CodeTemplate template : templates) {
            String path = template.getPath();
            String dirname = template.getDirname();
            String filename = template.getFilename();
            CodeLogger.info("\u751f\u6210\u8868\u540d[{}]\u7684\u4ee3\u7801\uff0c\u6a21\u677f\uff1a[{}]", table.getName(), path.replace('\\', '/'));
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            LinkedHashMap<String, Map<String, String>> property = new LinkedHashMap<String, Map<String, String>>();
            Context context = VelocityTemplate.createContext();
            System.getenv().forEach((key, value) -> env.putIfAbsent((String)key, (String)value));
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> env.putIfAbsent((String)key, (String)value)));
            context.put("sys", (Object)System.getProperties());
            context.put("env", env);
            context.put("property", property);
            context.put("table", (Object)table);
            property.put("code", this.codeEnv.getProperty());
            property.put("group", group.getProperty());
            property.put("template", template.getProperty());
            property.put("table", table.getProperty());
            this.fetchVarToContextAndEnv(this.codeEnv.getProperty(), context, env, "code");
            this.fetchVarToContextAndEnv(group.getProperty(), context, env, "group");
            this.fetchVarToContextAndEnv(template.getProperty(), context, env, "template");
            this.fetchVarToContextAndEnv(table.getProperty(), context, env, "table");
            path = VelocityTemplate.eval(context, VM_PREFIX + path);
            dirname = VelocityTemplate.eval(context, VM_PREFIX + dirname);
            filename = VelocityTemplate.eval(context, VM_PREFIX + filename);
            try {
                String basedir = VelocityTemplate.eval(context, VM_PREFIX + baseOutdir);
                File dir = StringUtils.isBlank((CharSequence)basedir) ? new File(dirname) : new File(basedir + "/" + dirname);
                CodeLogger.info("\u751f\u6210\u8868\u540d[{}]\u7684\u4ee3\u7801\uff0c\u76ee\u5f55\uff1a[{}]\uff0c\u6587\u4ef6\uff1a[{}]", table.getName(), dir.getPath().replace('\\', '/'), filename);
                this.write(path, context, dir, filename);
            }
            catch (Exception e) {
                CodeLogger.error(e.getMessage(), e);
            }
        }
    }

    private void write(String template, Context context, File dir, String file) throws IOException {
        this.mkdirs(dir);
        FileOutputStream fos = new FileOutputStream(new File(dir, file));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset()));
        VelocityTemplate.write(context, (Writer)bw, template);
        bw.flush();
        bw.close();
    }

    private void fetchVarToContextAndEnv(Map<String, String> vars, Context context, Map<String, String> env, String prefix) {
        if (vars == null || vars.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, String>> entries = vars.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String extKey;
            String key = entry.getKey();
            String value = entry.getValue();
            value = VelocityTemplate.eval(context, VM_PREFIX + value);
            env.put(key, value);
            if (!context.containsKey(key)) {
                context.put(key, (Object)value);
            }
            if (!StringUtils.isNotBlank((CharSequence)prefix) || key.length() < 1) continue;
            if (!key.contains(".")) {
                extKey = prefix + Character.toUpperCase(key.charAt(0));
                if (key.length() >= 2) {
                    extKey = extKey + key.substring(1);
                }
            } else {
                extKey = prefix + "." + key;
            }
            env.putIfAbsent(extKey, value);
            if (context.containsKey(extKey)) continue;
            context.put(extKey, (Object)value);
        }
    }

    private void mkdirs(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Can't mkdir: " + dir.getAbsolutePath());
        }
    }
}

