/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code;

import io.polaris.builder.code.CodeLogger;
import io.polaris.builder.code.CodeWriter;
import io.polaris.builder.code.JdbcTypes;
import io.polaris.builder.code.config.CodeEnv;
import io.polaris.builder.code.config.CodeEnvBuilder;
import io.polaris.builder.code.config.CodeGroup;
import io.polaris.builder.code.config.CodeTable;
import io.polaris.builder.code.config.ConfigColumn;
import io.polaris.builder.code.config.ConfigParser;
import io.polaris.builder.code.config.TypeMapping;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.builder.code.reader.TablesReader;
import io.polaris.builder.code.reader.TablesReaders;
import io.polaris.core.io.IO;
import io.polaris.core.regex.Patterns;
import io.polaris.core.string.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class CodeGenerator {
    private CodeEnvBuilder codeEnvBuilder;
    private CodeEnv codeEnv;
    private TablesReader tablesReader;
    private String codeXmlPath;
    private String jdbcXmlPath;
    private String dataXmlPath;
    private Map<CodeTable, TableDto> tables = new LinkedHashMap<CodeTable, TableDto>();

    public void generate() throws IOException {
        this.readConfig();
        new CodeWriter(this.codeEnv, this.tables).write();
    }

    public CodeGenerator logWithStd(boolean withStd) {
        CodeLogger.withStd(withStd);
        return this;
    }

    public CodeEnvBuilder codeEnvBuilder() {
        if (this.codeEnvBuilder == null) {
            this.codeEnvBuilder = new CodeEnvBuilder(this, new CodeEnv());
        }
        return this.codeEnvBuilder;
    }

    private void readConfig() throws IOException {
        try {
            this.buildConfig();
            this.readTables();
        }
        finally {
            if (this.tablesReader != null) {
                this.tablesReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTables() {
        List<CodeGroup> groups = this.codeEnv.getGroups();
        if (groups == null) {
            return;
        }
        Set<TypeMapping> mappings = this.codeEnv.getMappings();
        if (mappings != null) {
            JdbcTypes.createCustomMappings();
            mappings.forEach(m -> JdbcTypes.addCustomMapping(m.getJdbcType(), m.getJavaType()));
        }
        try {
            for (CodeGroup group : groups) {
                if (group.getTables() == null) continue;
                this.readTables(group);
            }
        }
        finally {
            if (mappings != null) {
                JdbcTypes.removeCustomMappings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTables(CodeGroup group) {
        Set<TypeMapping> mappings = group.getMappings();
        if (mappings != null) {
            JdbcTypes.createCustomMappings();
            mappings.forEach(m -> JdbcTypes.addCustomMapping(m.getJdbcType(), m.getJavaType()));
        }
        try {
            for (CodeTable tableConfig : group.getTables()) {
                String tableName;
                String schemaName;
                String catalogName = StringUtils.trimToNull((String)tableConfig.getCatalog());
                TableDto table = this.tablesReader.read(catalogName, schemaName = StringUtils.trimToNull((String)tableConfig.getSchema()), tableName = StringUtils.trimToNull((String)tableConfig.getName()));
                if (table == null) {
                    CodeLogger.error("\u627e\u4e0d\u5230\u8868\u4fe1\u606f\uff1a[{}]", tableConfig.getName());
                    continue;
                }
                table.setCatalog(catalogName);
                table.setSchema(schemaName);
                this.readTables(group, tableConfig, table);
            }
        }
        finally {
            if (mappings != null) {
                JdbcTypes.removeCustomMappings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTables(CodeGroup group, CodeTable tableConfig, TableDto table) {
        Set<TypeMapping> mappings = tableConfig.getMappings();
        if (mappings != null) {
            JdbcTypes.createCustomMappings();
            mappings.forEach(m -> JdbcTypes.addCustomMapping(m.getJdbcType(), m.getJavaType()));
        }
        try {
            table = table.clone();
            if (StringUtils.isNotEmpty((CharSequence)tableConfig.getJavaPackage())) {
                table.setJavaPackageName(tableConfig.getJavaPackage());
            }
            table.setProperty(tableConfig.getProperty());
            HashMap<String, ConfigColumn> columnMap = new HashMap<String, ConfigColumn>();
            Set<ConfigColumn> columnSet = tableConfig.getColumns();
            if (columnSet != null) {
                columnSet.forEach(c -> {
                    if (Strings.isNotBlank((CharSequence)c.getName())) {
                        columnMap.put(c.getName(), (ConfigColumn)c);
                    }
                });
            }
            LinkedHashSet<String> ignoredColumns = new LinkedHashSet<String>();
            if (this.codeEnv.getIgnoredColumns() != null) {
                ignoredColumns.addAll(this.codeEnv.getIgnoredColumns());
            }
            if (group.getIgnoredColumns() != null) {
                ignoredColumns.addAll(group.getIgnoredColumns());
            }
            if (tableConfig.getIgnoredColumns() != null) {
                ignoredColumns.addAll(tableConfig.getIgnoredColumns());
            }
            HashSet removedColumns = new HashSet();
            table.getNormalColumns().removeIf(c -> {
                if (columnSet != null && columnSet.stream().anyMatch(o -> o.isIgnored() && c.getName().equals(o.getName()))) {
                    return true;
                }
                if (ignoredColumns.stream().anyMatch(regex -> Patterns.getPattern((String)regex, (int)2).matcher(c.getName()).matches())) {
                    removedColumns.add(c.getName());
                    return true;
                }
                return false;
            });
            table.getColumns().removeIf(c -> removedColumns.contains(c.getName()));
            Set<String> tablePrefix = this.splitToSet(tableConfig.getTablePrefix(), group.getTablePrefix(), this.codeEnv.getTablePrefix());
            Set<String> tableSuffix = this.splitToSet(tableConfig.getTableSuffix(), group.getTableSuffix(), this.codeEnv.getTableSuffix());
            Set<String> columnPrefix = this.splitToSet(tableConfig.getColumnPrefix(), group.getColumnPrefix(), this.codeEnv.getColumnPrefix());
            Set<String> columnSuffix = this.splitToSet(tableConfig.getColumnSuffix(), group.getColumnSuffix(), this.codeEnv.getColumnSuffix());
            table.prepare4Java(this.buildNameTrimmer(tablePrefix, tableSuffix), this.buildNameTrimmer(columnPrefix, columnSuffix), columnMap);
            this.tables.put(tableConfig, table);
        }
        finally {
            if (mappings != null) {
                JdbcTypes.removeCustomMappings();
            }
        }
    }

    private Function<String, String> buildNameTrimmer(Set<String> prefixSet, Set<String> suffixSet) {
        return name -> {
            boolean handled = true;
            while (handled) {
                handled = false;
                if (prefixSet != null) {
                    for (String prefix : prefixSet) {
                        if (prefix.length() <= 0 || !name.startsWith(prefix)) continue;
                        name = name.substring(prefix.length());
                        handled = true;
                    }
                }
                if (suffixSet == null) continue;
                for (String suffix : suffixSet) {
                    if (suffix.length() <= 0 || !name.endsWith(suffix)) continue;
                    name = name.substring(0, name.length() - suffix.length());
                    handled = true;
                }
            }
            return name;
        };
    }

    private Set<String> splitToSet(String ... strs) {
        HashSet<String> set = new HashSet<String>();
        for (String str : strs) {
            String[] arr;
            if (str == null || str.length() == 0) continue;
            for (String s : arr = str.split(",")) {
                if ((s = s.trim()).length() <= 0) continue;
                set.add(s);
            }
        }
        return set;
    }

    private void buildConfig() throws IOException {
        if (this.codeEnv == null) {
            if (this.codeEnvBuilder != null) {
                this.codeEnv = this.codeEnvBuilder.build();
            } else {
                if (StringUtils.isBlank((CharSequence)this.codeXmlPath) || !new File(this.codeXmlPath).isFile()) {
                    throw new IllegalArgumentException("\u4ee3\u7801\u751f\u6210\u914d\u7f6e\u4fe1\u606f\u672a\u8bbe\u7f6e");
                }
                this.codeEnv = ConfigParser.parseXml(IO.getInputStream((String)this.codeXmlPath), new CodeEnv());
            }
        }
        if (this.tablesReader == null) {
            this.tablesReader = this.buildTablesReader();
        }
    }

    private TablesReader buildTablesReader() throws IOException {
        InputStream jdbcInput = null;
        try {
            jdbcInput = IO.getInputStream((String)this.jdbcXmlPath);
        }
        catch (FileNotFoundException e) {
            CodeLogger.warn(e.getMessage(), e);
        }
        TablesReader tablesReader = null;
        if (jdbcInput == null) {
            if (StringUtils.isBlank((CharSequence)this.dataXmlPath) || !new File(this.dataXmlPath).isFile()) {
                throw new IllegalArgumentException("Jdbc\u8fde\u63a5\u914d\u7f6e\u4e0eXml\u6570\u636e\u6e90\u6587\u4ef6\u5747\u4e0d\u5b58\u5728");
            }
            tablesReader = TablesReaders.newXmlTablesReader(new File(this.dataXmlPath));
        } else if (StringUtils.isBlank((CharSequence)this.dataXmlPath)) {
            tablesReader = TablesReaders.newJdbcTablesReader(jdbcInput);
        } else {
            File dataXmlFile = new File(this.dataXmlPath);
            if (!dataXmlFile.exists()) {
                dataXmlFile.getAbsoluteFile().getParentFile().mkdirs();
                try (PrintWriter writer = new PrintWriter(dataXmlFile);){
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<tables></tables>");
                    writer.flush();
                }
            }
            tablesReader = dataXmlFile.isFile() ? TablesReaders.newTablesReader(dataXmlFile, jdbcInput) : TablesReaders.newJdbcTablesReader(jdbcInput);
        }
        return tablesReader;
    }

    public CodeGenerator codeEnv(CodeEnv codeEnv) {
        this.codeEnv = codeEnv;
        return this;
    }

    public CodeGenerator tablesReader(TablesReader tablesReader) {
        this.tablesReader = tablesReader;
        return this;
    }

    public CodeGenerator codeXmlPath(String codeXmlPath) {
        this.codeXmlPath = codeXmlPath;
        return this;
    }

    public CodeGenerator jdbcXmlPath(String jdbcXmlPath) {
        this.jdbcXmlPath = jdbcXmlPath;
        return this;
    }

    public CodeGenerator dataXmlPath(String dataXmlPath) {
        this.dataXmlPath = dataXmlPath;
        return this;
    }
}

