/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.changer;

import io.polaris.builder.changer.Changer;
import io.polaris.builder.changer.ChangerDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangerRunner {
    private static final Logger log = LoggerFactory.getLogger(ChangerRunner.class);

    public static void main(String[] args) throws IOException, DocumentException, NoSuchAlgorithmException {
        if (args.length == 0) {
            throw new IllegalArgumentException();
        }
        File file = new File(args[0]);
        ChangerRunner.change(file);
    }

    public static void change(File file) throws DocumentException, IOException, NoSuchAlgorithmException {
        try (FileInputStream in = new FileInputStream(file);){
            ChangerRunner.change(in);
        }
    }

    public static ChangerDto parse(Element element) {
        String s;
        String extensions;
        String includeFileName;
        String copyAll;
        String dest;
        String src;
        ChangerDto dto = new ChangerDto();
        String charset = element.elementTextTrim("charset");
        if (StringUtils.isNotBlank((CharSequence)charset)) {
            dto.setCharset(Charset.forName(charset));
        }
        if (StringUtils.isNotBlank((CharSequence)(src = element.elementTextTrim("src")))) {
            dto.setSrc(src);
        }
        if (StringUtils.isNotBlank((CharSequence)(dest = element.elementTextTrim("dest")))) {
            dto.setDest(dest);
        }
        if ((copyAll = element.elementTextTrim("copy-all")) != null && !copyAll.isEmpty()) {
            dto.setCopyAll(Boolean.valueOf(copyAll));
        }
        if ((includeFileName = element.elementTextTrim("include-filename")) != null && !includeFileName.isEmpty()) {
            dto.setIncludeFilename(Boolean.valueOf(includeFileName));
        }
        if ((extensions = element.elementTextTrim("extensions")) != null && !extensions.isEmpty()) {
            dto.setExtensions(extensions);
        }
        List namePatterns = element.elements("name-pattern");
        for (Element e : namePatterns) {
            s = e.getTextTrim();
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (dto.getNamePatterns() == null) {
                dto.setNamePatterns(new LinkedHashSet<String>());
            }
            dto.getNamePatterns().add(s);
        }
        List ignorePatterns = element.elements("ignore-pattern");
        for (Element e : ignorePatterns) {
            s = e.getTextTrim();
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (dto.getIgnorePatterns() == null) {
                dto.setIgnorePatterns(new LinkedHashSet<String>());
            }
            dto.getIgnorePatterns().add(s);
        }
        List ignoreMappingPatterns = element.elements("ignore-mapping-pattern");
        for (Element e : ignoreMappingPatterns) {
            s = e.getTextTrim();
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (dto.getIgnoreMappingPatterns() == null) {
                dto.setIgnoreMappingPatterns(new LinkedHashSet<String>());
            }
            dto.getIgnoreMappingPatterns().add(s);
        }
        List sourcePathList = element.elements("source-path");
        for (Element e : sourcePathList) {
            s = e.getTextTrim();
            if (StringUtils.isBlank((CharSequence)s)) continue;
            if (dto.getSourcePaths() == null) {
                dto.setSourcePaths(new LinkedHashSet<String>());
            }
            dto.getSourcePaths().add(s);
        }
        List packageList = element.elements("package");
        for (Element e : packageList) {
            String name = e.attributeValue("name");
            String mapping = e.attributeValue("mapping");
            if (StringUtils.isBlank((CharSequence)name) || StringUtils.isBlank((CharSequence)mapping)) continue;
            if (dto.getPackageMapping() == null) {
                dto.setPackageMapping(new LinkedHashMap<String, String>());
            }
            dto.getPackageMapping().put(name, mapping);
        }
        return dto;
    }

    public static void change(InputStream in) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(in);
        Element root = doc.getRootElement();
        ChangerDto parent = ChangerRunner.parse(root);
        List changes = root.elements("change");
        for (Element change : changes) {
            try {
                ChangerDto dto = ChangerRunner.parse(change);
                dto.mergeFrom(parent);
                ChangerRunner.change(dto);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public static void change(ChangerDto dto) throws IOException, NoSuchAlgorithmException {
        Map<String, String> packageMapping;
        Set<String> sourcePaths;
        Set<String> ignorePatterns;
        Set<String> ignoreMappingPatterns;
        Set<String> namePatterns;
        String extensions;
        Changer pc = new Changer();
        pc.setCharset(dto.getCharset());
        pc.setSrcRoot(new File(dto.getSrc()));
        pc.setDestRoot(new File(dto.getDest()));
        if (dto.getCopyAll() != null) {
            pc.setCopyAll(dto.getCopyAll());
        }
        if (dto.getIncludeFilename() != null) {
            pc.setIncludeFileName(dto.getIncludeFilename());
        }
        if ((extensions = dto.getExtensions()) != null && !extensions.isEmpty()) {
            String[] arr;
            for (String s : arr = extensions.split("[,;|\\s]+")) {
                if (s.trim().isEmpty()) continue;
                pc.addExtension(s.trim());
            }
        }
        if ((namePatterns = dto.getNamePatterns()) != null) {
            for (String namePattern : namePatterns) {
                if (namePattern.trim().isEmpty()) continue;
                pc.addNamePatterns(Pattern.compile(namePattern.trim()));
            }
        }
        if ((ignoreMappingPatterns = dto.getIgnoreMappingPatterns()) != null) {
            for (String ignoreMappingPattern : ignoreMappingPatterns) {
                if (ignoreMappingPattern.trim().isEmpty()) continue;
                pc.addIgnoreMappingPatterns(Pattern.compile(ignoreMappingPattern.trim()));
            }
        }
        if ((ignorePatterns = dto.getIgnorePatterns()) != null) {
            for (String ignorePattern : ignorePatterns) {
                if (ignorePattern.trim().isEmpty()) continue;
                pc.addIgnorePatterns(Pattern.compile(ignorePattern.trim()));
            }
        }
        if ((sourcePaths = dto.getSourcePaths()) != null) {
            for (String path : sourcePaths) {
                if (path.trim().isEmpty()) continue;
                pc.addSourcePath(path.trim());
            }
        }
        if ((packageMapping = dto.getPackageMapping()) != null) {
            packageMapping.forEach(pc::addMapping);
        }
        pc.execute();
    }
}

