/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.dbv.cfg;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.security.AnyTypePermission;
import io.polaris.builder.dbv.cfg.DatabaseCfg;
import io.polaris.builder.dbv.cfg.DatabaseType;
import io.polaris.builder.dbv.cfg.SqlCfg;
import io.polaris.core.io.IO;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configurations {
    private static final Logger log = LoggerFactory.getLogger(Configurations.class);
    private static final String DATABASE_XML = "/META-INF/dbv/database.xml";

    public static XStream buildXStream() {
        XStream xs = new XStream();
        xs.ignoreUnknownElements();
        xs.addPermission(AnyTypePermission.ANY);
        xs.autodetectAnnotations(true);
        xs.processAnnotations(DatabaseCfg.class);
        xs.processAnnotations(SqlCfg.class);
        xs.registerConverter(new Converter(){

            public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                SqlCfg sql = (SqlCfg)source;
                writer.addAttribute("id", sql.getId());
                writer.setValue(sql.getSql());
            }

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                SqlCfg sql = new SqlCfg();
                sql.setId(reader.getAttribute("id"));
                sql.setSql(reader.getValue());
                return sql;
            }

            public boolean canConvert(Class type) {
                return SqlCfg.class.isAssignableFrom(type);
            }
        });
        return xs;
    }

    private static InputStream getDatabaseCfgInputStream() throws FileNotFoundException {
        return IO.getInputStream((String)DATABASE_XML);
    }

    private static InputStream getDatabaseCfgInputStream(String cfgPath) throws FileNotFoundException {
        return IO.getInputStream((String)cfgPath);
    }

    public static DatabaseCfg getDatabaseCfg(String cfgPath) throws FileNotFoundException {
        InputStream in = Configurations.getDatabaseCfgInputStream(cfgPath);
        return Configurations.getDatabaseCfg(in);
    }

    public static DatabaseCfg getDatabaseCfg() throws FileNotFoundException {
        InputStream in = Configurations.getDatabaseCfgInputStream();
        return Configurations.getDatabaseCfg(in);
    }

    public static DatabaseCfg getDatabaseCfg(InputStream in) {
        return Configurations.getDatabaseCfg(in, new DatabaseCfg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseCfg getDatabaseCfg(InputStream in, DatabaseCfg cfg) {
        try {
            XStream xs = Configurations.buildXStream();
            xs.fromXML(in, (Object)cfg);
            Configurations.loadJdbcInfoProperties(cfg);
            Configurations.loadExtCfg(cfg, xs);
            DatabaseCfg databaseCfg = cfg;
            return databaseCfg;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            DatabaseCfg databaseCfg = null;
            return databaseCfg;
        }
        finally {
            IO.close((AutoCloseable)in);
        }
    }

    private static void loadExtCfg(DatabaseCfg cfg, XStream xs) {
        block14: {
            try {
                DatabaseType type;
                String databaseType = cfg.getDatabaseType();
                if (databaseType == null || (type = DatabaseType.valueOf(databaseType)).getCfgFile() == null) break block14;
                try (InputStream extCfgFile = Configurations.getDatabaseCfgInputStream(type.getCfgFile());){
                    xs.fromXML(extCfgFile, (Object)cfg);
                }
            }
            catch (Exception e) {
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void loadJdbcInfoProperties(DatabaseCfg cfg) throws IOException {
        try {
            Properties info = cfg.getJdbcInfoProperties();
            String jdbcInfoPropertiesPath = cfg.getJdbcInfoPropertiesPath();
            if (jdbcInfoPropertiesPath != null) {
                info.load(IO.getInputStream((String)jdbcInfoPropertiesPath));
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

