/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.reader.impl;

import io.polaris.builder.code.JdbcTypes;
import io.polaris.builder.code.dto.ColumnDto;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.builder.code.reader.TablesReader;
import io.polaris.builder.dbv.cfg.Configurations;
import io.polaris.builder.dbv.cfg.DatabaseCfg;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.jdbc.dbv.Dbv;
import io.polaris.core.jdbc.dbv.model.Column;
import io.polaris.core.jdbc.dbv.model.Table;
import io.polaris.core.string.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class JdbcTablesReader
implements TablesReader {
    private final DatabaseCfg cfg;
    private Connection conn;

    public JdbcTablesReader(DatabaseCfg cfg) {
        this.cfg = cfg;
    }

    public JdbcTablesReader(File jdbcCfgFile) throws IOException {
        this.cfg = Configurations.getDatabaseCfg(new FileInputStream(jdbcCfgFile));
    }

    public JdbcTablesReader(InputStream jdbcCfgFileInput) throws IOException {
        this.cfg = Configurations.getDatabaseCfg(jdbcCfgFileInput);
    }

    @Override
    public TableDto read(String catalogName, String schemaName, String tableName) {
        try {
            DatabaseMetaData metaData;
            List tables;
            if (this.conn == null || this.conn.isClosed()) {
                this.conn = Jdbcs.getConnection((String)this.cfg.getJdbcDriver(), (String)this.cfg.getJdbcUrl(), (Properties)this.cfg.getJdbcInfoProperties());
            }
            if ((tables = Dbv.readTables((DatabaseMetaData)(metaData = this.conn.getMetaData()), (String)catalogName, (String)schemaName, (String)tableName, null)) != null && tables.size() > 0) {
                Table tab = (Table)tables.get(0);
                TableDto table = new TableDto();
                table.setName(tab.getTableName());
                table.setComment(Strings.coalesce((String[])new String[]{tab.getRemarks(), tab.getTableName()}));
                Set pkColumns = tab.getPkColumns();
                List columnList = tab.getColumnList();
                for (Column col : columnList) {
                    ColumnDto column = new ColumnDto();
                    column.setName(col.getColumnName());
                    column.setType(col.getDataType());
                    column.setComment(Strings.coalesce((String[])new String[]{col.getRemarks(), col.getColumnName()}));
                    column.setDefaultValue(col.getColumnDef());
                    column.setNullable(!col.isNotNull());
                    column.setPrimary(col.isPrimaryKey());
                    column.setColumnSize(col.getColumnSize());
                    column.setDecimalDigits(col.getDecimalDigits());
                    column.setAutoincrement(col.isAutoincrement());
                    column.setGenerated(col.isGenerated());
                    column.setJdbcType(JdbcTypes.getTypeName(col.getDataType()));
                    column.setJavaType(JdbcTypes.getJavaType(col.getDataType(), col.getColumnSize(), col.getDecimalDigits()).getCanonicalName());
                    table.getColumns().add(column);
                    if (pkColumns.contains(col.getColumnName())) {
                        column.setPrimary(true);
                        table.getPkColumns().add(column);
                        continue;
                    }
                    table.getNormalColumns().add(column);
                }
                return table;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void close() {
        Jdbcs.close((Connection)this.conn);
    }
}

