/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.config;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import io.polaris.builder.code.config.CodeEnv;
import io.polaris.builder.code.config.CodeGroup;
import io.polaris.builder.code.config.CodeTable;
import io.polaris.builder.code.config.CodeTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class ConfigParser {
    public static XStream buildXStream() {
        XStream xs = new XStream();
        xs.ignoreUnknownElements();
        xs.autodetectAnnotations(true);
        xs.processAnnotations(CodeEnv.class);
        xs.processAnnotations(CodeGroup.class);
        xs.processAnnotations(CodeTable.class);
        xs.processAnnotations(CodeTemplate.class);
        return xs;
    }

    public static <T> T parseJson(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static <T> T parseJson(InputStream in, Class<T> clazz) throws IOException {
        return (T)JSON.parseObject((InputStream)in, clazz, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    public static <T> T parseYaml(String text, Class<T> clazz) {
        Yaml yaml = new Yaml();
        Object o = yaml.load(text);
        String jsonString = JSON.toJSONString((Object)o);
        return ConfigParser.parseJson(jsonString, clazz);
    }

    public static <T> T parseYaml(InputStream in, Class<T> clazz) throws IOException {
        return ConfigParser.parseYaml(IOUtils.toString((InputStream)in, (Charset)Charset.defaultCharset()), clazz);
    }

    public static <T> T parseXml(String text, Class<T> clazz) throws ReflectiveOperationException {
        XStream xs = ConfigParser.buildXStream();
        return (T)xs.fromXML(text, clazz.newInstance());
    }

    public static <T> T parseXml(InputStream in, Class<T> clazz) throws ReflectiveOperationException {
        XStream xs = ConfigParser.buildXStream();
        return (T)xs.fromXML(in, clazz.newInstance());
    }

    public static <T> T parseXml(String text, T t) {
        XStream xs = ConfigParser.buildXStream();
        return (T)xs.fromXML(text, t);
    }

    public static <T> T parseXml(InputStream in, T t) {
        XStream xs = ConfigParser.buildXStream();
        return (T)xs.fromXML(in, t);
    }

    public static String toYaml(Object o) {
        Object json = JSON.toJSON((Object)o);
        Yaml yaml = new Yaml();
        return yaml.dump(json);
    }

    public static class PropertyConverter
    implements Converter {
        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Map map = (Map)source;
            map.forEach((key, value) -> {
                writer.startNode("entry");
                writer.addAttribute("key", key.toString());
                writer.addAttribute("value", value.toString());
                writer.endNode();
            });
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String key = reader.getAttribute("key");
                String value = reader.getAttribute("value");
                map.put(key, value);
                reader.moveUp();
            }
            return map;
        }

        public boolean canConvert(Class type) {
            return Map.class.isAssignableFrom(type);
        }
    }
}

