/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.config;

import io.polaris.builder.code.config.CodeGroupBuilder;
import io.polaris.builder.code.config.CodeTemplate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CodeTemplateBuilder {
    private final CodeTemplate target;
    private final CodeGroupBuilder groupBuilder;

    public CodeTemplateBuilder(CodeGroupBuilder groupBuilder, CodeTemplate target) {
        this.groupBuilder = groupBuilder;
        this.target = target;
    }

    public CodeTemplate build() {
        return this.target;
    }

    public CodeGroupBuilder end() {
        return this.groupBuilder;
    }

    public CodeTemplateBuilder path(String path) {
        this.target.setPath(path);
        return this;
    }

    public CodeTemplateBuilder outdir(String outdir) {
        this.target.setDirname(outdir);
        return this;
    }

    public CodeTemplateBuilder filename(String filename) {
        this.target.setFilename(filename);
        return this;
    }

    public CodeTemplateBuilder property(Map<String, String> property) {
        this.target.setProperty(property);
        return this;
    }

    public CodeTemplateBuilder property(Supplier<Map<String, String>> property) {
        this.target.setProperty(property.get());
        return this;
    }

    public CodeTemplateBuilder property(String key, String value) {
        if (this.target.getProperty() == null) {
            this.target.setProperty(new HashMap<String, String>());
        }
        this.target.getProperty().put(key, value);
        return this;
    }
}

