/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.config;

import io.polaris.builder.code.config.CodeGroupBuilder;
import io.polaris.builder.code.config.CodeTable;
import io.polaris.builder.code.config.ConfigColumn;
import io.polaris.builder.code.config.TypeMapping;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CodeTableBuilder {
    private final CodeGroupBuilder groupBuilder;
    private final CodeTable target;

    public CodeTableBuilder(CodeGroupBuilder groupBuilder, CodeTable target) {
        this.groupBuilder = groupBuilder;
        this.target = target;
    }

    public CodeTable build() {
        return this.target;
    }

    public CodeGroupBuilder end() {
        return this.groupBuilder;
    }

    public CodeTableBuilder name(String name) {
        this.target.setName(name);
        return this;
    }

    public CodeTableBuilder catalog(String catalog) {
        this.target.setCatalog(catalog);
        return this;
    }

    public CodeTableBuilder schema(String schema) {
        this.target.setSchema(schema);
        return this;
    }

    public CodeTableBuilder javaPackage(String javaPackage) {
        this.target.setJavaPackage(javaPackage);
        return this;
    }

    public CodeTableBuilder property(Map<String, String> property) {
        this.target.setProperty(property);
        return this;
    }

    public CodeTableBuilder property(Supplier<Map<String, String>> property) {
        this.target.setProperty(property.get());
        return this;
    }

    public CodeTableBuilder property(String key, String value) {
        if (this.target.getProperty() == null) {
            this.target.setProperty(new HashMap<String, String>());
        }
        this.target.getProperty().put(key, value);
        return this;
    }

    public CodeTableBuilder tablePrefix(String tablePrefix) {
        this.target.setTablePrefix(tablePrefix);
        return this;
    }

    public CodeTableBuilder tableSuffix(String tableSuffix) {
        this.target.setTableSuffix(tableSuffix);
        return this;
    }

    public CodeTableBuilder columnPrefix(String columnPrefix) {
        this.target.setColumnPrefix(columnPrefix);
        return this;
    }

    public CodeTableBuilder columnSuffix(String columnSuffix) {
        this.target.setColumnSuffix(columnSuffix);
        return this;
    }

    public CodeTableBuilder mappings(Set<TypeMapping> mappings) {
        this.target.setMappings(mappings);
        return this;
    }

    public CodeTableBuilder mappings(Supplier<Set<TypeMapping>> mappings) {
        this.target.setMappings(mappings.get());
        return this;
    }

    public CodeTableBuilder mapping(String jdbcType, String javaType) {
        if (this.target.getMappings() == null) {
            this.target.setMappings(new LinkedHashSet<TypeMapping>());
        }
        this.target.getMappings().add(new TypeMapping(jdbcType, javaType));
        return this;
    }

    public CodeTableBuilder columns(Set<ConfigColumn> columns) {
        this.target.setColumns(columns);
        return this;
    }

    public CodeTableBuilder columns(Supplier<Set<ConfigColumn>> columns) {
        this.target.setColumns(columns.get());
        return this;
    }

    public CodeTableBuilder column(String name, String javaType) {
        if (this.target.getColumns() == null) {
            this.target.setColumns(new LinkedHashSet<ConfigColumn>());
        }
        this.target.getColumns().add(new ConfigColumn(name, javaType));
        return this;
    }
}

