/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code;

import io.polaris.builder.code.CodeLogger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class JdbcTypes {
    private static final Map<Integer, String> typeNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> typeValues = new HashMap<String, Integer>();
    private static final Map<Integer, Class> javaTypes = new HashMap<Integer, Class>();
    private static final ThreadLocal<Deque<Map<Integer, Class>>> local = new ThreadLocal();

    private static void buildJavaTypes() {
        javaTypes.put(-7, Boolean.class);
        javaTypes.put(-6, Byte.class);
        javaTypes.put(5, Short.class);
        javaTypes.put(4, Integer.class);
        javaTypes.put(-5, Long.class);
        javaTypes.put(6, Double.class);
        javaTypes.put(7, Float.class);
        javaTypes.put(8, Double.class);
        javaTypes.put(2, BigDecimal.class);
        javaTypes.put(3, BigDecimal.class);
        javaTypes.put(1, String.class);
        javaTypes.put(12, String.class);
        javaTypes.put(-1, String.class);
        javaTypes.put(91, Date.class);
        javaTypes.put(92, Time.class);
        javaTypes.put(93, Timestamp.class);
        javaTypes.put(-2, byte[].class);
        javaTypes.put(-3, byte[].class);
        javaTypes.put(-4, byte[].class);
        javaTypes.put(2004, byte[].class);
        javaTypes.put(2005, String.class);
        javaTypes.put(-15, String.class);
        javaTypes.put(-9, String.class);
        javaTypes.put(-16, String.class);
        javaTypes.put(2011, String.class);
        javaTypes.put(2002, Struct.class);
        javaTypes.put(2006, Ref.class);
        javaTypes.put(2003, Array.class);
        javaTypes.put(-8, RowId.class);
        javaTypes.put(2012, ResultSet.class);
    }

    public static void removeCustomMappings() {
        Deque<Map<Integer, Class>> queue = local.get();
        if (queue == null) {
            return;
        }
        queue.pollFirst();
        if (queue.isEmpty()) {
            local.remove();
        }
    }

    public static Map<Integer, Class> createCustomMappings() {
        Deque<Map<Integer, Class>> queue = local.get();
        if (queue == null) {
            queue = new LinkedList<Map<Integer, Class>>();
            local.set(queue);
        }
        HashMap<Integer, Class> map = new HashMap<Integer, Class>();
        queue.offerFirst(map);
        return map;
    }

    public static boolean addCustomMapping(String jdbcType, String javaType) {
        Class<?> c;
        try {
            c = Class.forName(javaType);
        }
        catch (ClassNotFoundException e) {
            if (!javaType.contains(".")) {
                try {
                    c = Class.forName("java.lang." + javaType);
                }
                catch (ClassNotFoundException ex) {
                    CodeLogger.warn("", e);
                    return false;
                }
            }
            CodeLogger.warn("", e);
            return false;
        }
        Integer type = JdbcTypes.getTypeValue(jdbcType);
        if (type == null) {
            return false;
        }
        return JdbcTypes.addCustomMapping(type, c);
    }

    public static boolean addCustomMapping(int jdbcType, Class javaType) {
        Deque<Map<Integer, Class>> queue = local.get();
        if (queue == null || queue.isEmpty()) {
            return false;
        }
        queue.peekFirst().put(jdbcType, javaType);
        return true;
    }

    public static Class getCustomJavaType(int type) {
        Deque<Map<Integer, Class>> queue = local.get();
        if (queue != null) {
            for (Map<Integer, Class> next : queue) {
                Class c = next.get(type);
                if (c == null) continue;
                return c;
            }
        }
        return null;
    }

    public static Class getJavaType(int type) {
        return javaTypes.get(type);
    }

    public static Class getJavaType(int type, int columnSize, int decimalDigits) {
        Class c = javaTypes.get(type);
        if (Number.class.isAssignableFrom(c) && decimalDigits == 0) {
            c = columnSize == 1 ? Boolean.class : (columnSize <= 10 ? Integer.class : Long.class);
        }
        return c;
    }

    public static Integer getTypeValue(String jdbcTypeName) {
        return typeValues.get(jdbcTypeName);
    }

    public static Integer getTypeValue(String jdbcTypeName, int defaultVal) {
        return typeValues.getOrDefault(jdbcTypeName, defaultVal);
    }

    public static String getTypeName(int jdbcType) {
        return typeNames.get(jdbcType);
    }

    public static String getTypeName(int jdbcType, String defaultVal) {
        return typeNames.getOrDefault(jdbcType, defaultVal);
    }

    static {
        try {
            Field[] fields;
            for (Field field : fields = Types.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                String name = field.getName();
                Integer val = (Integer)field.get(null);
                typeNames.put(val, name);
                typeValues.put(name, val);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JdbcTypes.buildJavaTypes();
    }
}

