/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.velocity;

import io.polaris.core.io.IO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.ConfigurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityTemplate {
    private static final Logger log = LoggerFactory.getLogger((String)"code.template");
    private static final ThreadLocal<VelocityEngine> local = ThreadLocal.withInitial(() -> {
        VelocityEngine ve = new VelocityEngine();
        Properties properties = new Properties();
        properties.setProperty("resource.default_encoding", "UTF-8");
        properties.setProperty("resource.loaders", "classpath");
        properties.setProperty("resource.loader.classpath.class", ClasspathResourceLoader.class.getName());
        try {
            properties.load(IO.getInputStream((String)"velocity.properties", VelocityTemplate.class));
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        ve.setProperties(properties);
        ve.init();
        return ve;
    });
    private static VelocityEngine singleton = local.get();
    private static ToolManager toolManager = new ToolManager();

    public static BufferedReader getTemplateReader(String template) throws IOException {
        return new BufferedReader(new InputStreamReader(IO.getInputStream((String)template), Charset.defaultCharset()));
    }

    public static Context createContext() {
        toolManager.configure(ConfigurationUtils.getGenericTools());
        ToolContext context = toolManager.createContext();
        return context;
    }

    public static void write(Context context, Writer writer, String template) throws VelocityException {
        try {
            VelocityTemplate.write(context, writer, VelocityTemplate.getTemplateReader(template));
        }
        catch (VelocityException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new VelocityException((Throwable)e);
        }
    }

    public static void write(Context context, Writer writer, Reader reader) throws VelocityException {
        try {
            singleton.evaluate(context, writer, "", reader);
        }
        catch (VelocityException e) {
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new VelocityException((Throwable)e);
        }
    }

    public static String eval(Context context, String expression) {
        StringWriter stringWriter = new StringWriter();
        VelocityTemplate.write(context, (Writer)stringWriter, new StringReader(expression));
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static String mergeAsString(String templateName, Context context) throws VelocityException {
        return VelocityTemplate.mergeAsString(templateName, Charset.defaultCharset().name(), context);
    }

    public static String mergeAsString(String templateName, String encoding, Context context) throws VelocityException {
        StringWriter writer = new StringWriter();
        VelocityTemplate.merge(templateName, encoding, context, writer);
        return ((Object)writer).toString();
    }

    public static void merge(String templateName, String encoding, Context context, Writer writer) throws VelocityException {
        local.get().mergeTemplate(templateName, encoding, context, writer);
    }
}

