/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.dbv;

import io.polaris.builder.dbv.CellMergeArea;
import io.polaris.builder.dbv.DbCommentSplits;
import io.polaris.builder.dbv.ExcelIndexConfig;
import io.polaris.builder.dbv.ExcelTemplateConfig;
import io.polaris.core.jdbc.dbv.model.Index;
import io.polaris.core.jdbc.dbv.model.PrimaryKey;
import io.polaris.core.jdbc.dbv.model.Table;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DbvExp {
    private static final String EXCEL_TPL_NAME = "/META-INF/dbv/tables.xlsm";
    private static final ExcelTemplateConfig DEFAULT_TEMPLATE_CONFIG = new ExcelTemplateConfig();
    public static final ExcelIndexConfig DEFAULT_INDEX_CONFIG = new ExcelIndexConfig();

    public static InputStream getTemplateExcelStream() {
        InputStream in = DbvExp.class.getResourceAsStream(EXCEL_TPL_NAME);
        return in;
    }

    public static XSSFWorkbook newXSSFWorkbook(InputStream in) throws IOException {
        XSSFWorkbook book = new XSSFWorkbook(in);
        return book;
    }

    public static List<String> getTables(XSSFWorkbook book) {
        XSSFSheet idxSheet = book.getSheet("\u76ee\u5f55");
        ArrayList<String> list = new ArrayList<String>();
        int minRow = 4;
        int maxRow = idxSheet.getLastRowNum();
        for (int iRow = minRow; iRow <= maxRow; ++iRow) {
            XSSFRow row = idxSheet.getRow(iRow);
            XSSFCell cell = row.getCell(3);
            String table = cell.getStringCellValue();
            if (!StringUtils.isNotBlank((CharSequence)table)) continue;
            list.add(table.trim());
        }
        return list;
    }

    public static void addTableIndex(XSSFWorkbook book, Table table) {
        DbvExp.addTableIndex(book, table, DEFAULT_INDEX_CONFIG);
    }

    public static void addTableIndex(XSSFWorkbook book, Table table, ExcelIndexConfig config) {
        XSSFSheet idxSheet = book.getSheet(config.getIndexSheetName());
        int minRow = config.getTableRowBegin();
        int maxRow = idxSheet.getLastRowNum();
        int blankRow = maxRow + 1;
        for (int iRow = minRow; iRow <= maxRow; ++iRow) {
            XSSFRow row = idxSheet.getRow(iRow);
            XSSFCell cell = row.getCell(3);
            String stringCellValue = cell.getStringCellValue();
            if (!StringUtils.isNotBlank((CharSequence)stringCellValue) || !stringCellValue.equalsIgnoreCase(table.getTableName())) continue;
            return;
        }
        DbvExp.copy(idxSheet, config.getTableRowTemplate(), 0, idxSheet, blankRow, 0, 25);
        XSSFRow row = idxSheet.getRow(blankRow);
        row.getCell(config.getTableColName()).setCellValue(table.getTableName());
        Tuple2<String, String> tuple = DbCommentSplits.split(table.getRemarks());
        String label = (String)tuple.getFirst();
        String remarks = (String)tuple.getSecond();
        row.getCell(config.getTableColLabel()).setCellValue(label);
        row.getCell(config.getTableColLink()).setCellFormula("HYPERLINK(\"#'\"&D" + (blankRow + 1) + "&\"'!A1\",\"====>>\")");
        row.getCell(config.getTableColRemark()).setCellValue(remarks);
    }

    public static void addTable(XSSFWorkbook book, Table table) {
        DbvExp.addTable(book, table, DEFAULT_TEMPLATE_CONFIG);
    }

    public static void addTable(XSSFWorkbook book, Table table, ExcelTemplateConfig config) {
        XSSFSheet tplSheet = book.getSheet(config.getTemplateSheetName());
        String sheetName = Strings.coalesce((String[])new String[]{table.getTableName()});
        if (book.getSheet(sheetName) != null) {
            book.removeSheetAt(book.getSheetIndex(sheetName));
        }
        XSSFSheet sheet = book.createSheet(sheetName);
        for (int i = 0; i <= config.getColumnRowBegin(); ++i) {
            DbvExp.copy(tplSheet, i, 0, sheet, i, 0, 25);
        }
        int iRow = config.getColumnRowContent();
        int colNum = 0;
        for (Object col : table.getColumnList()) {
            DbvExp.copy(tplSheet, config.getColumnRowContent(), 0, sheet, iRow, 0, 25);
            sheet.getRow(iRow).getCell(config.getColumnColSeq()).setCellType(CellType.NUMERIC);
            sheet.getRow(iRow).getCell(config.getColumnColSeq()).setCellValue((double)(++colNum));
            sheet.getRow(iRow).getCell(config.getColumnColName()).setCellValue(col.getColumnName());
            Tuple2<String, String> tuple = DbCommentSplits.split(Strings.coalesce((String[])new String[]{col.getRemarks(), col.getColumnName()}));
            String columnLabel = (String)tuple.getFirst();
            String columnRemark = (String)tuple.getSecond();
            sheet.getRow(iRow).getCell(config.getColumnColLabel()).setCellValue(columnLabel);
            String columnType = col.getColumnType();
            sheet.getRow(iRow).getCell(config.getColumnColType()).setCellValue(columnType);
            if (col.isPrimaryKey()) {
                sheet.getRow(iRow).getCell(config.getColumnColPrimary()).setCellValue("Y");
            }
            if (col.isNotNull()) {
                sheet.getRow(iRow).getCell(config.getColumnColNonnull()).setCellValue("Y");
            }
            if (StringUtils.isNotBlank((CharSequence)col.getColumnDef())) {
                sheet.getRow(iRow).getCell(config.getColumnColDefault()).setCellValue(col.getColumnDef());
            }
            if (StringUtils.isNotBlank((CharSequence)columnRemark)) {
                sheet.getRow(iRow).getCell(config.getColumnColRemark()).setCellValue(columnRemark);
            }
            ++iRow;
        }
        DbvExp.copy(tplSheet, config.getColumnRowContent(), 0, sheet, iRow, 0, 25);
        sheet.getRow(iRow).getCell(0).setCellValue((double)(++colNum));
        DbvExp.copy(tplSheet, config.getColumnRowEnd(), 0, sheet, ++iRow, 0, 25);
        DbvExp.copy(tplSheet, Integer.max(config.getIndexRowBegin() - 1, config.getColumnRowEnd() + 1), 0, sheet, ++iRow, 0, 25);
        DbvExp.copy(tplSheet, config.getIndexRowBegin(), 0, sheet, ++iRow, 0, 25);
        sheet.addMergedRegion(new CellRangeAddress(iRow, iRow, config.getIndexColFields(), config.getIndexColUnique() - 1));
        int idxNum = 0;
        block2: for (Index idx : table.getIndexList()) {
            for (PrimaryKey pk : table.getPrimaryKeyList()) {
                if (!pk.getPkName().equals(idx.getIndexName())) continue;
                continue block2;
            }
            DbvExp.copy(tplSheet, config.getIndexRowContent(), 0, sheet, ++iRow, 0, 25);
            sheet.addMergedRegion(new CellRangeAddress(iRow, iRow, config.getIndexColFields(), config.getIndexColUnique() - 1));
            sheet.getRow(iRow).getCell(config.getIndexColSeq()).setCellType(CellType.NUMERIC);
            sheet.getRow(iRow).getCell(config.getIndexColSeq()).setCellValue((double)(++idxNum));
            sheet.getRow(iRow).getCell(config.getIndexColName()).setCellValue(idx.getIndexName());
            sheet.getRow(iRow).getCell(config.getIndexColFields()).setCellValue(idx.getColumnNames());
            sheet.getRow(iRow).getCell(config.getIndexColUnique()).setCellValue(idx.isUnique() ? "Y" : "N");
        }
        DbvExp.copy(tplSheet, config.getIndexRowContent(), 0, sheet, ++iRow, 0, 25);
        sheet.getRow(iRow).getCell(config.getIndexColSeq()).setCellValue((double)(++idxNum));
        DbvExp.copy(tplSheet, config.getIndexRowEnd(), 0, sheet, ++iRow, 0, 25);
        for (int i = 0; i < 25; ++i) {
            sheet.setColumnWidth(i, tplSheet.getColumnWidth(i));
        }
        for (CellMergeArea area : config.getMergeAreas()) {
            sheet.addMergedRegion(new CellRangeAddress(area.getFirstRow() < 0 ? iRow : area.getFirstRow(), area.getLastRow() < 0 ? iRow : area.getLastRow(), area.getFirstCol(), area.getLastCol()));
        }
        sheet.getRow(config.getTableNameCell().getRow()).getCell(config.getTableNameCell().getCol()).setCellValue(sheetName);
        sheet.getRow(config.getTableRemarkCell().getRow()).getCell(config.getTableRemarkCell().getCol()).setCellValue(table.getRemarks());
    }

    private static void copy(XSSFSheet tplSheet, int tplRow, int tplCol, XSSFSheet sheet, int row, int col, int cols) {
        XSSFRow tplSheetRow = tplSheet.getRow(tplRow);
        XSSFRow sheetRow = sheet.createRow(row);
        if (tplSheetRow == null) {
            return;
        }
        for (int i = 0; i < cols; ++i) {
            XSSFCellStyle cellStyle;
            XSSFCell tplSheetCell = tplSheetRow.getCell(tplCol + i);
            XSSFCell sheetCell = sheetRow.createCell(col + i);
            if (tplSheetCell == null) continue;
            XSSFComment cellComment = tplSheetCell.getCellComment();
            if (cellComment != null) {
                sheetCell.setCellComment((Comment)cellComment);
            }
            if ((cellStyle = tplSheetCell.getCellStyle()) != null) {
                sheetCell.setCellStyle((CellStyle)cellStyle);
            }
            CellType cellType = tplSheetCell.getCellType();
            sheetCell.setCellType(cellType);
            switch (cellType) {
                case STRING: {
                    sheetCell.setCellValue(tplSheetCell.getStringCellValue());
                    break;
                }
                case BOOLEAN: {
                    sheetCell.setCellValue(tplSheetCell.getBooleanCellValue());
                    break;
                }
                case NUMERIC: {
                    sheetCell.setCellValue(tplSheetCell.getNumericCellValue());
                    break;
                }
                case ERROR: {
                    sheetCell.setCellValue((double)tplSheetCell.getErrorCellValue());
                    break;
                }
                case FORMULA: {
                    String cellFormula = tplSheetCell.getCellFormula();
                    if (cellFormula == null) break;
                    sheetCell.setCellFormula(cellFormula);
                    break;
                }
                case BLANK: {
                    break;
                }
            }
            XSSFHyperlink hyperlink = tplSheetCell.getHyperlink();
            if (hyperlink == null) continue;
            sheetCell.setHyperlink((Hyperlink)hyperlink);
        }
    }
}

