/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.dbv;

import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import io.polaris.core.tuple.Tuples;

public class DbCommentSplits {
    public static Tuple2<String, String> split(String comment) {
        String columnLabel = Strings.coalesce((String[])new String[]{comment, ""});
        String columnRemark = "";
        int columnLabelSplitIdx = columnLabel.length() - 1;
        if (columnLabelSplitIdx > 0) {
            for (char c : new char[]{'\n', '\r', '\uff08', '(', '\uff1a', ':'}) {
                int i = columnLabel.indexOf(c);
                if (i < 0) continue;
                columnLabelSplitIdx = Integer.min(i, columnLabelSplitIdx);
            }
            if (columnLabelSplitIdx < columnLabel.length() - 1) {
                columnRemark = columnLabel.substring(columnLabelSplitIdx + 1).trim();
                if (!columnRemark.isEmpty()) {
                    char start = columnLabel.charAt(columnLabelSplitIdx);
                    char end = columnRemark.charAt(columnRemark.length() - 1);
                    if (!(start != '(' && start != '\uff08' || end != ')' && end != '\uff09')) {
                        columnRemark = columnRemark.substring(0, columnRemark.length() - 1);
                    }
                }
                columnLabel = columnLabel.substring(0, columnLabelSplitIdx).trim();
            }
        }
        return Tuples.of((Object)columnLabel.trim(), (Object)columnRemark.trim());
    }
}

