/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.reader.impl;

import com.thoughtworks.xstream.XStream;
import io.polaris.builder.code.dto.CatalogDto;
import io.polaris.builder.code.dto.ColumnDto;
import io.polaris.builder.code.dto.SchemaDto;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.builder.code.dto.Tables;
import io.polaris.builder.code.reader.TablesReader;
import io.polaris.core.map.CaseInsensitiveMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;

public class XmlTablesReader
implements TablesReader {
    Tables tables;

    public XmlTablesReader(File xmlDataFile) throws IOException {
        if (!xmlDataFile.exists()) {
            if (xmlDataFile.getParentFile() != null && !xmlDataFile.getParentFile().exists()) {
                xmlDataFile.getParentFile().mkdirs();
            }
            try (PrintWriter writer = new PrintWriter(xmlDataFile);){
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<tables></tables>");
                writer.flush();
            }
        }
        this.tables = this.unmarshal(xmlDataFile);
    }

    protected XStream buildXStream() {
        XStream xs = new XStream();
        xs.ignoreUnknownElements();
        xs.autodetectAnnotations(true);
        xs.processAnnotations(Tables.class);
        xs.addDefaultImplementation(CaseInsensitiveMap.class, Map.class);
        return xs;
    }

    protected Tables unmarshal(File xmlDataFile) {
        Tables tables = new Tables();
        try (FileInputStream in = new FileInputStream(xmlDataFile);){
            this.buildXStream().fromXML((InputStream)in, (Object)tables);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tables;
    }

    protected void marshal(Tables tables, File xmlDataFile) {
        try (PrintWriter writer = new PrintWriter(xmlDataFile);){
            this.buildXStream().toXML((Object)tables, (Writer)writer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public TableDto read(String catalogName, String schemaName, String tableName) {
        TableDto table;
        SchemaDto schema;
        CatalogDto catalog;
        if (this.tables != null && (catalog = this.tables.getCatalog(catalogName)) != null && (schema = catalog.getSchema(schemaName)) != null && (table = schema.getTable(tableName)) != null) {
            table.setPkColumns(new ArrayList<ColumnDto>());
            table.setNormalColumns(new ArrayList<ColumnDto>());
            for (ColumnDto column : table.getColumns()) {
                column.prepare4Type();
                if (column.isPrimary()) {
                    table.getPkColumns().add(column);
                    continue;
                }
                table.getNormalColumns().add(column);
            }
            return table;
        }
        return null;
    }

    @Override
    public void close() {
    }
}

