/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.reader.impl;

import io.polaris.builder.code.dto.CatalogDto;
import io.polaris.builder.code.dto.SchemaDto;
import io.polaris.builder.code.dto.TableDto;
import io.polaris.builder.code.dto.Tables;
import io.polaris.builder.code.reader.impl.JdbcTablesReader;
import io.polaris.builder.code.reader.impl.XmlTablesReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class MixTablesReader
extends XmlTablesReader {
    private JdbcTablesReader jdbcTablesReader;
    private File xmlDataFile;

    public MixTablesReader(File xmlDataFile, File jdbcCfgFile) throws IOException {
        super(xmlDataFile);
        this.xmlDataFile = xmlDataFile;
        this.jdbcTablesReader = new JdbcTablesReader(jdbcCfgFile);
    }

    public MixTablesReader(File xmlDataFile, InputStream jdbcCfgFile) throws IOException {
        super(xmlDataFile);
        this.xmlDataFile = xmlDataFile;
        this.jdbcTablesReader = new JdbcTablesReader(jdbcCfgFile);
    }

    @Override
    public TableDto read(String catalogName, String schemaName, String tableName) {
        TableDto table = super.read(catalogName, schemaName, tableName);
        if (table == null && (table = this.jdbcTablesReader.read(catalogName, schemaName, tableName)) != null) {
            SchemaDto schema;
            CatalogDto catalog;
            if (this.tables == null) {
                this.tables = new Tables();
            }
            if ((catalog = this.tables.getCatalog(catalogName)) == null) {
                catalog = new CatalogDto();
                catalog.setName(catalogName);
                this.tables.addCatalog(catalog);
            }
            if ((schema = catalog.getSchema(schemaName)) == null) {
                schema = new SchemaDto();
                schema.setName(schemaName);
                catalog.addSchema(schema);
            }
            schema.addTable(table);
            return table;
        }
        return table;
    }

    @Override
    public void close() {
        this.jdbcTablesReader.close();
        this.marshal(this.tables, this.xmlDataFile);
    }
}

