/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import io.polaris.builder.code.config.ConfigColumn;
import io.polaris.builder.code.dto.ColumnDto;
import io.polaris.builder.dbv.DbCommentSplits;
import io.polaris.core.tuple.Tuple2;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.SerializationUtils;

@XStreamAlias(value="table")
public class TableDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String comment;
    @XStreamAlias(value="columns")
    @XStreamImplicit(itemFieldName="column", keyFieldName="name")
    private List<ColumnDto> columns = new ArrayList<ColumnDto>();
    @XStreamOmitField
    private String catalog = "";
    @XStreamOmitField
    private String schema = "";
    @XStreamOmitField
    private List<ColumnDto> pkColumns = new ArrayList<ColumnDto>();
    @XStreamOmitField
    private List<ColumnDto> normalColumns = new ArrayList<ColumnDto>();
    @XStreamOmitField
    private Set<String> columnJavaTypes = new LinkedHashSet<String>();
    @XStreamOmitField
    private Map<String, String> property;
    @XStreamOmitField
    private String javaPackageName = "";
    @XStreamOmitField
    private String javaPackageDir = "";
    @XStreamOmitField
    private String javaClassName;
    @XStreamOmitField
    private String javaVariableName;
    @XStreamOmitField
    private String xmlName;
    @XStreamOmitField
    private String label;
    @XStreamOmitField
    private String remark;

    public void prepare4Java(Function<String, String> tableNameTrimmer, Function<String, String> columnNameTrimmer, Map<String, ConfigColumn> columnMap) {
        Tuple2<String, String> tuple = DbCommentSplits.split(this.comment);
        this.label = (String)tuple.getFirst();
        this.remark = (String)tuple.getSecond();
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnDto>();
        }
        if (this.pkColumns == null) {
            this.pkColumns = new ArrayList<ColumnDto>();
        }
        if (this.normalColumns == null) {
            this.normalColumns = new ArrayList<ColumnDto>();
        }
        if (this.columnJavaTypes == null) {
            this.columnJavaTypes = new LinkedHashSet<String>();
        }
        for (ColumnDto col : this.columns) {
            col.prepare4Java(columnNameTrimmer, columnMap);
            if (!col.getJavaType().contains(".")) continue;
            this.columnJavaTypes.add(col.getJavaType());
        }
        if (this.pkColumns.isEmpty()) {
            for (ColumnDto col : this.columns) {
                if (!col.isPrimary()) continue;
                this.pkColumns.add(col);
            }
        } else {
            for (ColumnDto col : this.pkColumns) {
                col.prepare4Java(columnNameTrimmer, columnMap);
                if (!col.getJavaType().contains(".")) continue;
                this.columnJavaTypes.add(col.getJavaType());
            }
        }
        if (this.normalColumns.isEmpty()) {
            for (ColumnDto col : this.columns) {
                if (col.isPrimary()) continue;
                this.normalColumns.add(col);
            }
        } else {
            for (ColumnDto col : this.normalColumns) {
                col.prepare4Java(columnNameTrimmer, columnMap);
                if (!col.getJavaType().contains(".")) continue;
                this.columnJavaTypes.add(col.getJavaType());
            }
        }
        this.javaPackageDir = this.javaPackageName.replace('.', '/');
        String name = tableNameTrimmer.apply(this.name);
        char[] nameChars = name.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (int i = 1; i < nameChars.length; ++i) {
            if (nameChars[i] == '_') {
                flag = true;
                continue;
            }
            if (flag) {
                sb.append(Character.toUpperCase(nameChars[i]));
                flag = false;
                continue;
            }
            sb.append(Character.toLowerCase(nameChars[i]));
        }
        this.javaClassName = Character.toUpperCase(nameChars[0]) + sb.toString();
        this.javaVariableName = Character.toLowerCase(nameChars[0]) + sb.toString();
        this.xmlName = name.toLowerCase().replace("_", "-");
    }

    public TableDto clone() {
        return (TableDto)SerializationUtils.clone((Serializable)this);
    }

    public boolean containsColumnName(String columnName) {
        for (ColumnDto column : this.columns) {
            if (!column.getName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsColumnVariableName(String columnVariableName) {
        for (ColumnDto column : this.columns) {
            if (!column.getJavaVariableName().equals(columnVariableName)) continue;
            return true;
        }
        return false;
    }

    public ColumnDto getColumnByName(String columnName) {
        for (ColumnDto column : this.columns) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        return null;
    }

    public ColumnDto getColumnByVariableName(String columnVariableName) {
        for (ColumnDto column : this.columns) {
            if (!column.getJavaVariableName().equals(columnVariableName)) continue;
            return column;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public List<ColumnDto> getColumns() {
        return this.columns;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<ColumnDto> getPkColumns() {
        return this.pkColumns;
    }

    public List<ColumnDto> getNormalColumns() {
        return this.normalColumns;
    }

    public Set<String> getColumnJavaTypes() {
        return this.columnJavaTypes;
    }

    public Map<String, String> getProperty() {
        return this.property;
    }

    public String getJavaPackageName() {
        return this.javaPackageName;
    }

    public String getJavaPackageDir() {
        return this.javaPackageDir;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getJavaVariableName() {
        return this.javaVariableName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumns(List<ColumnDto> columns) {
        this.columns = columns;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setPkColumns(List<ColumnDto> pkColumns) {
        this.pkColumns = pkColumns;
    }

    public void setNormalColumns(List<ColumnDto> normalColumns) {
        this.normalColumns = normalColumns;
    }

    public void setColumnJavaTypes(Set<String> columnJavaTypes) {
        this.columnJavaTypes = columnJavaTypes;
    }

    public void setProperty(Map<String, String> property) {
        this.property = property;
    }

    public void setJavaPackageName(String javaPackageName) {
        this.javaPackageName = javaPackageName;
    }

    public void setJavaPackageDir(String javaPackageDir) {
        this.javaPackageDir = javaPackageDir;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public void setJavaVariableName(String javaVariableName) {
        this.javaVariableName = javaVariableName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDto)) {
            return false;
        }
        TableDto other = (TableDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<ColumnDto> this$columns = this.columns;
        List<ColumnDto> other$columns = other.columns;
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$catalog = this.catalog;
        String other$catalog = other.catalog;
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schema = this.schema;
        String other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        List<ColumnDto> this$pkColumns = this.pkColumns;
        List<ColumnDto> other$pkColumns = other.pkColumns;
        if (this$pkColumns == null ? other$pkColumns != null : !((Object)this$pkColumns).equals(other$pkColumns)) {
            return false;
        }
        List<ColumnDto> this$normalColumns = this.normalColumns;
        List<ColumnDto> other$normalColumns = other.normalColumns;
        if (this$normalColumns == null ? other$normalColumns != null : !((Object)this$normalColumns).equals(other$normalColumns)) {
            return false;
        }
        Set<String> this$columnJavaTypes = this.columnJavaTypes;
        Set<String> other$columnJavaTypes = other.columnJavaTypes;
        if (this$columnJavaTypes == null ? other$columnJavaTypes != null : !((Object)this$columnJavaTypes).equals(other$columnJavaTypes)) {
            return false;
        }
        Map<String, String> this$property = this.property;
        Map<String, String> other$property = other.property;
        if (this$property == null ? other$property != null : !((Object)this$property).equals(other$property)) {
            return false;
        }
        String this$javaPackageName = this.javaPackageName;
        String other$javaPackageName = other.javaPackageName;
        if (this$javaPackageName == null ? other$javaPackageName != null : !this$javaPackageName.equals(other$javaPackageName)) {
            return false;
        }
        String this$javaPackageDir = this.javaPackageDir;
        String other$javaPackageDir = other.javaPackageDir;
        if (this$javaPackageDir == null ? other$javaPackageDir != null : !this$javaPackageDir.equals(other$javaPackageDir)) {
            return false;
        }
        String this$javaClassName = this.javaClassName;
        String other$javaClassName = other.javaClassName;
        if (this$javaClassName == null ? other$javaClassName != null : !this$javaClassName.equals(other$javaClassName)) {
            return false;
        }
        String this$javaVariableName = this.javaVariableName;
        String other$javaVariableName = other.javaVariableName;
        if (this$javaVariableName == null ? other$javaVariableName != null : !this$javaVariableName.equals(other$javaVariableName)) {
            return false;
        }
        String this$xmlName = this.xmlName;
        String other$xmlName = other.xmlName;
        if (this$xmlName == null ? other$xmlName != null : !this$xmlName.equals(other$xmlName)) {
            return false;
        }
        String this$label = this.label;
        String other$label = other.label;
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$remark = this.remark;
        String other$remark = other.remark;
        return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<ColumnDto> $columns = this.columns;
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $catalog = this.catalog;
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        List<ColumnDto> $pkColumns = this.pkColumns;
        result = result * 59 + ($pkColumns == null ? 43 : ((Object)$pkColumns).hashCode());
        List<ColumnDto> $normalColumns = this.normalColumns;
        result = result * 59 + ($normalColumns == null ? 43 : ((Object)$normalColumns).hashCode());
        Set<String> $columnJavaTypes = this.columnJavaTypes;
        result = result * 59 + ($columnJavaTypes == null ? 43 : ((Object)$columnJavaTypes).hashCode());
        Map<String, String> $property = this.property;
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        String $javaPackageName = this.javaPackageName;
        result = result * 59 + ($javaPackageName == null ? 43 : $javaPackageName.hashCode());
        String $javaPackageDir = this.javaPackageDir;
        result = result * 59 + ($javaPackageDir == null ? 43 : $javaPackageDir.hashCode());
        String $javaClassName = this.javaClassName;
        result = result * 59 + ($javaClassName == null ? 43 : $javaClassName.hashCode());
        String $javaVariableName = this.javaVariableName;
        result = result * 59 + ($javaVariableName == null ? 43 : $javaVariableName.hashCode());
        String $xmlName = this.xmlName;
        result = result * 59 + ($xmlName == null ? 43 : $xmlName.hashCode());
        String $label = this.label;
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $remark = this.remark;
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        return result;
    }

    public String toString() {
        return "TableDto(name=" + this.name + ", comment=" + this.comment + ", catalog=" + this.catalog + ", schema=" + this.schema + ", columnJavaTypes=" + this.columnJavaTypes + ", property=" + this.property + ", javaPackageName=" + this.javaPackageName + ", javaPackageDir=" + this.javaPackageDir + ", javaClassName=" + this.javaClassName + ", javaVariableName=" + this.javaVariableName + ", xmlName=" + this.xmlName + ", label=" + this.label + ", remark=" + this.remark + ")";
    }
}

