/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.dto;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import io.polaris.builder.code.JdbcTypes;
import io.polaris.builder.code.config.ConfigColumn;
import io.polaris.builder.dbv.DbCommentSplits;
import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.SerializationUtils;

@XStreamAlias(value="column")
public class ColumnDto
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    @XStreamOmitField
    private Integer type;
    @XStreamAsAttribute
    private String comment;
    @XStreamAsAttribute
    private String defaultValue;
    @XStreamAsAttribute
    private boolean primary = false;
    @XStreamAsAttribute
    private boolean nullable = true;
    @XStreamAsAttribute
    private int columnSize;
    @XStreamAsAttribute
    private int decimalDigits;
    @XStreamAsAttribute
    private boolean generated = false;
    @XStreamAsAttribute
    private boolean autoincrement = false;
    @XStreamAsAttribute
    @XStreamAlias(value="jdbcType")
    private String jdbcType;
    @XStreamAsAttribute
    @XStreamAlias(value="javaType")
    private String javaType;
    @XStreamOmitField
    private Map<String, String> property;
    @XStreamOmitField
    private String javaTypeSimpleName;
    @XStreamOmitField
    private String javaClassName;
    @XStreamOmitField
    private String javaVariableName;
    @XStreamOmitField
    private String xmlName;
    @XStreamOmitField
    private String trimName;
    @XStreamOmitField
    private String label;
    @XStreamOmitField
    private String remark;

    public boolean isNotNull() {
        return !this.nullable;
    }

    public void setNotNull(boolean notNull) {
        this.nullable = !notNull;
    }

    public void prepare4Java(Function<String, String> columnNameTrimmer, Map<String, ConfigColumn> columnMap) {
        int i;
        String name;
        Tuple2<String, String> tuple = DbCommentSplits.split(this.comment);
        this.label = (String)tuple.getFirst();
        this.remark = (String)tuple.getSecond();
        this.trimName = name = columnNameTrimmer.apply(this.name);
        this.xmlName = name.toLowerCase().replace("_", "-");
        char[] nameChars = name.toCharArray();
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (int i2 = 1; i2 < nameChars.length; ++i2) {
            if (nameChars[i2] == '_') {
                flag = true;
                continue;
            }
            if (flag) {
                sb.append(Character.toUpperCase(nameChars[i2]));
                flag = false;
                continue;
            }
            sb.append(Character.toLowerCase(nameChars[i2]));
        }
        if (Strings.isEmpty((CharSequence)this.javaClassName)) {
            this.javaClassName = Character.toUpperCase(nameChars[0]) + sb.toString();
        }
        if (Strings.isEmpty((CharSequence)this.javaVariableName)) {
            this.javaVariableName = Character.toLowerCase(nameChars[0]) + sb.toString();
        }
        this.prepare4Type();
        ConfigColumn configColumn = columnMap.get(this.name);
        Map<String, String> map = this.property = configColumn == null ? null : configColumn.getProperty();
        if (configColumn != null && Strings.isNotBlank((CharSequence)configColumn.getJavaType())) {
            this.javaType = configColumn.getJavaType();
        } else {
            Class c = JdbcTypes.getCustomJavaType(this.type);
            if (c != null) {
                this.javaType = c.getCanonicalName();
            } else if (Strings.isEmpty((CharSequence)this.javaType)) {
                c = JdbcTypes.getJavaType(this.type, this.columnSize, this.decimalDigits);
                if (c == null) {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684JdbcType\uff1a" + this.jdbcType);
                }
                this.javaType = c.getCanonicalName();
            }
        }
        this.javaTypeSimpleName = this.javaType.matches("java\\.lang\\.\\w+") ? (this.javaType = this.javaType.replace("java.lang.", "")) : ((i = this.javaType.lastIndexOf(".")) >= 0 ? this.javaType.substring(i + 1) : this.javaType);
    }

    public void prepare4Type() {
        Class c;
        if (Strings.isNotEmpty((CharSequence)this.jdbcType)) {
            this.type = JdbcTypes.getTypeValue(this.jdbcType);
            if (this.type == null) {
                throw new IllegalArgumentException("\u672a\u77e5JdbcType");
            }
        } else {
            if (this.type == null) {
                throw new IllegalArgumentException("\u672a\u77e5JdbcType");
            }
            this.jdbcType = JdbcTypes.getTypeName(this.type, "VARCHAR");
        }
        if (Strings.isEmpty((CharSequence)this.javaType) && (c = JdbcTypes.getJavaType(this.type, this.columnSize, this.decimalDigits)) != null) {
            this.javaType = c.getCanonicalName();
        }
    }

    public ColumnDto clone() {
        return (ColumnDto)SerializationUtils.clone((Serializable)this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public Map<String, String> getProperty() {
        return this.property;
    }

    public String getJavaTypeSimpleName() {
        return this.javaTypeSimpleName;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public String getJavaVariableName() {
        return this.javaVariableName;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public String getTrimName() {
        return this.trimName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setAutoincrement(boolean autoincrement) {
        this.autoincrement = autoincrement;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public void setProperty(Map<String, String> property) {
        this.property = property;
    }

    public void setJavaTypeSimpleName(String javaTypeSimpleName) {
        this.javaTypeSimpleName = javaTypeSimpleName;
    }

    public void setJavaClassName(String javaClassName) {
        this.javaClassName = javaClassName;
    }

    public void setJavaVariableName(String javaVariableName) {
        this.javaVariableName = javaVariableName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public void setTrimName(String trimName) {
        this.trimName = trimName;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDto)) {
            return false;
        }
        ColumnDto other = (ColumnDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.primary != other.primary) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        if (this.columnSize != other.columnSize) {
            return false;
        }
        if (this.decimalDigits != other.decimalDigits) {
            return false;
        }
        if (this.generated != other.generated) {
            return false;
        }
        if (this.autoincrement != other.autoincrement) {
            return false;
        }
        Integer this$type = this.type;
        Integer other$type = other.type;
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.comment;
        String other$comment = other.comment;
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$defaultValue = this.defaultValue;
        String other$defaultValue = other.defaultValue;
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$jdbcType = this.jdbcType;
        String other$jdbcType = other.jdbcType;
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        String this$javaType = this.javaType;
        String other$javaType = other.javaType;
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        Map<String, String> this$property = this.property;
        Map<String, String> other$property = other.property;
        if (this$property == null ? other$property != null : !((Object)this$property).equals(other$property)) {
            return false;
        }
        String this$javaTypeSimpleName = this.javaTypeSimpleName;
        String other$javaTypeSimpleName = other.javaTypeSimpleName;
        if (this$javaTypeSimpleName == null ? other$javaTypeSimpleName != null : !this$javaTypeSimpleName.equals(other$javaTypeSimpleName)) {
            return false;
        }
        String this$javaClassName = this.javaClassName;
        String other$javaClassName = other.javaClassName;
        if (this$javaClassName == null ? other$javaClassName != null : !this$javaClassName.equals(other$javaClassName)) {
            return false;
        }
        String this$javaVariableName = this.javaVariableName;
        String other$javaVariableName = other.javaVariableName;
        if (this$javaVariableName == null ? other$javaVariableName != null : !this$javaVariableName.equals(other$javaVariableName)) {
            return false;
        }
        String this$xmlName = this.xmlName;
        String other$xmlName = other.xmlName;
        if (this$xmlName == null ? other$xmlName != null : !this$xmlName.equals(other$xmlName)) {
            return false;
        }
        String this$trimName = this.trimName;
        String other$trimName = other.trimName;
        if (this$trimName == null ? other$trimName != null : !this$trimName.equals(other$trimName)) {
            return false;
        }
        String this$label = this.label;
        String other$label = other.label;
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$remark = this.remark;
        String other$remark = other.remark;
        return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.primary ? 79 : 97);
        result = result * 59 + (this.nullable ? 79 : 97);
        result = result * 59 + this.columnSize;
        result = result * 59 + this.decimalDigits;
        result = result * 59 + (this.generated ? 79 : 97);
        result = result * 59 + (this.autoincrement ? 79 : 97);
        Integer $type = this.type;
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.comment;
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $jdbcType = this.jdbcType;
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        String $javaType = this.javaType;
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        Map<String, String> $property = this.property;
        result = result * 59 + ($property == null ? 43 : ((Object)$property).hashCode());
        String $javaTypeSimpleName = this.javaTypeSimpleName;
        result = result * 59 + ($javaTypeSimpleName == null ? 43 : $javaTypeSimpleName.hashCode());
        String $javaClassName = this.javaClassName;
        result = result * 59 + ($javaClassName == null ? 43 : $javaClassName.hashCode());
        String $javaVariableName = this.javaVariableName;
        result = result * 59 + ($javaVariableName == null ? 43 : $javaVariableName.hashCode());
        String $xmlName = this.xmlName;
        result = result * 59 + ($xmlName == null ? 43 : $xmlName.hashCode());
        String $trimName = this.trimName;
        result = result * 59 + ($trimName == null ? 43 : $trimName.hashCode());
        String $label = this.label;
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $remark = this.remark;
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        return result;
    }

    public String toString() {
        return "ColumnDto(name=" + this.name + ", type=" + this.type + ", comment=" + this.comment + ", defaultValue=" + this.defaultValue + ", primary=" + this.primary + ", nullable=" + this.nullable + ", columnSize=" + this.columnSize + ", decimalDigits=" + this.decimalDigits + ", generated=" + this.generated + ", autoincrement=" + this.autoincrement + ", jdbcType=" + this.jdbcType + ", javaType=" + this.javaType + ", property=" + this.property + ", javaTypeSimpleName=" + this.javaTypeSimpleName + ", javaClassName=" + this.javaClassName + ", javaVariableName=" + this.javaVariableName + ", xmlName=" + this.xmlName + ", trimName=" + this.trimName + ", label=" + this.label + ", remark=" + this.remark + ")";
    }
}

