/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code.config;

import io.polaris.builder.code.config.CodeEnvBuilder;
import io.polaris.builder.code.config.CodeGroup;
import io.polaris.builder.code.config.CodeTable;
import io.polaris.builder.code.config.CodeTableBuilder;
import io.polaris.builder.code.config.CodeTemplate;
import io.polaris.builder.code.config.CodeTemplateBuilder;
import io.polaris.builder.code.config.TypeMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CodeGroupBuilder {
    private final CodeEnvBuilder envBuilder;
    private final CodeGroup target;

    public CodeGroupBuilder(CodeEnvBuilder envBuilder, CodeGroup target) {
        this.envBuilder = envBuilder;
        this.target = target;
    }

    public CodeGroup build() {
        return this.target;
    }

    public CodeEnvBuilder end() {
        return this.envBuilder;
    }

    public CodeGroupBuilder templates(List<CodeTemplate> templates) {
        this.target.setTemplates(templates);
        return this;
    }

    public CodeGroupBuilder tables(List<CodeTable> tables) {
        this.target.setTables(tables);
        return this;
    }

    public CodeGroupBuilder property(Map<String, String> property) {
        this.target.setProperty(property);
        return this;
    }

    public CodeGroupBuilder property(Supplier<Map<String, String>> property) {
        this.target.setProperty(property.get());
        return this;
    }

    public CodeGroupBuilder property(String key, String value) {
        if (this.target.getProperty() == null) {
            this.target.setProperty(new HashMap<String, String>());
        }
        this.target.getProperty().put(key, value);
        return this;
    }

    public CodeGroupBuilder tablePrefix(String tablePrefix) {
        this.target.setTablePrefix(tablePrefix);
        return this;
    }

    public CodeGroupBuilder tableSuffix(String tableSuffix) {
        this.target.setTableSuffix(tableSuffix);
        return this;
    }

    public CodeGroupBuilder columnPrefix(String columnPrefix) {
        this.target.setColumnPrefix(columnPrefix);
        return this;
    }

    public CodeGroupBuilder columnSuffix(String columnSuffix) {
        this.target.setColumnSuffix(columnSuffix);
        return this;
    }

    public CodeGroupBuilder mappings(Set<TypeMapping> mappings) {
        this.target.setMappings(mappings);
        return this;
    }

    public CodeGroupBuilder mappings(Supplier<Set<TypeMapping>> mappings) {
        this.target.setMappings(mappings.get());
        return this;
    }

    public CodeGroupBuilder mapping(String jdbcType, String javaType) {
        if (this.target.getMappings() == null) {
            this.target.setMappings(new LinkedHashSet<TypeMapping>());
        }
        this.target.getMappings().add(new TypeMapping(jdbcType, javaType));
        return this;
    }

    public CodeGroupBuilder addTemplate(CodeTemplate template) {
        if (this.target.getTemplates() == null) {
            this.target.setTemplates(new ArrayList<CodeTemplate>());
        }
        this.target.getTemplates().add(template);
        return this;
    }

    public CodeTemplateBuilder addTemplate() {
        CodeTemplate target = new CodeTemplate();
        this.addTemplate(target);
        return new CodeTemplateBuilder(this, target);
    }

    public CodeTemplateBuilder template() {
        return this.template(0);
    }

    public CodeTemplateBuilder template(int i) {
        if (this.target.getTemplates() == null || this.target.getTemplates().size() <= i) {
            this.addTemplate(new CodeTemplate());
        }
        return new CodeTemplateBuilder(this, this.target.getTemplates().get(i));
    }

    public CodeGroupBuilder addTable(CodeTable table) {
        if (this.target.getTables() == null) {
            this.target.setTables(new ArrayList<CodeTable>());
        }
        this.target.getTables().add(table);
        return this;
    }

    public CodeTableBuilder addTable() {
        CodeTable target = new CodeTable();
        this.addTable(target);
        return new CodeTableBuilder(this, target);
    }

    public CodeTableBuilder table() {
        return this.table(0);
    }

    public CodeTableBuilder table(int i) {
        if (this.target.getTables() == null || this.target.getTables().size() <= i) {
            this.addTable(new CodeTable());
        }
        return new CodeTableBuilder(this, this.target.getTables().get(i));
    }
}

