/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.code;

import io.polaris.builder.code.CodeGenerator;
import io.polaris.builder.code.annotation.CodeConfiguration;
import io.polaris.builder.code.annotation.Column;
import io.polaris.builder.code.annotation.DefaultMapping;
import io.polaris.builder.code.annotation.DefaultProperty;
import io.polaris.builder.code.annotation.DefaultTemplate;
import io.polaris.builder.code.annotation.DefaultTemplateAdditional;
import io.polaris.builder.code.annotation.DefaultTemplateExcludedPaths;
import io.polaris.builder.code.annotation.Mapping;
import io.polaris.builder.code.annotation.Property;
import io.polaris.builder.code.annotation.Table;
import io.polaris.builder.code.annotation.Template;
import io.polaris.builder.code.config.CodeEnvBuilder;
import io.polaris.builder.code.config.CodeGroupBuilder;
import io.polaris.builder.code.config.ConfigColumn;
import io.polaris.builder.code.config.TypeMapping;
import io.polaris.builder.code.reader.impl.JdbcTablesReader;
import io.polaris.builder.dbv.cfg.DatabaseCfg;
import io.polaris.core.collection.Iterables;
import io.polaris.core.concurrent.Executors;
import io.polaris.core.env.GlobalStdEnv;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class Codes {
    public static void generate(Class<?> clazz, String ... targets) throws IOException {
        Metadata metadata = Codes.parse(clazz);
        Codes.generate(metadata, targets);
    }

    public static void generate(Class<?> clazz, int concurrent) throws IOException {
        Metadata metadata = Codes.parse(clazz);
        Codes.generate(metadata, concurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generate(Metadata metadata, int concurrent) throws IOException {
        if (concurrent <= 1) {
            Codes.generate(metadata, new String[0]);
        } else {
            CodeConfiguration code = metadata.codeConfiguration;
            ThreadPoolExecutor pool = Executors.create((int)concurrent, (String)"CodeGenerator");
            CountDownLatch latch = new CountDownLatch(concurrent);
            try {
                List errors = Collections.synchronizedList(new ArrayList());
                List[] tables = new List[concurrent];
                int n3 = 0;
                Table[] tableArray = code.tables();
                int n2 = tableArray.length;
                for (int i = 0; i < n2; ++i) {
                    int idx;
                    Table table = tableArray[i];
                    (tables[idx = n3++ % concurrent] == null ? new ArrayList<Table>() : tables[idx]).add(table);
                }
                for (List list : tables) {
                    if (list == null || list.isEmpty()) continue;
                    Table[] array = list.toArray(new Table[list.size()]);
                    pool.execute(() -> {
                        try {
                            Codes.generate(metadata, array, new String[0]);
                        }
                        catch (IOException e) {
                            errors.add(e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException n3) {
                        continue;
                    }
                    break;
                }
                int errCount = errors.size();
                if (errCount > 0) {
                    IOException e = (IOException)errors.get(0);
                    for (int idx = 1; idx < errCount; ++idx) {
                        e.addSuppressed((Throwable)errors.get(idx));
                    }
                    throw e;
                }
            }
            finally {
                Executors.shutdown((ExecutorService)pool);
            }
        }
    }

    private static void generate(Metadata metadata, String ... targets) throws IOException {
        CodeConfiguration code = metadata.codeConfiguration;
        Table[] tables = code.tables();
        Codes.generate(metadata, tables, targets);
    }

    /*
     * WARNING - void declaration
     */
    private static void generate(Metadata metadata, Table[] tables, String ... targets) throws IOException {
        DefaultTemplate defaultTemplate;
        Template[] templates;
        if (tables.length == 0) {
            return;
        }
        CodeConfiguration code = metadata.codeConfiguration;
        LinkedHashMap<String, String> property = new LinkedHashMap<String, String>();
        DefaultProperty defaultProperty = metadata.defaultProperty;
        if (defaultProperty != null) {
            for (Property property2 : defaultProperty.value()) {
                property.put(GlobalStdEnv.resolveRef((String)property2.key()), GlobalStdEnv.resolveRef((String)property2.value()));
            }
        }
        for (Property property3 : code.property()) {
            property.put(GlobalStdEnv.resolveRef((String)property3.key()), GlobalStdEnv.resolveRef((String)property3.value()));
        }
        HashSet<TypeMapping> mappings = new HashSet<TypeMapping>();
        for (Annotation annotation : code.mapping()) {
            mappings.add(new TypeMapping(GlobalStdEnv.resolveRef((String)annotation.jdbcType()), GlobalStdEnv.resolveRef((String)annotation.javaType())));
        }
        DefaultMapping defaultMapping = metadata.defaultMapping;
        if (defaultMapping != null) {
            void var9_20;
            Mapping[] mappingArray = defaultMapping.value();
            int n = mappingArray.length;
            boolean bl = false;
            while (var9_20 < n) {
                Mapping mapping = mappingArray[var9_20];
                mappings.add(new TypeMapping(GlobalStdEnv.resolveRef((String)mapping.jdbcType()), GlobalStdEnv.resolveRef((String)mapping.javaType())));
                ++var9_20;
            }
        }
        if ((templates = code.templates()).length == 0 && (defaultTemplate = metadata.defaultTemplate) != null) {
            String[] stringArray;
            ArrayList<Template> list = new ArrayList<Template>();
            String[] stringArray2 = stringArray = metadata.defaultTemplateExcludedPaths == null ? new String[]{} : metadata.defaultTemplateExcludedPaths.value();
            if (stringArray.length == 0) {
                list.addAll(Arrays.asList(defaultTemplate.value()));
            } else {
                block4: for (Template template : defaultTemplate.value()) {
                    String path = template.path();
                    for (String excludeTemplatePath : stringArray) {
                        if (path.equals(excludeTemplatePath)) continue block4;
                    }
                    list.add(template);
                }
            }
            DefaultTemplateAdditional defaultTemplateAdditional = metadata.defaultTemplateAdditional;
            if (defaultTemplateAdditional != null) {
                list.addAll(Arrays.asList(defaultTemplateAdditional.value()));
            }
            templates = list.toArray(new Template[0]);
        }
        CodeGenerator generator = Codes.generator().logWithStd(code.logWithStd());
        CodeEnvBuilder codeEnvBuilder = generator.codeEnvBuilder();
        codeEnvBuilder.outdir(GlobalStdEnv.resolveRef((String)code.outDir())).property(property).mappings(mappings).tablePrefix(GlobalStdEnv.resolveRef((String)code.tablePrefix())).tableSuffix(GlobalStdEnv.resolveRef((String)code.tableSuffix())).columnPrefix(GlobalStdEnv.resolveRef((String)code.columnPrefix())).columnSuffix(GlobalStdEnv.resolveRef((String)code.columnSuffix()));
        CodeGroupBuilder codeGroupBuilder = codeEnvBuilder.group().property(property).mappings(mappings).tablePrefix(GlobalStdEnv.resolveRef((String)code.tablePrefix())).tableSuffix(GlobalStdEnv.resolveRef((String)code.tableSuffix())).columnPrefix(GlobalStdEnv.resolveRef((String)code.columnPrefix())).columnSuffix(GlobalStdEnv.resolveRef((String)code.columnSuffix()));
        for (Template template : templates) {
            LinkedHashMap<String, String> templateProperty = new LinkedHashMap<String, String>(property);
            for (Property p : template.property()) {
                templateProperty.put(GlobalStdEnv.resolveRef((String)p.key()), GlobalStdEnv.resolveRef((String)p.value()));
            }
            codeGroupBuilder.addTemplate().path(GlobalStdEnv.resolveRef((String)template.path())).filename(GlobalStdEnv.resolveRef((String)template.filename())).outdir(GlobalStdEnv.resolveRef((String)template.dirname())).property(templateProperty);
        }
        if (targets != null && targets.length > 0) {
            Set set = Iterables.asSet((Object[])targets);
            Function<String, Boolean> function = name -> set.contains(name);
        } else {
            Function<String, Boolean> function = name -> true;
        }
        for (Table table : tables) {
            void var10_31;
            if (!((Boolean)var10_31.apply(table.name())).booleanValue()) continue;
            LinkedHashMap<String, String> tableProperty = new LinkedHashMap<String, String>(property);
            for (Property p : table.property()) {
                tableProperty.put(GlobalStdEnv.resolveRef((String)p.key()), GlobalStdEnv.resolveRef((String)p.value()));
            }
            HashSet<ConfigColumn> columns = new HashSet<ConfigColumn>();
            for (Column column : table.columns()) {
                LinkedHashMap<String, String> columnProperty = new LinkedHashMap<String, String>(tableProperty);
                for (Property p : column.property()) {
                    columnProperty.put(GlobalStdEnv.resolveRef((String)p.key()), GlobalStdEnv.resolveRef((String)p.value()));
                }
                ConfigColumn configColumn = new ConfigColumn();
                configColumn.setJavaType(GlobalStdEnv.resolveRef((String)column.javaType()));
                configColumn.setName(GlobalStdEnv.resolveRef((String)column.name()));
                configColumn.setProperty(columnProperty);
                columns.add(configColumn);
            }
            codeGroupBuilder.addTable().catalog(GlobalStdEnv.resolveRef((String)table.catalog())).schema(GlobalStdEnv.resolveRef((String)table.schema())).name(GlobalStdEnv.resolveRef((String)table.name())).javaPackage(GlobalStdEnv.resolveRef((String)table.javaPackage())).property(tableProperty).columns(columns).mappings(mappings).tablePrefix(GlobalStdEnv.resolveRef((String)code.tablePrefix())).tableSuffix(GlobalStdEnv.resolveRef((String)code.tableSuffix())).columnPrefix(GlobalStdEnv.resolveRef((String)code.columnPrefix())).columnSuffix(GlobalStdEnv.resolveRef((String)code.columnSuffix()));
        }
        DatabaseCfg cfg = new DatabaseCfg();
        cfg.setJdbcDriver(GlobalStdEnv.resolveRef((String)code.jdbcDriver()));
        cfg.setJdbcUrl(GlobalStdEnv.resolveRef((String)code.jdbcUrl()));
        cfg.setJdbcUsername(GlobalStdEnv.resolveRef((String)code.jdbcUsername()));
        cfg.setJdbcPassword(GlobalStdEnv.resolveRef((String)code.jdbcPassword()));
        generator.tablesReader(new JdbcTablesReader(cfg));
        generator.generate();
    }

    public static void generate(String codeXmlPath, String jdbcXmlPath, String dataXmlPath) throws IOException {
        Codes.generator().codeXmlPath(codeXmlPath).jdbcXmlPath(jdbcXmlPath).dataXmlPath(dataXmlPath).generate();
    }

    public static CodeGenerator generator() {
        return new CodeGenerator();
    }

    private static Metadata parse(AnnotatedElement element) {
        Metadata metadata = new Metadata();
        metadata.codeConfiguration = (CodeConfiguration)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, CodeConfiguration.class);
        if (metadata.codeConfiguration == null) {
            throw new IllegalArgumentException("\u914d\u7f6e\u7f3a\u5931\uff1a@CodeConfiguration");
        }
        metadata.defaultProperty = (DefaultProperty)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, DefaultProperty.class);
        metadata.defaultTemplate = (DefaultTemplate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, DefaultTemplate.class);
        metadata.defaultMapping = (DefaultMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, DefaultMapping.class);
        metadata.defaultTemplateAdditional = (DefaultTemplateAdditional)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, DefaultTemplateAdditional.class);
        metadata.defaultTemplateExcludedPaths = (DefaultTemplateExcludedPaths)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, DefaultTemplateExcludedPaths.class);
        return metadata;
    }

    static class Metadata {
        CodeConfiguration codeConfiguration;
        DefaultProperty defaultProperty;
        DefaultTemplate defaultTemplate;
        DefaultMapping defaultMapping;
        DefaultTemplateAdditional defaultTemplateAdditional;
        DefaultTemplateExcludedPaths defaultTemplateExcludedPaths;

        Metadata() {
        }
    }
}

