/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.builder.changer;

import io.polaris.core.crypto.digest.Digests;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Changer {
    private static final Logger log = LoggerFactory.getLogger((String)"code.changer");
    private static final int EOF = -1;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    static Pattern patternDigits = Pattern.compile("(?<!\\\\)\\{(\\d+)\\}");
    static Pattern patternEmpty = Pattern.compile("(?<!\\\\)\\{\\}");
    private Charset charset = Charset.defaultCharset();
    private File srcRoot;
    private File destRoot;
    private final List<String> sourcePaths = new ArrayList<String>();
    private final List<String> extensions = new ArrayList<String>();
    private final List<Pattern> namePatterns = new ArrayList<Pattern>();
    private final List<Mapping> mappings = new ArrayList<Mapping>();
    private final List<Pattern> ignorePatterns = new ArrayList<Pattern>();
    private final List<Pattern> ignoreMappingPatterns = new ArrayList<Pattern>();
    private boolean copyAll = true;
    private boolean includeFileName = true;

    public void execute() throws IOException, NoSuchAlgorithmException {
        this.check();
        if (this.sourcePaths.isEmpty()) {
            String srcPath = this.srcRoot.getAbsolutePath().replace("\\", "/").replaceFirst("/$", "");
            String destPath = this.destRoot.getAbsolutePath().replace("\\", "/").replaceFirst("/$", "");
            log.info("[Changing] {}", (Object)this.srcRoot.getPath());
            this.doChange(srcPath, destPath, this.srcRoot);
        } else {
            for (String sourcePath : this.sourcePaths) {
                sourcePath = sourcePath.replace("\\", "/");
                File from = new File(this.srcRoot, sourcePath);
                File to = new File(this.destRoot, sourcePath);
                String srcPath = from.getAbsolutePath().replace("\\", "/").replaceFirst("/$", "");
                String destPath = to.getAbsolutePath().replace("\\", "/").replaceFirst("/$", "");
                log.info("[Changing] {}", (Object)from.getPath());
                this.doChange(srcPath, destPath, from);
            }
        }
    }

    public String format(String s, Object ... args) {
        int i;
        if (s == null || s.isEmpty()) {
            if (args.length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(args[0]);
            for (int i2 = 1; i2 < args.length; ++i2) {
                sb.append(", ").append(args[i2]);
            }
            return sb.toString();
        }
        BitSet bitSet = new BitSet();
        StringBuffer sb = new StringBuffer();
        Matcher matcher = patternDigits.matcher(s);
        while (matcher.find()) {
            i = Integer.parseInt(matcher.group(1));
            bitSet.set(i);
            matcher.appendReplacement(sb, String.valueOf(i < args.length ? args[i] : null));
        }
        matcher.appendTail(sb);
        s = sb.toString();
        if (s.contains("{}")) {
            sb.setLength(0);
            matcher = patternEmpty.matcher(s);
            i = 0;
            while (matcher.find()) {
                while (bitSet.get(i)) {
                    ++i;
                }
                matcher.appendReplacement(sb, String.valueOf(i < args.length ? args[i] : null));
                bitSet.set(i);
            }
            matcher.appendTail(sb);
            s = sb.toString();
        } else if (bitSet.cardinality() >= args.length) {
            return s;
        }
        if (bitSet.cardinality() < args.length) {
            for (i = 0; i < args.length; ++i) {
                if (bitSet.get(i)) continue;
                sb.append(", ").append(String.valueOf(args[i]));
            }
            return sb.toString();
        }
        return s;
    }

    private void doChange(String srcPath, String destPath, File from) throws IOException, NoSuchAlgorithmException {
        if (!from.isDirectory()) {
            return;
        }
        File[] files = from.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String filePath = file.getAbsolutePath().replace("\\", "/").replaceFirst("/$", "");
            if (filePath.length() <= srcPath.length() + 1 || !filePath.startsWith(srcPath)) {
                throw new IllegalArgumentException("path:" + filePath);
            }
            if (file.isFile()) {
                String fileName = file.getName();
                String mappingFile = this.createMappingFile(filePath = filePath.substring(srcPath.length() + 1, filePath.length() - fileName.length()), fileName);
                if (mappingFile == null) continue;
                File newFile = new File(destPath, mappingFile);
                newFile.getParentFile().mkdirs();
                if (this.ignore(filePath, fileName)) continue;
                if (this.matches(filePath, fileName)) {
                    this.doChange(file, newFile);
                    continue;
                }
                this.copy(file, newFile);
                continue;
            }
            if (!this.maybe(filePath = filePath.substring(srcPath.length() + 1))) continue;
            this.doChange(srcPath, destPath, file);
        }
    }

    private void doChange(File src, File dest) throws IOException, NoSuchAlgorithmException {
        block133: {
            Object line;
            String lineSeparator = "\n";
            try (RandomAccessFile raf = new RandomAccessFile(src, "r");){
                line = raf.readLine();
                if (line != null) {
                    raf.seek(((String)line).getBytes(StandardCharsets.ISO_8859_1).length);
                    if (raf.getFilePointer() < raf.length()) {
                        byte b = raf.readByte();
                        if (b == 10) {
                            lineSeparator = "\n";
                        } else if (b == 13) {
                            lineSeparator = "\r";
                            if (raf.getFilePointer() < raf.length() && (b = raf.readByte()) == 10) {
                                lineSeparator = "\r\n";
                            }
                        }
                    }
                }
            }
            if (dest.exists()) {
                byte[] sha1t;
                StringBuilder sb = new StringBuilder();
                FileInputStream fis = new FileInputStream(src);
                line = null;
                try (BufferedReader br2 = new BufferedReader(new InputStreamReader((InputStream)fis, this.charset));){
                    String line2 = br2.readLine();
                    while (line2 != null) {
                        String s = this.doChangeForLine(line2);
                        sb.append(s).append(lineSeparator);
                        line2 = br2.readLine();
                    }
                }
                catch (Throwable br2) {
                    line = br2;
                    throw br2;
                }
                finally {
                    if (fis != null) {
                        if (line != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable br2) {
                                ((Throwable)line).addSuppressed(br2);
                            }
                        } else {
                            fis.close();
                        }
                    }
                }
                String data = sb.toString();
                byte[] sha1 = Digests.sha1((String)data);
                try (FileInputStream fis2 = new FileInputStream(dest);){
                    sha1t = Digests.sha1((InputStream)fis2);
                }
                if (Arrays.equals(sha1, sha1t)) {
                    return;
                }
                log.info("[Change-Of] {}", (Object)src.getPath());
                log.info("[Change-To] {}", (Object)dest.getPath());
                var9_22 = null;
                try (FileOutputStream fos = new FileOutputStream(dest);
                     BufferedWriter bw2 = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.charset));){
                    bw2.write(data);
                    bw2.flush();
                    break block133;
                }
                catch (Throwable bw2) {
                    var9_22 = bw2;
                    throw bw2;
                }
            }
            log.info("[Change-Of] {}", (Object)src.getPath());
            log.info("[Change-To] {}", (Object)dest.getPath());
            var5_5 = null;
            try (FileInputStream fis = new FileInputStream(src);
                 FileOutputStream fos = new FileOutputStream(dest);
                 BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, this.charset));
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.charset));){
                String line3 = br.readLine();
                while (line3 != null) {
                    String s = this.doChangeForLine(line3);
                    bw.write(s);
                    bw.write(lineSeparator);
                    line3 = br.readLine();
                }
                bw.flush();
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int copy(File src, File dest) throws IOException, NoSuchAlgorithmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    private boolean ignore(String filePath, String fileName) {
        if (this.ignorePatterns.isEmpty()) {
            return false;
        }
        for (Pattern ignorePattern : this.ignorePatterns) {
            if (!ignorePattern.matcher(filePath + fileName).find()) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String filePath, String fileName) {
        if (!this.ignoreMappingPatterns.isEmpty()) {
            for (Pattern ignoreMappingPattern : this.ignoreMappingPatterns) {
                if (!ignoreMappingPattern.matcher(filePath + fileName).find()) continue;
                return false;
            }
        }
        if (this.extensions.isEmpty() && this.namePatterns.isEmpty()) {
            return true;
        }
        for (String extension : this.extensions) {
            if (!fileName.endsWith(extension)) continue;
            return true;
        }
        for (Pattern namePattern : this.namePatterns) {
            if (!namePattern.matcher(filePath + fileName).find()) continue;
            return true;
        }
        return false;
    }

    private boolean maybe(String filePath) {
        if (this.copyAll) {
            return true;
        }
        for (Mapping mapping : this.mappings) {
            String src = mapping.getSrc();
            String dest = mapping.getDest();
            String srcPath = src.replace(".", "/");
            String destPath = dest.replace(".", "/");
            if (filePath.startsWith(srcPath)) {
                return true;
            }
            if (!srcPath.startsWith(filePath)) continue;
            return true;
        }
        return false;
    }

    private String createMappingFile(String filePath, String fileName) {
        String dest;
        String src;
        boolean maybe = false;
        String newFileName = null;
        if (this.includeFileName) {
            for (Mapping mapping : this.mappings) {
                src = mapping.getSrc();
                dest = mapping.getDest();
                if (fileName.equals(src)) {
                    newFileName = "/" + dest;
                    maybe = true;
                    break;
                }
                if (!fileName.startsWith(src)) continue;
                newFileName = "/" + dest + fileName.substring(src.length());
                maybe = true;
                break;
            }
        }
        if (newFileName == null) {
            newFileName = "/" + fileName;
        }
        for (Mapping mapping : this.mappings) {
            src = mapping.getSrc();
            dest = mapping.getDest();
            String srcPath = src.replace(".", "/");
            String destPath = dest.replace(".", "/");
            if (filePath.equals(srcPath)) {
                return destPath + newFileName;
            }
            if (filePath.startsWith(srcPath)) {
                return destPath + "/" + filePath.substring(srcPath.length()) + newFileName;
            }
            if (maybe) continue;
            maybe = fileName == null && srcPath.startsWith(filePath);
        }
        if (maybe || this.copyAll) {
            return filePath + newFileName;
        }
        return null;
    }

    private String doChangeForLine(String line) {
        String s = line;
        for (Mapping mapping : this.mappings) {
            s = s.replaceAll("\\b" + mapping.getSrc().replace(".", "\\.") + "\\b", mapping.getDest());
            s = s.replaceAll("\\b" + mapping.getSrc().replace(".", "/") + "\\b", mapping.getDest().replace(".", "/"));
        }
        return s;
    }

    private void check() {
        if (this.srcRoot == null || !this.srcRoot.exists()) {
            throw new IllegalArgumentException("srcRoot");
        }
        if (this.destRoot == null) {
            throw new IllegalArgumentException("destRoot");
        }
        if (!this.destRoot.exists()) {
            this.destRoot.mkdirs();
            if (!this.destRoot.exists()) {
                throw new IllegalArgumentException("destRoot");
            }
        }
    }

    public void addSourcePath(String ... paths) {
        this.sourcePaths.addAll(Arrays.asList(paths));
    }

    public void addExtension(String ... extensions) {
        for (String extension : extensions) {
            this.extensions.add("." + extension.replaceFirst("\\.+", ""));
        }
    }

    public void addNamePatterns(Pattern ... patterns) {
        this.namePatterns.addAll(Arrays.asList(patterns));
    }

    public void addIgnorePatterns(Pattern ... patterns) {
        this.ignorePatterns.addAll(Arrays.asList(patterns));
    }

    public void addIgnoreMappingPatterns(Pattern ... patterns) {
        this.ignoreMappingPatterns.addAll(Arrays.asList(patterns));
    }

    public void addMapping(String src, String dest) {
        this.mappings.add(new Mapping(src, dest));
    }

    public void addMapping(@Nonnull Map<String, String> mappings) {
        mappings.forEach(this::addMapping);
    }

    public void clearSourcePaths() {
        this.sourcePaths.clear();
    }

    public void clearExtensions() {
        this.extensions.clear();
    }

    public void clearIgnorePatterns() {
        this.ignorePatterns.clear();
    }

    public void clearIgnoreMappingPatterns() {
        this.ignoreMappingPatterns.clear();
    }

    public void clearNamePatterns() {
        this.namePatterns.clear();
    }

    public void clearMappings() {
        this.mappings.clear();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public File getSrcRoot() {
        return this.srcRoot;
    }

    public void setSrcRoot(File srcRoot) {
        this.srcRoot = srcRoot;
    }

    public File getDestRoot() {
        return this.destRoot;
    }

    public void setDestRoot(File destRoot) {
        this.destRoot = destRoot;
    }

    public boolean isCopyAll() {
        return this.copyAll;
    }

    public void setCopyAll(boolean copyAll) {
        this.copyAll = copyAll;
    }

    public boolean isIncludeFileName() {
        return this.includeFileName;
    }

    public void setIncludeFileName(boolean includeFileName) {
        this.includeFileName = includeFileName;
    }

    static class Mapping {
        private String src;
        private String dest;

        public String getSrc() {
            return this.src;
        }

        public String getDest() {
            return this.dest;
        }

        public Mapping(String src, String dest) {
            this.src = src;
            this.dest = dest;
        }
    }
}

