/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.transaction;

import io.polaris.framework.toolkit.annotation.EnableDynamicTransaction;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.config.AopConfigUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;

public class TransactionAspectHelper {
    private static final Logger log = LoggerFactory.getLogger(TransactionAspectHelper.class);
    private static final ThreadLocal<Boolean> RUNNING = ThreadLocal.withInitial(() -> false);

    public static void start() {
        RUNNING.set(true);
    }

    public static void stop() {
        RUNNING.remove();
    }

    public static boolean isStarted() {
        return Boolean.TRUE.equals(RUNNING.get());
    }

    public static Object proceed(Invokable interceptorCall, Invokable directiveCall) throws Throwable {
        if (TransactionAspectHelper.isStarted()) {
            return directiveCall.invoke();
        }
        TransactionAspectHelper.start();
        try {
            Object object = interceptorCall.invoke();
            return object;
        }
        finally {
            TransactionAspectHelper.stop();
        }
    }

    public static boolean registerAspectJIfNecessary(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableDynamicTransaction.class.getName(), false));
        if (annotationAttributes != null && annotationAttributes.getBoolean("enableAspectJAutoProxy")) {
            AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((BeanDefinitionRegistry)registry);
            if (annotationAttributes.getBoolean("proxyTargetClass")) {
                AopConfigUtils.forceAutoProxyCreatorToUseClassProxying((BeanDefinitionRegistry)registry);
            }
            if (annotationAttributes.getBoolean("exposeProxy")) {
                AopConfigUtils.forceAutoProxyCreatorToExposeProxy((BeanDefinitionRegistry)registry);
            }
            return true;
        }
        return false;
    }

    public static interface Invokable {
        public Object invoke() throws Throwable;
    }
}

