/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.transaction;

import io.polaris.framework.toolkit.transaction.TransactionAttributeName;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="platform.dynamic.transaction", ignoreUnknownFields=true)
public class DynamicTransactionProperties {
    private boolean enabled = false;
    private boolean enableAspectj = true;
    private boolean enableRepositoryAspect = false;
    private boolean enableServiceAspect = true;
    private boolean enableTransactionalAspect = true;
    private String classPattern = "";
    private String stdTransactionalMethods = "*";
    private String newTransactionalMethods = "log*,doLog*,async*,doAsync*";
    private String readonlyTransactionalMethods = "get*,count*,find*,list*,query*,select*,is*,has*,exist*";
    private String rollbackExceptions = "";
    private String noRollbackExceptions = "";
    private List<TransactionalMethodsRule> rules = new ArrayList<TransactionalMethodsRule>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnableAspectj() {
        return this.enableAspectj;
    }

    public boolean isEnableRepositoryAspect() {
        return this.enableRepositoryAspect;
    }

    public boolean isEnableServiceAspect() {
        return this.enableServiceAspect;
    }

    public boolean isEnableTransactionalAspect() {
        return this.enableTransactionalAspect;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getStdTransactionalMethods() {
        return this.stdTransactionalMethods;
    }

    public String getNewTransactionalMethods() {
        return this.newTransactionalMethods;
    }

    public String getReadonlyTransactionalMethods() {
        return this.readonlyTransactionalMethods;
    }

    public String getRollbackExceptions() {
        return this.rollbackExceptions;
    }

    public String getNoRollbackExceptions() {
        return this.noRollbackExceptions;
    }

    public List<TransactionalMethodsRule> getRules() {
        return this.rules;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnableAspectj(boolean enableAspectj) {
        this.enableAspectj = enableAspectj;
    }

    public void setEnableRepositoryAspect(boolean enableRepositoryAspect) {
        this.enableRepositoryAspect = enableRepositoryAspect;
    }

    public void setEnableServiceAspect(boolean enableServiceAspect) {
        this.enableServiceAspect = enableServiceAspect;
    }

    public void setEnableTransactionalAspect(boolean enableTransactionalAspect) {
        this.enableTransactionalAspect = enableTransactionalAspect;
    }

    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    public void setStdTransactionalMethods(String stdTransactionalMethods) {
        this.stdTransactionalMethods = stdTransactionalMethods;
    }

    public void setNewTransactionalMethods(String newTransactionalMethods) {
        this.newTransactionalMethods = newTransactionalMethods;
    }

    public void setReadonlyTransactionalMethods(String readonlyTransactionalMethods) {
        this.readonlyTransactionalMethods = readonlyTransactionalMethods;
    }

    public void setRollbackExceptions(String rollbackExceptions) {
        this.rollbackExceptions = rollbackExceptions;
    }

    public void setNoRollbackExceptions(String noRollbackExceptions) {
        this.noRollbackExceptions = noRollbackExceptions;
    }

    public void setRules(List<TransactionalMethodsRule> rules) {
        this.rules = rules;
    }

    public String toString() {
        return "DynamicTransactionProperties(enabled=" + this.enabled + ", enableAspectj=" + this.enableAspectj + ", enableRepositoryAspect=" + this.enableRepositoryAspect + ", enableServiceAspect=" + this.enableServiceAspect + ", enableTransactionalAspect=" + this.enableTransactionalAspect + ", classPattern=" + this.classPattern + ", stdTransactionalMethods=" + this.stdTransactionalMethods + ", newTransactionalMethods=" + this.newTransactionalMethods + ", readonlyTransactionalMethods=" + this.readonlyTransactionalMethods + ", rollbackExceptions=" + this.rollbackExceptions + ", noRollbackExceptions=" + this.noRollbackExceptions + ", rules=" + this.rules + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTransactionProperties)) {
            return false;
        }
        DynamicTransactionProperties other = (DynamicTransactionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.enableAspectj != other.enableAspectj) {
            return false;
        }
        if (this.enableRepositoryAspect != other.enableRepositoryAspect) {
            return false;
        }
        if (this.enableServiceAspect != other.enableServiceAspect) {
            return false;
        }
        if (this.enableTransactionalAspect != other.enableTransactionalAspect) {
            return false;
        }
        String this$classPattern = this.classPattern;
        String other$classPattern = other.classPattern;
        if (this$classPattern == null ? other$classPattern != null : !this$classPattern.equals(other$classPattern)) {
            return false;
        }
        String this$stdTransactionalMethods = this.stdTransactionalMethods;
        String other$stdTransactionalMethods = other.stdTransactionalMethods;
        if (this$stdTransactionalMethods == null ? other$stdTransactionalMethods != null : !this$stdTransactionalMethods.equals(other$stdTransactionalMethods)) {
            return false;
        }
        String this$newTransactionalMethods = this.newTransactionalMethods;
        String other$newTransactionalMethods = other.newTransactionalMethods;
        if (this$newTransactionalMethods == null ? other$newTransactionalMethods != null : !this$newTransactionalMethods.equals(other$newTransactionalMethods)) {
            return false;
        }
        String this$readonlyTransactionalMethods = this.readonlyTransactionalMethods;
        String other$readonlyTransactionalMethods = other.readonlyTransactionalMethods;
        if (this$readonlyTransactionalMethods == null ? other$readonlyTransactionalMethods != null : !this$readonlyTransactionalMethods.equals(other$readonlyTransactionalMethods)) {
            return false;
        }
        String this$rollbackExceptions = this.rollbackExceptions;
        String other$rollbackExceptions = other.rollbackExceptions;
        if (this$rollbackExceptions == null ? other$rollbackExceptions != null : !this$rollbackExceptions.equals(other$rollbackExceptions)) {
            return false;
        }
        String this$noRollbackExceptions = this.noRollbackExceptions;
        String other$noRollbackExceptions = other.noRollbackExceptions;
        if (this$noRollbackExceptions == null ? other$noRollbackExceptions != null : !this$noRollbackExceptions.equals(other$noRollbackExceptions)) {
            return false;
        }
        List<TransactionalMethodsRule> this$rules = this.rules;
        List<TransactionalMethodsRule> other$rules = other.rules;
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTransactionProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.enableAspectj ? 79 : 97);
        result = result * 59 + (this.enableRepositoryAspect ? 79 : 97);
        result = result * 59 + (this.enableServiceAspect ? 79 : 97);
        result = result * 59 + (this.enableTransactionalAspect ? 79 : 97);
        String $classPattern = this.classPattern;
        result = result * 59 + ($classPattern == null ? 43 : $classPattern.hashCode());
        String $stdTransactionalMethods = this.stdTransactionalMethods;
        result = result * 59 + ($stdTransactionalMethods == null ? 43 : $stdTransactionalMethods.hashCode());
        String $newTransactionalMethods = this.newTransactionalMethods;
        result = result * 59 + ($newTransactionalMethods == null ? 43 : $newTransactionalMethods.hashCode());
        String $readonlyTransactionalMethods = this.readonlyTransactionalMethods;
        result = result * 59 + ($readonlyTransactionalMethods == null ? 43 : $readonlyTransactionalMethods.hashCode());
        String $rollbackExceptions = this.rollbackExceptions;
        result = result * 59 + ($rollbackExceptions == null ? 43 : $rollbackExceptions.hashCode());
        String $noRollbackExceptions = this.noRollbackExceptions;
        result = result * 59 + ($noRollbackExceptions == null ? 43 : $noRollbackExceptions.hashCode());
        List<TransactionalMethodsRule> $rules = this.rules;
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public static class TransactionalMethodsRule {
        private String methods;
        private TransactionAttributeName.Propagation propagation = TransactionAttributeName.DEFAULT_PROPAGATION;
        private TransactionAttributeName.Isolation isolation = TransactionAttributeName.DEFAULT_ISOLATION;
        private int timeout = -1;
        private boolean readOnly = false;
        private String rollbackExceptions = "";
        private String noRollbackExceptions = "";

        public String getMethods() {
            return this.methods;
        }

        public TransactionAttributeName.Propagation getPropagation() {
            return this.propagation;
        }

        public TransactionAttributeName.Isolation getIsolation() {
            return this.isolation;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        public String getRollbackExceptions() {
            return this.rollbackExceptions;
        }

        public String getNoRollbackExceptions() {
            return this.noRollbackExceptions;
        }

        public void setMethods(String methods) {
            this.methods = methods;
        }

        public void setPropagation(TransactionAttributeName.Propagation propagation) {
            this.propagation = propagation;
        }

        public void setIsolation(TransactionAttributeName.Isolation isolation) {
            this.isolation = isolation;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
        }

        public void setRollbackExceptions(String rollbackExceptions) {
            this.rollbackExceptions = rollbackExceptions;
        }

        public void setNoRollbackExceptions(String noRollbackExceptions) {
            this.noRollbackExceptions = noRollbackExceptions;
        }

        public String toString() {
            return "DynamicTransactionProperties.TransactionalMethodsRule(methods=" + this.methods + ", propagation=" + (Object)((Object)this.propagation) + ", isolation=" + (Object)((Object)this.isolation) + ", timeout=" + this.timeout + ", readOnly=" + this.readOnly + ", rollbackExceptions=" + this.rollbackExceptions + ", noRollbackExceptions=" + this.noRollbackExceptions + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransactionalMethodsRule)) {
                return false;
            }
            TransactionalMethodsRule other = (TransactionalMethodsRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.timeout != other.timeout) {
                return false;
            }
            if (this.readOnly != other.readOnly) {
                return false;
            }
            String this$methods = this.methods;
            String other$methods = other.methods;
            if (this$methods == null ? other$methods != null : !this$methods.equals(other$methods)) {
                return false;
            }
            TransactionAttributeName.Propagation this$propagation = this.propagation;
            TransactionAttributeName.Propagation other$propagation = other.propagation;
            if (this$propagation == null ? other$propagation != null : !((Object)((Object)this$propagation)).equals((Object)other$propagation)) {
                return false;
            }
            TransactionAttributeName.Isolation this$isolation = this.isolation;
            TransactionAttributeName.Isolation other$isolation = other.isolation;
            if (this$isolation == null ? other$isolation != null : !((Object)((Object)this$isolation)).equals((Object)other$isolation)) {
                return false;
            }
            String this$rollbackExceptions = this.rollbackExceptions;
            String other$rollbackExceptions = other.rollbackExceptions;
            if (this$rollbackExceptions == null ? other$rollbackExceptions != null : !this$rollbackExceptions.equals(other$rollbackExceptions)) {
                return false;
            }
            String this$noRollbackExceptions = this.noRollbackExceptions;
            String other$noRollbackExceptions = other.noRollbackExceptions;
            return !(this$noRollbackExceptions == null ? other$noRollbackExceptions != null : !this$noRollbackExceptions.equals(other$noRollbackExceptions));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TransactionalMethodsRule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.timeout;
            result = result * 59 + (this.readOnly ? 79 : 97);
            String $methods = this.methods;
            result = result * 59 + ($methods == null ? 43 : $methods.hashCode());
            TransactionAttributeName.Propagation $propagation = this.propagation;
            result = result * 59 + ($propagation == null ? 43 : ((Object)((Object)$propagation)).hashCode());
            TransactionAttributeName.Isolation $isolation = this.isolation;
            result = result * 59 + ($isolation == null ? 43 : ((Object)((Object)$isolation)).hashCode());
            String $rollbackExceptions = this.rollbackExceptions;
            result = result * 59 + ($rollbackExceptions == null ? 43 : $rollbackExceptions.hashCode());
            String $noRollbackExceptions = this.noRollbackExceptions;
            result = result * 59 + ($noRollbackExceptions == null ? 43 : $noRollbackExceptions.hashCode());
            return result;
        }
    }
}

