/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import org.springframework.aop.ClassFilter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class InheritedAnnotationClassFilter
implements ClassFilter {
    private final Class<? extends Annotation> annotationType;
    private boolean checkInherited = true;
    private boolean checkMethods;

    public InheritedAnnotationClassFilter(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    public InheritedAnnotationClassFilter(Class<? extends Annotation> annotationType, boolean checkInherited) {
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
    }

    public InheritedAnnotationClassFilter(Class<? extends Annotation> annotationType, boolean checkInherited, boolean checkMethods) {
        this.annotationType = annotationType;
        this.checkInherited = checkInherited;
        this.checkMethods = checkMethods;
    }

    public static InheritedAnnotationClassFilter withClassAnnotation(Class<? extends Annotation> annotationType, boolean checkInherited) {
        return new InheritedAnnotationClassFilter(annotationType, checkInherited);
    }

    public static InheritedAnnotationClassFilter withClassAnnotation(Class<? extends Annotation> annotationType) {
        return new InheritedAnnotationClassFilter(annotationType, true);
    }

    public static InheritedAnnotationClassFilter withClassOrMethodAnnotation(Class<? extends Annotation> annotationType, boolean checkInherited) {
        return new InheritedAnnotationClassFilter(annotationType, checkInherited, true);
    }

    public static InheritedAnnotationClassFilter withClassOrMethodAnnotation(Class<? extends Annotation> annotationType) {
        return new InheritedAnnotationClassFilter(annotationType, true, true);
    }

    public boolean matches(Class<?> targetClass) {
        if (this.checkInherited ? AnnotatedElementUtils.hasAnnotation(targetClass, this.annotationType) : targetClass.isAnnotationPresent(this.annotationType)) {
            return true;
        }
        if (this.checkMethods) {
            LinkedHashSet<Class> classes = new LinkedHashSet<Class>();
            if (!Proxy.isProxyClass(targetClass)) {
                classes.add(ClassUtils.getUserClass(targetClass));
            }
            classes.addAll(ClassUtils.getAllInterfacesForClassAsSet(targetClass));
            for (Class clazz : classes) {
                Method[] methods;
                for (Method method : methods = ReflectionUtils.getAllDeclaredMethods((Class)clazz)) {
                    if (!AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, this.annotationType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public boolean isCheckInherited() {
        return this.checkInherited;
    }

    public boolean isCheckMethods() {
        return this.checkMethods;
    }

    public void setCheckInherited(boolean checkInherited) {
        this.checkInherited = checkInherited;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }
}

