/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.mybatis.pagehelper;

import com.github.pagehelper.Dialect;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.page.PageAutoDialect;
import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import io.polaris.framework.toolkit.mybatis.pagehelper.DynamicPageHelperProperties;
import io.polaris.framework.toolkit.mybatis.pagehelper.StandardPageHelperProperties;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.ibatis.mapping.MappedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPageAutoDialect
extends PageAutoDialect {
    private static final Logger log = LoggerFactory.getLogger(DynamicPageAutoDialect.class);
    private static Map<String, Class<? extends Dialect>> dialectAliasMap;
    private static Map<String, DialectInfo> dynamicDialects;
    private Properties properties;

    public static void registerDynamicPageHelperProperties(DynamicPageHelperProperties dynamicPageHelperProperties) {
        Map<String, StandardPageHelperProperties> targets = dynamicPageHelperProperties.getTargets();
        if (targets != null) {
            for (Map.Entry<String, StandardPageHelperProperties> entry : targets.entrySet()) {
                String key = entry.getKey();
                StandardPageHelperProperties properties = entry.getValue();
                String dialect = properties.getDialect();
                if (!Strings.isNotBlank((CharSequence)dialect)) continue;
                DialectInfo dialectInfo = new DialectInfo();
                dialectInfo.setDialectName(dialect);
                dialectInfo.setProperties(properties.getProperties());
                dynamicDialects.put(key, dialectInfo);
            }
        }
    }

    public void initDelegateDialect(MappedStatement ms, String dialectClass) {
        if (this.getDynamicDialect() == null) {
            super.initDelegateDialect(ms, dialectClass);
        }
    }

    private AbstractHelperDialect getDynamicDialect() {
        DialectInfo dialectInfo;
        String key = DynamicDataSourceKeys.getOrDefault(null);
        if (key != null && (dialectInfo = dynamicDialects.get(key)) != null && dialectInfo.existsDialect(this.properties)) {
            return dialectInfo.getDialect();
        }
        return null;
    }

    public AbstractHelperDialect getDelegate() {
        AbstractHelperDialect dialect = this.getDynamicDialect();
        if (dialect != null) {
            return dialect;
        }
        return super.getDelegate();
    }

    public void setProperties(Properties properties) {
        properties.setProperty("autoRuntimeDialect", "true");
        super.setProperties(properties);
        DynamicPageAutoDialect.initPrivateMemberDialectAliasMap();
        this.properties = properties;
    }

    private static void initPrivateMemberDialectAliasMap() {
        if (dialectAliasMap != null) {
            return;
        }
        try {
            Map dialectAliasMap;
            Field field = PageAutoDialect.class.getDeclaredField("dialectAliasMap");
            field.setAccessible(true);
            DynamicPageAutoDialect.dialectAliasMap = dialectAliasMap = (Map)field.get(null);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        dynamicDialects = new HashMap<String, DialectInfo>();
    }

    static class DialectInfo {
        private boolean initialized = false;
        private AbstractHelperDialect dialect;
        private String dialectName;
        private Properties properties;

        DialectInfo() {
        }

        public boolean existsDialect(Properties properties) {
            if (this.initialized) {
                return this.dialect != null;
            }
            try {
                Class sqlDialectClass = dialectAliasMap.containsKey(this.dialectName.toLowerCase()) ? (Class)dialectAliasMap.get(this.dialectName.toLowerCase()) : Class.forName(this.dialectName);
                if (AbstractHelperDialect.class.isAssignableFrom(sqlDialectClass)) {
                    this.dialect = (AbstractHelperDialect)sqlDialectClass.newInstance();
                }
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.properties.setProperty((String)k, (String)v)));
                this.dialect.setProperties(this.properties);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            this.initialized = true;
            return this.dialect != null;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public AbstractHelperDialect getDialect() {
            return this.dialect;
        }

        public String getDialectName() {
            return this.dialectName;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public void setDialect(AbstractHelperDialect dialect) {
            this.dialect = dialect;
        }

        public void setDialectName(String dialectName) {
            this.dialectName = dialectName;
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }
    }
}

