/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.mybatis.autoconfigure;

import com.github.pagehelper.PageInterceptor;
import io.polaris.framework.toolkit.mybatis.pagehelper.PageHelperProperties;
import io.polaris.framework.toolkit.mybatis.pagehelper.StandardPageHelperProperties;
import io.polaris.mybatis.interceptor.DataAuthInterceptor;
import io.polaris.mybatis.interceptor.DynamicUseGeneratedKeysInterceptor;
import io.polaris.mybatis.interceptor.MybatisLogInterceptor;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@ConditionalOnBean(value={SqlSessionFactory.class})
@EnableConfigurationProperties(value={StandardPageHelperProperties.class})
@AutoConfigureAfter(name={"org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration", "io.polaris.framework.toolkit.mybatis.autoconfigure.MybatisAutoConfiguration"})
@Lazy(value=false)
public class MybatisInterceptorAutoConfiguration
implements InitializingBean {
    private final List<SqlSessionFactory> sqlSessionFactoryList;
    private final StandardPageHelperProperties standardProperties;
    private final PageHelperProperties properties;

    public MybatisInterceptorAutoConfiguration(List<SqlSessionFactory> sqlSessionFactoryList, StandardPageHelperProperties standardProperties) {
        this.sqlSessionFactoryList = sqlSessionFactoryList;
        this.standardProperties = standardProperties;
        this.properties = standardProperties.getProperties();
    }

    public void afterPropertiesSet() throws Exception {
        PageInterceptor pageInterceptor = new PageInterceptor();
        pageInterceptor.setProperties((Properties)this.properties);
        List<Interceptor> interceptors = Arrays.asList(pageInterceptor, new MybatisLogInterceptor(), new DataAuthInterceptor(), new DynamicUseGeneratedKeysInterceptor());
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
            for (Interceptor interceptor : interceptors) {
                if (this.containsInterceptor(configuration, interceptor)) continue;
                configuration.addInterceptor(interceptor);
            }
        }
    }

    private boolean containsInterceptor(org.apache.ibatis.session.Configuration configuration, Interceptor interceptor) {
        try {
            return configuration.getInterceptors().stream().anyMatch(config -> interceptor.getClass().isAssignableFrom(config.getClass()));
        }
        catch (Exception e) {
            return false;
        }
    }
}

