/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc.properties;

import io.polaris.framework.toolkit.jdbc.DynamicDataSourceBuilder;
import io.polaris.framework.toolkit.jdbc.properties.DruidProperties;
import io.polaris.framework.toolkit.jdbc.properties.HikariProperties;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;

public class TargetDataSourceProperties {
    private String name;
    private boolean generateUniqueName = true;
    private Class<? extends DataSource> type;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String jndiName;
    private DataSourceInitializationMode initializationMode = DataSourceInitializationMode.EMBEDDED;
    private String platform = "all";
    private List<String> schema;
    private String schemaUsername;
    private String schemaPassword;
    private List<String> data;
    private String dataUsername;
    private String dataPassword;
    private boolean continueOnError = false;
    private String separator = ";";
    private Charset sqlScriptEncoding;
    private EmbeddedDatabaseConnection embeddedDatabaseConnection = EmbeddedDatabaseConnection.NONE;
    private DataSourceProperties.Xa xa = new DataSourceProperties.Xa();
    private String uniqueName;
    private String classPattern = "";
    private HikariProperties hikari;
    private DruidProperties druid;
    private Map<String, String> ext = new HashMap<String, String>();
    private ClassLoader classLoader;
    private DataSourceProperties properties;

    public void afterPropertiesSet(ClassLoader classLoader) {
        if (this.classLoader == null) {
            this.classLoader = classLoader;
        }
        if (this.properties == null) {
            this.properties = this.asDataSourceProperties(classLoader);
        }
    }

    public DataSource buildDataSource(ClassLoader classLoader) {
        this.afterPropertiesSet(classLoader);
        return this.buildDataSource();
    }

    public DataSource buildDataSource() {
        return DynamicDataSourceBuilder.create(this.classLoader).properties(this).build();
    }

    public DataSourceProperties asDataSourceProperties() {
        return this.asDataSourceProperties(this.classLoader);
    }

    public DataSourceProperties asDataSourceProperties(ClassLoader classLoader) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setBeanClassLoader(classLoader);
        dataSourceProperties.setName(this.getName());
        dataSourceProperties.setGenerateUniqueName(this.isGenerateUniqueName());
        dataSourceProperties.setType(this.getType());
        dataSourceProperties.setDriverClassName(this.getDriverClassName());
        dataSourceProperties.setUrl(this.getUrl());
        dataSourceProperties.setUsername(this.getUsername());
        dataSourceProperties.setPassword(this.getPassword());
        dataSourceProperties.setJndiName(this.getJndiName());
        dataSourceProperties.setInitializationMode(this.getInitializationMode());
        dataSourceProperties.setPlatform(this.getPlatform());
        dataSourceProperties.setSchema(this.getSchema());
        dataSourceProperties.setSchemaUsername(this.getSchemaUsername());
        dataSourceProperties.setSchemaPassword(this.getSchemaPassword());
        dataSourceProperties.setData(this.getData());
        dataSourceProperties.setDataUsername(this.getDataUsername());
        dataSourceProperties.setDataPassword(this.getDataPassword());
        dataSourceProperties.setContinueOnError(this.isContinueOnError());
        dataSourceProperties.setSeparator(this.getSeparator());
        dataSourceProperties.setSqlScriptEncoding(this.getSqlScriptEncoding());
        dataSourceProperties.setXa(this.getXa());
        try {
            dataSourceProperties.afterPropertiesSet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        dataSourceProperties.setUsername(dataSourceProperties.determineUsername());
        dataSourceProperties.setPassword(dataSourceProperties.determinePassword());
        dataSourceProperties.setUrl(dataSourceProperties.determineUrl());
        dataSourceProperties.setDriverClassName(dataSourceProperties.determineDriverClassName());
        return dataSourceProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean isGenerateUniqueName() {
        return this.generateUniqueName;
    }

    public Class<? extends DataSource> getType() {
        return this.type;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public DataSourceInitializationMode getInitializationMode() {
        return this.initializationMode;
    }

    public String getPlatform() {
        return this.platform;
    }

    public List<String> getSchema() {
        return this.schema;
    }

    public String getSchemaUsername() {
        return this.schemaUsername;
    }

    public String getSchemaPassword() {
        return this.schemaPassword;
    }

    public List<String> getData() {
        return this.data;
    }

    public String getDataUsername() {
        return this.dataUsername;
    }

    public String getDataPassword() {
        return this.dataPassword;
    }

    public boolean isContinueOnError() {
        return this.continueOnError;
    }

    public String getSeparator() {
        return this.separator;
    }

    public Charset getSqlScriptEncoding() {
        return this.sqlScriptEncoding;
    }

    public EmbeddedDatabaseConnection getEmbeddedDatabaseConnection() {
        return this.embeddedDatabaseConnection;
    }

    public DataSourceProperties.Xa getXa() {
        return this.xa;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public HikariProperties getHikari() {
        return this.hikari;
    }

    public DruidProperties getDruid() {
        return this.druid;
    }

    public Map<String, String> getExt() {
        return this.ext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public DataSourceProperties getProperties() {
        return this.properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGenerateUniqueName(boolean generateUniqueName) {
        this.generateUniqueName = generateUniqueName;
    }

    public void setType(Class<? extends DataSource> type) {
        this.type = type;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setInitializationMode(DataSourceInitializationMode initializationMode) {
        this.initializationMode = initializationMode;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setSchema(List<String> schema) {
        this.schema = schema;
    }

    public void setSchemaUsername(String schemaUsername) {
        this.schemaUsername = schemaUsername;
    }

    public void setSchemaPassword(String schemaPassword) {
        this.schemaPassword = schemaPassword;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public void setDataUsername(String dataUsername) {
        this.dataUsername = dataUsername;
    }

    public void setDataPassword(String dataPassword) {
        this.dataPassword = dataPassword;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setSqlScriptEncoding(Charset sqlScriptEncoding) {
        this.sqlScriptEncoding = sqlScriptEncoding;
    }

    public void setEmbeddedDatabaseConnection(EmbeddedDatabaseConnection embeddedDatabaseConnection) {
        this.embeddedDatabaseConnection = embeddedDatabaseConnection;
    }

    public void setXa(DataSourceProperties.Xa xa) {
        this.xa = xa;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    public void setHikari(HikariProperties hikari) {
        this.hikari = hikari;
    }

    public void setDruid(DruidProperties druid) {
        this.druid = druid;
    }

    public void setExt(Map<String, String> ext) {
        this.ext = ext;
    }

    public String toString() {
        return "TargetDataSourceProperties(name=" + this.name + ", generateUniqueName=" + this.generateUniqueName + ", type=" + this.type + ", driverClassName=" + this.driverClassName + ", url=" + this.url + ", username=" + this.username + ", password=" + this.password + ", jndiName=" + this.jndiName + ", initializationMode=" + this.initializationMode + ", platform=" + this.platform + ", schema=" + this.schema + ", schemaUsername=" + this.schemaUsername + ", schemaPassword=" + this.schemaPassword + ", data=" + this.data + ", dataUsername=" + this.dataUsername + ", dataPassword=" + this.dataPassword + ", continueOnError=" + this.continueOnError + ", separator=" + this.separator + ", sqlScriptEncoding=" + this.sqlScriptEncoding + ", embeddedDatabaseConnection=" + this.embeddedDatabaseConnection + ", xa=" + this.xa + ", uniqueName=" + this.uniqueName + ", classPattern=" + this.classPattern + ", hikari=" + this.hikari + ", druid=" + this.druid + ", ext=" + this.ext + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetDataSourceProperties)) {
            return false;
        }
        TargetDataSourceProperties other = (TargetDataSourceProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.generateUniqueName != other.generateUniqueName) {
            return false;
        }
        if (this.continueOnError != other.continueOnError) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Class<? extends DataSource> this$type = this.type;
        Class<? extends DataSource> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$driverClassName = this.driverClassName;
        String other$driverClassName = other.driverClassName;
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$username = this.username;
        String other$username = other.username;
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$jndiName = this.jndiName;
        String other$jndiName = other.jndiName;
        if (this$jndiName == null ? other$jndiName != null : !this$jndiName.equals(other$jndiName)) {
            return false;
        }
        DataSourceInitializationMode this$initializationMode = this.initializationMode;
        DataSourceInitializationMode other$initializationMode = other.initializationMode;
        if (this$initializationMode == null ? other$initializationMode != null : !this$initializationMode.equals(other$initializationMode)) {
            return false;
        }
        String this$platform = this.platform;
        String other$platform = other.platform;
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        List<String> this$schema = this.schema;
        List<String> other$schema = other.schema;
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        String this$schemaUsername = this.schemaUsername;
        String other$schemaUsername = other.schemaUsername;
        if (this$schemaUsername == null ? other$schemaUsername != null : !this$schemaUsername.equals(other$schemaUsername)) {
            return false;
        }
        String this$schemaPassword = this.schemaPassword;
        String other$schemaPassword = other.schemaPassword;
        if (this$schemaPassword == null ? other$schemaPassword != null : !this$schemaPassword.equals(other$schemaPassword)) {
            return false;
        }
        List<String> this$data = this.data;
        List<String> other$data = other.data;
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$dataUsername = this.dataUsername;
        String other$dataUsername = other.dataUsername;
        if (this$dataUsername == null ? other$dataUsername != null : !this$dataUsername.equals(other$dataUsername)) {
            return false;
        }
        String this$dataPassword = this.dataPassword;
        String other$dataPassword = other.dataPassword;
        if (this$dataPassword == null ? other$dataPassword != null : !this$dataPassword.equals(other$dataPassword)) {
            return false;
        }
        String this$separator = this.separator;
        String other$separator = other.separator;
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) {
            return false;
        }
        Charset this$sqlScriptEncoding = this.sqlScriptEncoding;
        Charset other$sqlScriptEncoding = other.sqlScriptEncoding;
        if (this$sqlScriptEncoding == null ? other$sqlScriptEncoding != null : !((Object)this$sqlScriptEncoding).equals(other$sqlScriptEncoding)) {
            return false;
        }
        EmbeddedDatabaseConnection this$embeddedDatabaseConnection = this.embeddedDatabaseConnection;
        EmbeddedDatabaseConnection other$embeddedDatabaseConnection = other.embeddedDatabaseConnection;
        if (this$embeddedDatabaseConnection == null ? other$embeddedDatabaseConnection != null : !this$embeddedDatabaseConnection.equals(other$embeddedDatabaseConnection)) {
            return false;
        }
        DataSourceProperties.Xa this$xa = this.xa;
        DataSourceProperties.Xa other$xa = other.xa;
        if (this$xa == null ? other$xa != null : !this$xa.equals(other$xa)) {
            return false;
        }
        String this$uniqueName = this.uniqueName;
        String other$uniqueName = other.uniqueName;
        if (this$uniqueName == null ? other$uniqueName != null : !this$uniqueName.equals(other$uniqueName)) {
            return false;
        }
        String this$classPattern = this.classPattern;
        String other$classPattern = other.classPattern;
        if (this$classPattern == null ? other$classPattern != null : !this$classPattern.equals(other$classPattern)) {
            return false;
        }
        HikariProperties this$hikari = this.hikari;
        HikariProperties other$hikari = other.hikari;
        if (this$hikari == null ? other$hikari != null : !((Object)this$hikari).equals(other$hikari)) {
            return false;
        }
        DruidProperties this$druid = this.druid;
        DruidProperties other$druid = other.druid;
        if (this$druid == null ? other$druid != null : !((Object)this$druid).equals(other$druid)) {
            return false;
        }
        Map<String, String> this$ext = this.ext;
        Map<String, String> other$ext = other.ext;
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TargetDataSourceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.generateUniqueName ? 79 : 97);
        result = result * 59 + (this.continueOnError ? 79 : 97);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Class<? extends DataSource> $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $driverClassName = this.driverClassName;
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $username = this.username;
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $jndiName = this.jndiName;
        result = result * 59 + ($jndiName == null ? 43 : $jndiName.hashCode());
        DataSourceInitializationMode $initializationMode = this.initializationMode;
        result = result * 59 + ($initializationMode == null ? 43 : $initializationMode.hashCode());
        String $platform = this.platform;
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        List<String> $schema = this.schema;
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        String $schemaUsername = this.schemaUsername;
        result = result * 59 + ($schemaUsername == null ? 43 : $schemaUsername.hashCode());
        String $schemaPassword = this.schemaPassword;
        result = result * 59 + ($schemaPassword == null ? 43 : $schemaPassword.hashCode());
        List<String> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $dataUsername = this.dataUsername;
        result = result * 59 + ($dataUsername == null ? 43 : $dataUsername.hashCode());
        String $dataPassword = this.dataPassword;
        result = result * 59 + ($dataPassword == null ? 43 : $dataPassword.hashCode());
        String $separator = this.separator;
        result = result * 59 + ($separator == null ? 43 : $separator.hashCode());
        Charset $sqlScriptEncoding = this.sqlScriptEncoding;
        result = result * 59 + ($sqlScriptEncoding == null ? 43 : ((Object)$sqlScriptEncoding).hashCode());
        EmbeddedDatabaseConnection $embeddedDatabaseConnection = this.embeddedDatabaseConnection;
        result = result * 59 + ($embeddedDatabaseConnection == null ? 43 : $embeddedDatabaseConnection.hashCode());
        DataSourceProperties.Xa $xa = this.xa;
        result = result * 59 + ($xa == null ? 43 : $xa.hashCode());
        String $uniqueName = this.uniqueName;
        result = result * 59 + ($uniqueName == null ? 43 : $uniqueName.hashCode());
        String $classPattern = this.classPattern;
        result = result * 59 + ($classPattern == null ? 43 : $classPattern.hashCode());
        HikariProperties $hikari = this.hikari;
        result = result * 59 + ($hikari == null ? 43 : ((Object)$hikari).hashCode());
        DruidProperties $druid = this.druid;
        result = result * 59 + ($druid == null ? 43 : ((Object)$druid).hashCode());
        Map<String, String> $ext = this.ext;
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }
}

