/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc.init;

import io.polaris.framework.toolkit.jdbc.DynamicDataSource;
import io.polaris.framework.toolkit.jdbc.init.DataSourceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceSchemaCreatedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class DataSourceInitializerInvoker
implements ApplicationListener<DataSourceSchemaCreatedEvent>,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DataSourceInitializerInvoker.class);
    private final DynamicDataSource dataSource;
    private ApplicationContext applicationContext;
    private boolean schemaCreated;
    private boolean initialized;
    private DataSourceInitializer dataSourceInitializer;

    public DataSourceInitializerInvoker(DynamicDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        DataSourceInitializer initializer = this.getDataSourceInitializer();
        if (initializer != null) {
            if (!this.schemaCreated) {
                this.schemaCreated = this.dataSourceInitializer.createSchema();
            }
            if (this.schemaCreated) {
                this.initialize(initializer);
            }
        }
    }

    private void initialize(DataSourceInitializer initializer) {
        try {
            if (!this.initialized) {
                this.dataSourceInitializer.initSchema();
                this.initialized = true;
            }
        }
        catch (IllegalStateException ex) {
            log.warn("Could not send event to complete DataSource initialization ({})", (Object)ex.getMessage());
        }
    }

    public void onApplicationEvent(DataSourceSchemaCreatedEvent event) {
        DataSourceInitializer initializer = this.getDataSourceInitializer();
        if (!this.initialized && initializer != null) {
            initializer.initSchema();
            this.initialized = true;
        }
    }

    private DataSourceInitializer getDataSourceInitializer() {
        if (this.dataSourceInitializer == null && this.dataSource != null) {
            this.dataSourceInitializer = new DataSourceInitializer(this.dataSource, this.applicationContext);
        }
        return this.dataSourceInitializer;
    }
}

