/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc.init;

import io.polaris.core.string.Strings;
import io.polaris.core.tuple.Tuple2;
import io.polaris.framework.toolkit.jdbc.DynamicDataSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.config.SortedResourcesFactoryBean;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

class DataSourceInitializer {
    private static final Logger log = LoggerFactory.getLogger(DataSourceInitializer.class);
    private final DynamicDataSource dynamicDataSource;
    private final ResourceLoader resourceLoader;
    private final Map<String, Tuple2<DataSource, DataSourceProperties>> dataSourceProperties;

    public DataSourceInitializer(DynamicDataSource dynamicDataSource, ApplicationContext applicationContext) {
        this.dynamicDataSource = dynamicDataSource;
        this.resourceLoader = applicationContext != null ? applicationContext : new DefaultResourceLoader(null);
        Map<String, Tuple2<DataSource, DataSourceProperties>> dataSourceProperties = dynamicDataSource.getDataSourceProperties();
        this.dataSourceProperties = dataSourceProperties;
    }

    boolean createSchema() {
        boolean created = false;
        for (Map.Entry<String, Tuple2<DataSource, DataSourceProperties>> entry : this.dataSourceProperties.entrySet()) {
            String dsName = entry.getKey();
            Tuple2<DataSource, DataSourceProperties> tuple = entry.getValue();
            DataSource ds = (DataSource)tuple.getFirst();
            DataSourceProperties properties = (DataSourceProperties)tuple.getSecond();
            List<Resource> scripts = this.getScripts(properties, properties.getSchema(), "schema-" + dsName);
            if (scripts.isEmpty()) continue;
            if (!this.isEnabled(ds, properties)) {
                log.debug("DynamicDataSource[{}] initialization disabled (not running DDL scripts)", (Object)dsName);
                continue;
            }
            String username = properties.getSchemaUsername();
            String password = properties.getSchemaPassword();
            log.info("\u6267\u884c\u6570\u636e\u6e90[{}]\u7684\u521d\u59cb\u5316DDL\u811a\u672c", (Object)dsName);
            this.runScripts(ds, properties, scripts, username, password);
            created = true;
        }
        return created;
    }

    void initSchema() {
        for (Map.Entry<String, Tuple2<DataSource, DataSourceProperties>> entry : this.dataSourceProperties.entrySet()) {
            String dsName = entry.getKey();
            Tuple2<DataSource, DataSourceProperties> tuple = entry.getValue();
            DataSource ds = (DataSource)tuple.getFirst();
            DataSourceProperties properties = (DataSourceProperties)tuple.getSecond();
            List<Resource> scripts = this.getScripts(properties, properties.getData(), "data-" + dsName);
            if (scripts.isEmpty()) continue;
            if (!this.isEnabled(ds, properties)) {
                log.debug("DynamicDataSource[{}] initialization disabled (not running data scripts)", (Object)dsName);
                continue;
            }
            String username = properties.getDataUsername();
            String password = properties.getDataPassword();
            log.info("\u6267\u884c\u6570\u636e\u6e90[{}]\u7684\u521d\u59cb\u5316Data\u811a\u672c", (Object)dsName);
            this.runScripts(ds, properties, scripts, username, password);
        }
    }

    private boolean isEnabled(DataSource dataSource, DataSourceProperties properties) {
        DataSourceInitializationMode mode = properties.getInitializationMode();
        if (mode == DataSourceInitializationMode.NEVER) {
            return false;
        }
        return mode != DataSourceInitializationMode.EMBEDDED || this.isEmbedded(dataSource);
    }

    private boolean isEmbedded(DataSource dataSource) {
        try {
            return EmbeddedDatabaseConnection.isEmbedded((DataSource)dataSource);
        }
        catch (Exception ex) {
            log.debug("Could not determine if datasource is embedded", (Throwable)ex);
            return false;
        }
    }

    private List<Resource> getScripts(DataSourceProperties properties, List<String> resources, String fallback) {
        if (resources != null) {
            return this.getResources(resources);
        }
        String platform = properties.getPlatform();
        ArrayList<String> fallbackResources = new ArrayList<String>();
        fallbackResources.add("classpath*:" + fallback + "-" + platform + ".sql");
        fallbackResources.add("classpath*:" + fallback + ".sql");
        return this.getResources(fallbackResources);
    }

    private List<Resource> getResources(List<String> locations) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : locations) {
            for (Resource resource : this.doGetResources(location)) {
                if (!resource.exists()) continue;
                resources.add(resource);
            }
        }
        return resources;
    }

    private Resource[] doGetResources(String location) {
        try {
            SortedResourcesFactoryBean factory = new SortedResourcesFactoryBean(this.resourceLoader, Collections.singletonList(location));
            factory.afterPropertiesSet();
            return (Resource[])factory.getObject();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load resources from " + location, ex);
        }
    }

    private void runScripts(DataSource dataSource, DataSourceProperties properties, List<Resource> resources, String username, String password) {
        if (resources.isEmpty()) {
            return;
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(properties.isContinueOnError());
        populator.setSeparator(properties.getSeparator());
        if (properties.getSqlScriptEncoding() != null) {
            populator.setSqlScriptEncoding(properties.getSqlScriptEncoding().name());
        }
        for (Resource resource : resources) {
            populator.addScript(resource);
        }
        if (Strings.isNotBlank((CharSequence)username) && Strings.isNotBlank((CharSequence)password)) {
            dataSource = DataSourceBuilder.create((ClassLoader)properties.getClassLoader()).driverClassName(properties.determineDriverClassName()).url(properties.determineUrl()).username(username).password(password).build();
        }
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
    }

    public DynamicDataSource getDynamicDataSource() {
        return this.dynamicDataSource;
    }
}

