/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc.flyway;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.configuration.Configuration;

public class DynamicFlyway
extends Flyway {
    private List<Flyway> flyways = new ArrayList<Flyway>();

    public DynamicFlyway() {
        super((Configuration)Flyway.configure());
    }

    public void add(Flyway flyway) {
        this.flyways.add(flyway);
    }

    public int migrate() throws FlywayException {
        int num = 0;
        for (Flyway flyway : this.flyways) {
            num += flyway.migrate();
        }
        return num;
    }

    public int undo() throws FlywayException {
        int num = 0;
        for (Flyway flyway : this.flyways) {
            num += flyway.undo();
        }
        return num;
    }

    public void validate() throws FlywayException {
        for (Flyway flyway : this.flyways) {
            flyway.validate();
        }
    }

    public void clean() {
        for (Flyway flyway : this.flyways) {
            flyway.clean();
        }
    }

    public MigrationInfoService info() {
        throw new UnsupportedOperationException();
    }

    public void baseline() throws FlywayException {
        for (Flyway flyway : this.flyways) {
            flyway.baseline();
        }
    }

    public void repair() throws FlywayException {
        for (Flyway flyway : this.flyways) {
            flyway.repair();
        }
    }
}

