/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.DynamicDataSourceBuilder;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;

public class TargetDataSourceFactory
implements FactoryBean<DataSource> {
    private final String beanName;
    private final DynamicDataSourceBuilder builder;
    private DataSource dataSource;

    public TargetDataSourceFactory(String beanName, TargetDataSourceProperties properties) {
        this.beanName = beanName;
        this.builder = DynamicDataSourceBuilder.create(properties.getClassLoader()).properties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getObject() throws Exception {
        DynamicDataSourceBuilder dynamicDataSourceBuilder = this.builder;
        synchronized (dynamicDataSourceBuilder) {
            DataSource dataSource;
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.dataSource = dataSource = this.builder.build();
            DynamicDataSourceKeys.add(this.beanName);
            return dataSource;
        }
    }

    public Class<?> getObjectType() {
        return this.builder.determineType();
    }

    public boolean isSingleton() {
        return true;
    }
}

