/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityManagerFactory;

public class EntityManagerFactoryProxyBuilder {
    private EntityManagerFactory defaultEntityManagerFactory;
    private Map<Object, EntityManagerFactory> targetEntityManagerFactory = new ConcurrentHashMap<Object, EntityManagerFactory>();

    public EntityManagerFactoryProxyBuilder withDefault(EntityManagerFactory entityManagerFactory) {
        this.defaultEntityManagerFactory = entityManagerFactory;
        this.targetEntityManagerFactory.put("default", entityManagerFactory);
        return this;
    }

    public EntityManagerFactoryProxyBuilder withTarget(String id, EntityManagerFactory factory) {
        this.targetEntityManagerFactory.put(id, factory);
        return this;
    }

    public EntityManagerFactoryProxyBuilder withTargets(Map<Object, EntityManagerFactory> targets) {
        this.targetEntityManagerFactory.putAll(targets);
        return this;
    }

    public EntityManagerFactory build() {
        ClassLoader classLoader = this.defaultEntityManagerFactory.getClass().getClassLoader();
        Class<?>[] interfaces = this.defaultEntityManagerFactory.getClass().getInterfaces();
        return (EntityManagerFactory)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ProxyInvocationHandler(this.defaultEntityManagerFactory, this.targetEntityManagerFactory));
    }

    private static class ProxyInvocationHandler
    implements InvocationHandler {
        private final EntityManagerFactory defaultTarget;
        private final Map<Object, EntityManagerFactory> targetTable;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("toString")) {
                StringBuilder sb = new StringBuilder("EntityManagerFactory-Proxy for ");
                if (this.defaultTarget != null) {
                    sb.append(" defaultTarget: [").append(this.defaultTarget.toString()).append("]");
                }
                if (this.targetTable != null) {
                    sb.append(" targetTable: [").append(this.targetTable).append("]");
                }
                return sb.toString();
            }
            EntityManagerFactory actualTarget = null;
            String key = DynamicDataSourceKeys.get();
            if (key != null) {
                actualTarget = this.targetTable.get(key);
            }
            if (actualTarget == null) {
                actualTarget = this.defaultTarget;
            }
            if (actualTarget == null) {
                throw new IllegalStateException("\u627e\u4e0d\u5230 EntityManagerFactory \u5b9e\u4f8b");
            }
            Object rs = method.invoke((Object)actualTarget, args);
            return rs;
        }

        public ProxyInvocationHandler(EntityManagerFactory defaultTarget, Map<Object, EntityManagerFactory> targetTable) {
            this.defaultTarget = defaultTarget;
            this.targetTable = targetTable;
        }
    }
}

