/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="platform.dynamic.datasource", ignoreUnknownFields=true)
public class DynamicDataSourceProperties
implements BeanClassLoaderAware,
InitializingBean {
    private boolean enabled = false;
    private boolean multiple = true;
    private String beanName = "dynamicDataSource";
    private boolean registerPrimary = true;
    private boolean registerAllTargets = true;
    private boolean enableAspectj = true;
    private boolean enableAllTargets = false;
    private String targetNames;
    private String primaryName;
    private TargetDataSourceProperties primary;
    private Map<String, TargetDataSourceProperties> targets = new HashMap<String, TargetDataSourceProperties>();
    private boolean enableTransactionDelegate = false;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.primary != null) {
            this.primary.afterPropertiesSet(this.classLoader);
        }
        if (this.targets != null) {
            for (TargetDataSourceProperties targetDataSourceProperties : this.targets.values()) {
                targetDataSourceProperties.afterPropertiesSet(this.classLoader);
            }
        }
    }

    public TargetDataSourceProperties getTargetDataSourceProperties(String key) {
        TargetDataSourceProperties properties = this.targets.get(key);
        return properties == null ? null : properties;
    }

    public DataSourceProperties asDataSourceProperties(TargetDataSourceProperties sourceProperties) {
        return sourceProperties.asDataSourceProperties(this.classLoader);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isRegisterPrimary() {
        return this.registerPrimary;
    }

    public boolean isRegisterAllTargets() {
        return this.registerAllTargets;
    }

    public boolean isEnableAspectj() {
        return this.enableAspectj;
    }

    public boolean isEnableAllTargets() {
        return this.enableAllTargets;
    }

    public String getTargetNames() {
        return this.targetNames;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public TargetDataSourceProperties getPrimary() {
        return this.primary;
    }

    public Map<String, TargetDataSourceProperties> getTargets() {
        return this.targets;
    }

    public boolean isEnableTransactionDelegate() {
        return this.enableTransactionDelegate;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setRegisterPrimary(boolean registerPrimary) {
        this.registerPrimary = registerPrimary;
    }

    public void setRegisterAllTargets(boolean registerAllTargets) {
        this.registerAllTargets = registerAllTargets;
    }

    public void setEnableAspectj(boolean enableAspectj) {
        this.enableAspectj = enableAspectj;
    }

    public void setEnableAllTargets(boolean enableAllTargets) {
        this.enableAllTargets = enableAllTargets;
    }

    public void setTargetNames(String targetNames) {
        this.targetNames = targetNames;
    }

    public void setPrimaryName(String primaryName) {
        this.primaryName = primaryName;
    }

    public void setPrimary(TargetDataSourceProperties primary) {
        this.primary = primary;
    }

    public void setTargets(Map<String, TargetDataSourceProperties> targets) {
        this.targets = targets;
    }

    public void setEnableTransactionDelegate(boolean enableTransactionDelegate) {
        this.enableTransactionDelegate = enableTransactionDelegate;
    }

    public String toString() {
        return "DynamicDataSourceProperties(enabled=" + this.enabled + ", multiple=" + this.multiple + ", beanName=" + this.beanName + ", registerPrimary=" + this.registerPrimary + ", registerAllTargets=" + this.registerAllTargets + ", enableAspectj=" + this.enableAspectj + ", enableAllTargets=" + this.enableAllTargets + ", targetNames=" + this.targetNames + ", primaryName=" + this.primaryName + ", primary=" + this.primary + ", targets=" + this.targets + ", enableTransactionDelegate=" + this.enableTransactionDelegate + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicDataSourceProperties)) {
            return false;
        }
        DynamicDataSourceProperties other = (DynamicDataSourceProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.multiple != other.multiple) {
            return false;
        }
        if (this.registerPrimary != other.registerPrimary) {
            return false;
        }
        if (this.registerAllTargets != other.registerAllTargets) {
            return false;
        }
        if (this.enableAspectj != other.enableAspectj) {
            return false;
        }
        if (this.enableAllTargets != other.enableAllTargets) {
            return false;
        }
        if (this.enableTransactionDelegate != other.enableTransactionDelegate) {
            return false;
        }
        String this$beanName = this.beanName;
        String other$beanName = other.beanName;
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        String this$targetNames = this.targetNames;
        String other$targetNames = other.targetNames;
        if (this$targetNames == null ? other$targetNames != null : !this$targetNames.equals(other$targetNames)) {
            return false;
        }
        String this$primaryName = this.primaryName;
        String other$primaryName = other.primaryName;
        if (this$primaryName == null ? other$primaryName != null : !this$primaryName.equals(other$primaryName)) {
            return false;
        }
        TargetDataSourceProperties this$primary = this.primary;
        TargetDataSourceProperties other$primary = other.primary;
        if (this$primary == null ? other$primary != null : !((Object)this$primary).equals(other$primary)) {
            return false;
        }
        Map<String, TargetDataSourceProperties> this$targets = this.targets;
        Map<String, TargetDataSourceProperties> other$targets = other.targets;
        return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicDataSourceProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.multiple ? 79 : 97);
        result = result * 59 + (this.registerPrimary ? 79 : 97);
        result = result * 59 + (this.registerAllTargets ? 79 : 97);
        result = result * 59 + (this.enableAspectj ? 79 : 97);
        result = result * 59 + (this.enableAllTargets ? 79 : 97);
        result = result * 59 + (this.enableTransactionDelegate ? 79 : 97);
        String $beanName = this.beanName;
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        String $targetNames = this.targetNames;
        result = result * 59 + ($targetNames == null ? 43 : $targetNames.hashCode());
        String $primaryName = this.primaryName;
        result = result * 59 + ($primaryName == null ? 43 : $primaryName.hashCode());
        TargetDataSourceProperties $primary = this.primary;
        result = result * 59 + ($primary == null ? 43 : ((Object)$primary).hashCode());
        Map<String, TargetDataSourceProperties> $targets = this.targets;
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        return result;
    }
}

