/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import io.polaris.framework.toolkit.jdbc.TargetDataSource;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicDataSourceMethodInterceptor
implements MethodInterceptor,
Ordered {
    private String dataSourceKey;

    public DynamicDataSourceMethodInterceptor() {
    }

    public DynamicDataSourceMethodInterceptor(String dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
    }

    public int getOrder() {
        return -128;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.dataSourceKey != null) {
            return DynamicDataSourceKeys.doInterceptor(this.dataSourceKey, () -> ((MethodInvocation)invocation).proceed());
        }
        Method method = invocation.getMethod();
        TargetDataSource targetDataSource = (TargetDataSource)AnnotationUtils.findAnnotation((Method)method, TargetDataSource.class);
        if (targetDataSource == null) {
            targetDataSource = (TargetDataSource)AnnotationUtils.findAnnotation(invocation.getThis().getClass(), TargetDataSource.class);
        }
        if (targetDataSource == null) {
            return invocation.proceed();
        }
        return DynamicDataSourceKeys.doInterceptor(targetDataSource.value(), () -> ((MethodInvocation)invocation).proceed());
    }
}

