/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.core.string.Strings;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicDataSourceKeys {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceKeys.class);
    private static final ThreadLocal<Optional<String>> CURRENT = new ThreadLocal();
    private static final ThreadLocal<Deque<Optional<String>>> HISTORY = new ThreadLocal();
    private static Set<String> KEYS = new ConcurrentSkipListSet<String>();
    private static String defaultKey = null;

    public static String get() {
        return DynamicDataSourceKeys.getOrDefault(defaultKey);
    }

    public static String getOrDefault(String defaultKey) {
        Optional<String> current = CURRENT.get();
        return current != null && current.isPresent() ? current.get() : defaultKey;
    }

    public static boolean set(String key) {
        Optional<String> current = CURRENT.get();
        if (current == null) {
            CURRENT.set(Optional.ofNullable(key));
            return true;
        }
        if (!Objects.equals(current.orElse(null), key)) {
            CURRENT.set(Optional.ofNullable(key));
            Deque<Optional<String>> history = HISTORY.get();
            if (history == null) {
                history = new ArrayDeque<Optional<String>>();
                HISTORY.set(history);
            }
            history.offerLast(current);
            return true;
        }
        return false;
    }

    public static void clear() {
        Deque<Optional<String>> history = HISTORY.get();
        if (history != null) {
            Optional<String> last = history.pollLast();
            CURRENT.set(last);
            if (history.isEmpty()) {
                HISTORY.remove();
            }
        } else {
            CURRENT.remove();
        }
    }

    static void setDefaultKey(String defaultKey) {
        DynamicDataSourceKeys.defaultKey = defaultKey;
    }

    static void setKeys(Set<String> keys) {
        KEYS = keys;
    }

    static void add(String key) {
        KEYS.add(key);
    }

    public static boolean contains(String key) {
        return KEYS.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doInterceptor(String targetKey, Invokable interceptorCall) throws Throwable {
        boolean binded = false;
        String key = Strings.isNotBlank((CharSequence)targetKey) ? targetKey : null;
        try {
            if (key != null && !DynamicDataSourceKeys.contains(key)) {
                log.error("\u6570\u636e\u6e90[{}]\u4e0d\u5b58\u5728\uff0c\u4f7f\u7528\u9ed8\u8ba4\u6570\u636e\u6e90!", (Object)key);
                key = null;
            }
            if ((binded = DynamicDataSourceKeys.set(key)) && log.isDebugEnabled()) {
                log.debug("\u4f7f\u7528\u6570\u636e\u6e90\uff1a{}", (Object)Objects.toString(key, "{default}"));
            }
            Object object = interceptorCall.invoke();
            return object;
        }
        finally {
            if (binded) {
                DynamicDataSourceKeys.clear();
                if (log.isDebugEnabled()) {
                    log.debug("\u505c\u7528\u6570\u636e\u6e90\uff1a{}", (Object)Objects.toString(key, "{default}"));
                }
            }
        }
    }

    public static interface Invokable {
        public Object invoke() throws Throwable;
    }
}

