/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.DynamicDataSource;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceProperties;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;

public class DynamicDataSourceFactory
implements FactoryBean<DataSource> {
    private final DynamicDataSourceProperties properties;
    private final Map<String, DataSource> multiDataSources;
    private final Map<String, TargetDataSourceProperties> multiProperties;
    private final String defaultKey;
    private DataSource dataSource;

    public DynamicDataSourceFactory(DynamicDataSourceProperties properties, String defaultKey, Map<String, TargetDataSourceProperties> multiProperties, Map<String, DataSource> multiDataSources) {
        this.properties = properties;
        this.multiDataSources = multiDataSources;
        this.multiProperties = multiProperties;
        this.defaultKey = defaultKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getObject() throws Exception {
        DynamicDataSourceProperties dynamicDataSourceProperties = this.properties;
        synchronized (dynamicDataSourceProperties) {
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.dataSource = this.getDynamicDataSource();
            if (this.properties.isEnableTransactionDelegate()) {
                this.dataSource = new TransactionAwareDataSourceProxy(this.dataSource);
            }
            return this.dataSource;
        }
    }

    private DynamicDataSource getDynamicDataSource() {
        DynamicDataSource dynamicDataSource = new DynamicDataSource(this.multiDataSources, this.defaultKey, this.multiProperties);
        dynamicDataSource.afterPropertiesSet();
        return dynamicDataSource;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

