/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.core.lang.copier.Copiers;
import io.polaris.core.lang.copier.CopyOptions;
import io.polaris.core.string.Strings;
import io.polaris.framework.core.context.base.Binders;
import io.polaris.framework.core.context.bean.BeanUtils;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public class DynamicDataSourceBuilder {
    private static final String[] DATA_SOURCE_TYPE_NAMES = new String[]{"com.zaxxer.hikari.HikariDataSource", "org.apache.tomcat.jdbc.pool.DataSource", "org.apache.commons.dbcp2.BasicDataSource"};
    private Class<? extends DataSource> type;
    private String poolName;
    private ClassLoader classLoader;
    private Map<String, String> properties = new HashMap<String, String>();
    private TargetDataSourceProperties targetProperties;
    private DataSourceProperties baseProperties;
    private Consumer<DataSource> postProcessor = null;

    public static DynamicDataSourceBuilder create() {
        return new DynamicDataSourceBuilder(null);
    }

    public static DynamicDataSourceBuilder create(ClassLoader classLoader) {
        return new DynamicDataSourceBuilder(classLoader);
    }

    private DynamicDataSourceBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private EmbeddedDatabase buildEmbeddedDatabase() {
        EmbeddedDatabaseType embeddedDatabaseType = EmbeddedDatabaseConnection.get((ClassLoader)this.classLoader).getType();
        EmbeddedDatabaseBuilder builder = new EmbeddedDatabaseBuilder().setType(embeddedDatabaseType);
        if (this.baseProperties != null) {
            builder.setName(this.baseProperties.determineDatabaseName());
            if (this.baseProperties.getSqlScriptEncoding() != null) {
                builder.setScriptEncoding(this.baseProperties.getSqlScriptEncoding().name());
            }
            if (!CollectionUtils.isEmpty((Collection)this.baseProperties.getSchema())) {
                for (String script : this.baseProperties.getSchema()) {
                    builder.addScript(script);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)this.baseProperties.getData())) {
                for (String script : this.baseProperties.getData()) {
                    builder.addScript(script);
                }
            }
        } else {
            builder.setName("testdb");
        }
        EmbeddedDatabase embeddedDatabase = builder.build();
        if (this.targetProperties != null && !CollectionUtils.isEmpty(this.targetProperties.getExt())) {
            Binders.bind(this.targetProperties.getExt(), (Object)embeddedDatabase, (String)"", null);
        }
        if (this.baseProperties != null) {
            Copiers.fastCopyBeanToBean((Object)this.baseProperties, (Object)embeddedDatabase, (CopyOptions)CopyOptions.create().ignoreNull(true));
        }
        return embeddedDatabase;
    }

    public DataSource build() {
        Class<? extends DataSource> type = this.determineType();
        if (type == EmbeddedDatabase.class) {
            return this.buildEmbeddedDatabase();
        }
        DataSource result = (DataSource)BeanUtils.instantiateClass(type);
        this.maybeGetDriverClassName();
        this.maybeGetExtProperties(type);
        this.bind(result);
        return result;
    }

    public Class<? extends DataSource> determineType() {
        Class<? extends DataSource> type = this.type;
        if (type == null) {
            Class<? extends DataSource> foundType = DynamicDataSourceBuilder.findType(this.classLoader);
            EmbeddedDatabaseType embeddedDatabaseType = EmbeddedDatabaseConnection.get((ClassLoader)this.classLoader).getType();
            if (embeddedDatabaseType != null && !Strings.isNotBlank((CharSequence)this.properties.get("url")) && foundType == null) {
                return EmbeddedDatabase.class;
            }
            type = foundType;
        }
        if (type != null) {
            return type;
        }
        throw new IllegalStateException("\u672a\u77e5\u6570\u636e\u6e90\u7c7b\u578b");
    }

    private void maybeGetExtProperties(Class<? extends DataSource> type) {
        if ("com.zaxxer.hikari.HikariDataSource".equals(type.getName())) {
            if (this.targetProperties != null) {
                this.ext(this.targetProperties.getHikari());
            }
            if (Strings.isNotBlank((CharSequence)this.poolName)) {
                this.postProcessor = ds -> ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod((Class)type, (String)"setPoolName", (Class[])new Class[]{String.class}), (Object)ds, (Object[])new Object[]{this.poolName});
            }
        } else if ("com.alibaba.druid.pool.DruidDataSource".equals(type.getName())) {
            if (this.targetProperties != null) {
                this.ext(this.targetProperties.getDruid());
            }
        } else if ("org.apache.commons.dbcp2.BasicDataSource".equals(type.getName())) {
            String url = this.properties.get("url");
            DatabaseDriver databaseDriver = DatabaseDriver.fromJdbcUrl((String)url);
            String validationQuery = databaseDriver.getValidationQuery();
            if (validationQuery != null) {
                this.postProcessor = ds -> {
                    ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod((Class)type, (String)"setTestOnBorrow", (Class[])new Class[]{Boolean.TYPE}), (Object)ds, (Object[])new Object[]{true});
                    ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod((Class)type, (String)"setValidationQuery", (Class[])new Class[]{String.class}), (Object)ds, (Object[])new Object[]{validationQuery});
                };
            }
        } else if ("org.apache.tomcat.jdbc.pool.DataSource".equals(type.getName())) {
            // empty if block
        }
    }

    private void maybeGetDriverClassName() {
        if (!this.properties.containsKey("driverClassName") && this.properties.containsKey("url")) {
            String url = this.properties.get("url");
            String driverClass = DatabaseDriver.fromJdbcUrl((String)url).getDriverClassName();
            this.properties.put("driverClassName", driverClass);
        }
    }

    private void bind(DataSource result) {
        if (this.properties != null) {
            HashMap<String, List<String>> aliasMap = new HashMap<String, List<String>>();
            aliasMap.put("driver-class-name", Arrays.asList("driver-class"));
            aliasMap.put("url", Arrays.asList("jdbc-url"));
            aliasMap.put("username", Arrays.asList("user"));
            Binders.bind(this.properties, (Object)result, (String)"", aliasMap);
        }
        if (this.baseProperties != null) {
            Copiers.fastCopyBeanToBean((Object)this.baseProperties, (Object)result, (CopyOptions)CopyOptions.create().ignoreNull(true));
        }
        if (this.postProcessor != null) {
            this.postProcessor.accept(result);
        }
    }

    public DynamicDataSourceBuilder properties(TargetDataSourceProperties properties) {
        if (properties != null) {
            this.targetProperties = properties;
            DataSourceProperties dataSourceProperties = properties.getProperties();
            if (dataSourceProperties == null) {
                dataSourceProperties = properties.asDataSourceProperties();
            }
            this.ext(properties.getExt());
            this.properties(dataSourceProperties);
        }
        return this;
    }

    private DynamicDataSourceBuilder ext(Object ... ext) {
        if (ext != null) {
            HashMap properties = new HashMap();
            for (Object prop : ext) {
                if (prop == null) continue;
                Binders.toProperties((Object)prop, properties, (String)"");
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (this.properties.containsKey(entry.getKey())) continue;
                this.properties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return this;
    }

    public DynamicDataSourceBuilder properties(DataSourceProperties properties) {
        if (properties != null) {
            this.baseProperties = properties;
            this.type(properties.getType()).poolName(properties.getName()).driverClassName(properties.determineDriverClassName()).url(properties.determineUrl()).username(properties.determineUsername()).password(properties.determinePassword());
        }
        return this;
    }

    public DynamicDataSourceBuilder properties(Map<String, String> properties) {
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public DynamicDataSourceBuilder type(Class<? extends DataSource> type) {
        this.type = type;
        return this;
    }

    public DynamicDataSourceBuilder poolName(String name) {
        this.poolName = name;
        return this;
    }

    public DynamicDataSourceBuilder url(String url) {
        this.properties.put("url", url);
        return this;
    }

    public DynamicDataSourceBuilder driverClassName(String driverClassName) {
        this.properties.put("driverClassName", driverClassName);
        return this;
    }

    public DynamicDataSourceBuilder username(String username) {
        this.properties.put("username", username);
        return this;
    }

    public DynamicDataSourceBuilder password(String password) {
        this.properties.put("password", password);
        return this;
    }

    public static Class<? extends DataSource> findType(ClassLoader classLoader) {
        for (String name : DATA_SOURCE_TYPE_NAMES) {
            try {
                return ClassUtils.forName((String)name, (ClassLoader)classLoader);
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

