/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import io.polaris.framework.toolkit.jdbc.TargetDataSource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-128)
public class DynamicDataSourceAspect {
    private static final Logger log = LoggerFactory.getLogger(DynamicDataSourceAspect.class);

    @Around(value="@within(ds) || @annotation(ds)")
    public Object bindDynamicKey(ProceedingJoinPoint point, TargetDataSource ds) throws Throwable {
        if (ds != null) {
            return DynamicDataSourceKeys.doInterceptor(ds.value(), () -> ((ProceedingJoinPoint)point).proceed());
        }
        return point.proceed();
    }
}

