/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.jdbc;

import io.polaris.core.tuple.Tuple2;
import io.polaris.framework.toolkit.jdbc.DynamicDataSourceKeys;
import io.polaris.framework.toolkit.jdbc.properties.TargetDataSourceProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.InfrastructureProxy;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource
implements InfrastructureProxy {
    private final String defaultKey;
    private final Map<Object, Object> targetDataSources;
    private final Map<String, TargetDataSourceProperties> targetProperties;
    private final Map<String, Tuple2<DataSource, DataSourceProperties>> dataSourceProperties;

    public DynamicDataSource(Map<String, DataSource> multiDataSources, String defaultKey, Map<String, TargetDataSourceProperties> multiProperties) {
        HashMap dataSourceProperties = new HashMap();
        HashMap targetDataSources = new HashMap();
        HashSet<String> keys = new HashSet<String>();
        if (defaultKey != null) {
            keys.add(defaultKey);
        }
        multiDataSources.forEach((k, v) -> {
            targetDataSources.put(k, v);
            keys.add((String)k);
            TargetDataSourceProperties targetProperties = (TargetDataSourceProperties)multiProperties.get(k);
            DataSourceProperties dsProperties = targetProperties.getProperties();
            if (dsProperties == null) {
                dsProperties = targetProperties.asDataSourceProperties();
            }
            dataSourceProperties.put(k, Tuple2.of((Object)v, (Object)dsProperties));
        });
        DynamicDataSourceKeys.setDefaultKey(defaultKey);
        DynamicDataSourceKeys.setKeys(Collections.unmodifiableSet(keys));
        this.setTargetDataSources(targetDataSources);
        this.setDefaultTargetDataSource(defaultKey);
        this.defaultKey = defaultKey;
        this.targetDataSources = Collections.unmodifiableMap(targetDataSources);
        this.targetProperties = Collections.unmodifiableMap(multiProperties);
        this.dataSourceProperties = Collections.unmodifiableMap(dataSourceProperties);
    }

    protected DataSource resolveSpecifiedDataSource(Object dataSource) throws IllegalArgumentException {
        if (dataSource instanceof DataSource) {
            return (DataSource)dataSource;
        }
        if (dataSource instanceof String) {
            return (DataSource)this.targetDataSources.get(dataSource);
        }
        throw new IllegalArgumentException("Illegal data source value - only [javax.sql.DataSource] and String supported: " + dataSource);
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSourceKeys.get();
    }

    public Object getWrappedObject() {
        return this.determineTargetDataSource();
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public Map<Object, Object> getTargetDataSources() {
        return this.targetDataSources;
    }

    public Map<String, TargetDataSourceProperties> getTargetProperties() {
        return this.targetProperties;
    }

    public Map<String, Tuple2<DataSource, DataSourceProperties>> getDataSourceProperties() {
        return this.dataSourceProperties;
    }
}

