/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.repository;

import io.polaris.core.collection.Iterables;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.jdbc.sql.statement.expression.Expression;
import io.polaris.core.jdbc.sql.statement.expression.Expressions;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobShardingStatusCountVo;
import io.polaris.framework.toolkit.elasticjob.entity.JobShardingStatusEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobShardingStatusEntitySql;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import io.polaris.framework.toolkit.elasticjob.repository.BaseRepository;
import io.polaris.framework.toolkit.elasticjob.repository.JobShardingStatusRepository;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbJobShardingStatusRepository
extends BaseRepository
implements JobShardingStatusRepository {
    private static final Logger log = LoggerFactory.getLogger(RdbJobShardingStatusRepository.class);
    private final boolean existsTableJobShardingStatus = this.existsTable("CRM_JOB_SHARDING_STATUS");

    public RdbJobShardingStatusRepository(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public boolean isInitializedAllShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Boolean)this.doWithConnection(conn -> {
            log.info("\u67e5\u8be2\u4f5c\u4e1a\u5404\u5206\u7247\u72b6\u6001\u662f\u5426\u5168\u90e8\u521d\u59cb\u5316.profile={},sysId={},jobName={},shardingTotalCount={}", new Object[]{profile, sysId, jobName, shardingTotalCount});
            PreparedSql sql1 = ((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.SelectCol)JobShardingStatusEntitySql.select().select().id().count()).end()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).end()).toSqlNode().asPreparedSql();
            PreparedSql sql2 = ((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.SelectCol)JobShardingStatusEntitySql.select().select().id().count()).end()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).end()).toSqlNode().asPreparedSql();
            Integer count1 = (Integer)Jdbcs.queryForObject((Connection)conn, (String)sql1.getText(), (Iterable)sql1.getBindings(), Integer.TYPE);
            Integer count2 = (Integer)Jdbcs.queryForObject((Connection)conn, (String)sql2.getText(), (Iterable)sql2.getBindings(), Integer.TYPE);
            return count1 == shardingTotalCount && count2 == shardingTotalCount;
        });
    }

    @Override
    public boolean isInitializedShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Boolean)this.doWithConnection(conn -> {
            log.info("\u67e5\u8be2\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u662f\u5426\u521d\u59cb\u5316.profile={},sysId={},jobName={},shardingItem={},shardingTotalCount={}", new Object[]{profile, sysId, jobName, shardingItem, shardingTotalCount});
            PreparedSql sql = ((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.Select)JobShardingStatusEntitySql.select().selectAll()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode().asPreparedSql();
            JobShardingStatusEntity entity = (JobShardingStatusEntity)Jdbcs.queryForObject((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings(), JobShardingStatusEntity.class);
            return entity != null;
        });
    }

    @Override
    public JobShardingStatusEntity getJobShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (JobShardingStatusEntity)this.doWithConnection(conn -> {
            log.info("\u67e5\u8be2\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},shardingItem={},shardingTotalCount={}", new Object[]{profile, sysId, jobName, shardingItem, shardingTotalCount});
            PreparedSql sql = ((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.Select)JobShardingStatusEntitySql.select().selectAll()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode().asPreparedSql();
            JobShardingStatusEntity entity = (JobShardingStatusEntity)Jdbcs.queryForObject((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings(), JobShardingStatusEntity.class);
            log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)entity);
            return entity;
        });
    }

    @Override
    public List<JobShardingStatusEntity> getAllShardingStatus(String profile, String sysId, String jobName, JobState ... states) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (List)this.doWithConnection(conn -> {
            List jobStateList = Iterables.asList((Object[])states);
            log.info("\u67e5\u8be2\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},states={}", new Object[]{profile, sysId, jobName, jobStateList});
            PreparedSql sql = ((JobShardingStatusEntitySql.Select)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.Select)JobShardingStatusEntitySql.select().selectAll()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).jobState().in((Collection)jobStateList, !jobStateList.isEmpty())).end()).toSqlNode().asPreparedSql();
            List list = Jdbcs.queryForList((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings(), JobShardingStatusEntity.class);
            log.info("\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)list);
            return list;
        });
    }

    @Override
    public int doInitializeAllShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u6e05\u7406\u5386\u53f2\u72b6\u6001\u4fe1\u606f.profile={},sysId={},jobName={},shardingTotalCount={}", new Object[]{profile, sysId, jobName, shardingTotalCount});
                Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Delete)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.delete().where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).end()).toSqlNode());
                log.info("\u6dfb\u52a0\u72b6\u6001\u8bb0\u5f55\u4fe1\u606f.profile={},sysId={},jobName={},shardingTotalCount={}", new Object[]{profile, sysId, jobName, shardingTotalCount});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                JobShardingStatusEntity entity = new JobShardingStatusEntity();
                entity.setProfile(profile);
                entity.setSysId(sysId);
                entity.setJobName(jobName);
                entity.setShardingTotalCount(shardingTotalCount);
                entity.setJobState(JobState.INITIAL);
                entity.setDeleted(false);
                entity.setCrtDt(now);
                entity.setUptDt(now);
                for (int i = 0; i < shardingTotalCount; ++i) {
                    entity.setId(UUID.randomUUID().toString().replace("-", ""));
                    entity.setShardingItem(i);
                    Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Insert)JobShardingStatusEntitySql.insert().withEntity(entity)).toSqlNode());
                }
                rows[0] = shardingTotalCount;
            });
            return rows[0];
        });
    }

    @Override
    public int doInitializeShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u6e05\u7406\u5386\u53f2\u72b6\u6001\u4fe1\u606f.profile={},sysId={},jobName={},shardingTotalCount={},shardingItem={}", new Object[]{profile, sysId, jobName, shardingTotalCount, shardingItem});
                Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Delete)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.delete().where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode());
                log.info("\u6dfb\u52a0\u72b6\u6001\u8bb0\u5f55\u4fe1\u606f.profile={},sysId={},jobName={},shardingTotalCount={},shardingItem={}", new Object[]{profile, sysId, jobName, shardingTotalCount, shardingItem});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                JobShardingStatusEntity entity = new JobShardingStatusEntity();
                entity.setProfile(profile);
                entity.setSysId(sysId);
                entity.setJobName(jobName);
                entity.setShardingTotalCount(shardingTotalCount);
                entity.setJobState(JobState.INITIAL);
                entity.setDeleted(false);
                entity.setCrtDt(now);
                entity.setUptDt(now);
                entity.setId(UUID.randomUUID().toString().replace("-", ""));
                entity.setShardingItem(shardingItem);
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Insert)JobShardingStatusEntitySql.insert().withEntity(entity)).toSqlNode());
            });
            return rows[0];
        });
    }

    @Override
    public int doBeginAllShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount, String message) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},message={}", new Object[]{profile, sysId, jobName, message});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Update)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.update().jobState((Object)JobState.RUNNING).beginTime(now).message(message != null && message.length() > 500 ? message.substring(0, 500) : message).stackTrace("").uptDt(now).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).end()).toSqlNode());
            });
            return rows[0];
        });
    }

    @Override
    public int doBeginShardingStatus(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem, String message) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},shardingItem={},message={}", new Object[]{profile, sysId, jobName, shardingItem, message});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Update)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.update().jobState((Object)JobState.RUNNING).beginTime(now).message(message != null && message.length() > 500 ? message.substring(0, 500) : message).stackTrace("").uptDt(now).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode());
            });
            return rows[0];
        });
    }

    @Override
    public int doFinishShardingStatusSuccess(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem, String message) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},shardingItem={},message={}", new Object[]{profile, sysId, jobName, shardingItem, message});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Update)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.update().jobState((Object)JobState.SUCCESS).endTime(now).message(message != null && message.length() > 500 ? message.substring(0, 500) : message).stackTrace("").uptDt(now).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode());
            });
            return rows[0];
        });
    }

    @Override
    public int doFinishShardingStatusError(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem, String message, String stackTrace) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},shardingItem={},message={}", new Object[]{profile, sysId, jobName, shardingItem, message});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)((JobShardingStatusEntitySql.Update)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.update().jobState((Object)JobState.ERROR).endTime(now).message(message != null && message.length() > 500 ? message.substring(0, 500) : message).stackTrace(stackTrace != null && stackTrace.length() > 2000 ? stackTrace.substring(0, 2000) : stackTrace).uptDt(now).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode());
            });
            return rows[0];
        });
    }

    @Override
    public int doUpdateShardingDealCount(String profile, String sysId, String jobName, int shardingTotalCount, int shardingItem, JobShardingStatusCountVo statusCount) {
        if (!this.existsTableJobShardingStatus) {
            throw new JobException("\u4f5c\u4e1a\u5206\u7247\u72b6\u6001\u8868\u4e0d\u5b58\u5728");
        }
        return (Integer)this.doWithConnection(conn -> {
            int[] rows = new int[]{0};
            this.doRetryWithTransaction((Connection)conn, () -> {
                log.info("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001.profile={},sysId={},jobName={},shardingItem={},statusCount={}", new Object[]{profile, sysId, jobName, shardingItem, statusCount});
                Timestamp now = new Timestamp(System.currentTimeMillis());
                JobShardingStatusEntitySql.Update update = (JobShardingStatusEntitySql.Update)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)((JobShardingStatusEntitySql.And)JobShardingStatusEntitySql.update().uptDt(now).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingTotalCount().eq((Object)shardingTotalCount)).shardingItem().eq((Object)shardingItem)).end();
                if (statusCount.getDealCount() != null) {
                    update.dealCount(statusCount.getDealCount().intValue());
                } else if (statusCount.getDealCountInc() != null) {
                    update.dealCount().apply((Expression)Expressions.pattern((String)"${ref} + #{0}"), new Object[]{statusCount.getDealCountInc().intValue()});
                }
                if (statusCount.getSuccessCount() != null) {
                    update.successCount(statusCount.getSuccessCount().intValue());
                } else if (statusCount.getSuccessCountInc() != null) {
                    update.successCount().apply((Expression)Expressions.pattern((String)"${ref} + #{0}"), new Object[]{statusCount.getSuccessCountInc().intValue()});
                }
                if (statusCount.getErrorCount() != null) {
                    update.errorCount(statusCount.getErrorCount().intValue());
                } else if (statusCount.getErrorCountInc() != null) {
                    update.errorCount().apply((Expression)Expressions.pattern((String)"${ref} + #{0}"), new Object[]{statusCount.getErrorCountInc().intValue()});
                }
                rows[0] = Jdbcs.update((Connection)conn, (SqlNode)update.toSqlNode());
            });
            return rows[0];
        });
    }
}

