/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.repository;

import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import io.polaris.core.function.ExecutableWithArgs1;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.jdbc.sql.PreparedSql;
import io.polaris.core.jdbc.sql.node.SqlNode;
import io.polaris.core.os.OS;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntitySql;
import io.polaris.framework.toolkit.elasticjob.entity.JobShardingRuntimeEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobShardingRuntimeEntitySql;
import io.polaris.framework.toolkit.elasticjob.repository.BaseRepository;
import io.polaris.framework.toolkit.elasticjob.repository.JobRuntimeRepository;
import java.sql.Connection;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbJobRuntimeRepository
extends BaseRepository
implements JobRuntimeRepository {
    private static final Logger log = LoggerFactory.getLogger(RdbJobRuntimeRepository.class);
    private final boolean existsTableJobRuntime = this.existsTable("CRM_JOB_RUNTIME");
    private final boolean existsTableJobShardingRuntime = this.existsTable("CRM_JOB_SHARDING_RUNTIME");

    public RdbJobRuntimeRepository(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public void deleteJobRuntimeExcept(String profile, String sysId, Set<String> keptProcessUids) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            log.debug("\u67e5\u8be2\u5f53\u524d\u4f5c\u4e1a\u8fd0\u884c\u7ec8\u7aef\u4fe1\u606f.profile={},sysId={}", (Object)profile, (Object)sysId);
            PreparedSql sql = ((JobRuntimeEntitySql.Select)((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.Select)JobRuntimeEntitySql.select().distinct()).vmProcessUid().where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).end()).toSqlNode().asPreparedSql();
            List list = Jdbcs.queryForList((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings(), JobRuntimeEntity.class);
            Set toRemoved = list.stream().filter(o -> Strings.isNotBlank((String)o.getVmProcessUid())).map(JobRuntimeEntity::getVmProcessUid).collect(Collectors.toSet());
            toRemoved.removeAll(keptProcessUids);
            if (toRemoved.isEmpty()) {
                return;
            }
            this.doTransaction((Connection)conn, () -> {
                log.info("\u5220\u9664\u6307\u5b9a\u7ec8\u7aef\u7684\u4f5c\u4e1a\u8fd0\u884c\u4fe1\u606f: {}", (Object)toRemoved);
                Jdbcs.update((Connection)conn, (SqlNode)((JobRuntimeEntitySql.Delete)((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.And)JobRuntimeEntitySql.delete().where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).vmProcessUid().in((Collection)toRemoved)).end()).toSqlNode());
                log.info("\u5220\u9664\u6307\u5b9a\u7ec8\u7aef\u7684\u4f5c\u4e1a\u5206\u7247\u4fe1\u606f: {}", (Object)toRemoved);
                Jdbcs.update((Connection)conn, (SqlNode)((JobShardingRuntimeEntitySql.Delete)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.And)JobShardingRuntimeEntitySql.delete().where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).vmProcessUid().in((Collection)toRemoved)).end()).toSqlNode());
            });
        }));
    }

    @Override
    public void insertJobRuntimeList(Collection<JobRuntimeEntity> jobRuntimeList) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> this.doTransaction((Connection)conn, () -> {
            for (JobRuntimeEntity jobRuntimeEntity : jobRuntimeList) {
                SqlNode sql = ((JobRuntimeEntitySql.Insert)JobRuntimeEntitySql.insert().withEntity(jobRuntimeEntity)).toSqlNode();
                log.info("\u63d2\u5165\u4f5c\u4e1a\u8fd0\u884c\u4fe1\u606f: {}", (Object)jobRuntimeEntity.getJobName());
                Jdbcs.update((Connection)conn, (SqlNode)sql);
            }
        })));
    }

    @Override
    public JobRuntimeEntity getJobRuntime(String id) {
        if (!this.existsTableJobRuntime) {
            return null;
        }
        return (JobRuntimeEntity)this.doWithConnection(conn -> {
            PreparedSql sql = ((JobRuntimeEntitySql.Select)((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.Select)JobRuntimeEntitySql.select().selectAll()).where().id().eq((Object)id)).end()).toSqlNode().asPreparedSql();
            JobRuntimeEntity entity = (JobRuntimeEntity)Jdbcs.queryForObject((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings(), JobRuntimeEntity.class);
            return entity;
        });
    }

    @Override
    public void updateJobRuntime(JobRuntimeEntity jobRuntime) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            PreparedSql sql = ((JobRuntimeEntitySql.And)((JobRuntimeEntitySql.Update)JobRuntimeEntitySql.update().withEntity(jobRuntime)).where().byEntityId((Object)jobRuntime)).toSqlNode().asPreparedSql();
            this.doRetryWithTransaction((Connection)conn, () -> Jdbcs.update((Connection)conn, (String)sql.getText(), (Iterable)sql.getBindings()));
        }));
    }

    @Override
    public void saveJobShardingRuntime(String profile, String sysId, String vmProcessUid, JobExecutionEvent executionEvent) {
        if (!this.existsTableJobShardingRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            String message;
            String stackTrace;
            java.util.Date now = new java.util.Date();
            String jobName = executionEvent.getJobName();
            int shardingItem = executionEvent.getShardingItem();
            Date vmStartTime = new Date(OS.getVmStartTime());
            java.util.Date startTime = executionEvent.getStartTime();
            java.util.Date completeTime = executionEvent.getCompleteTime();
            String failureCause = executionEvent.getFailureCause();
            JobState jobState = null == executionEvent.getCompleteTime() ? JobState.RUNNING : (executionEvent.isSuccess() ? JobState.SUCCESS : JobState.ERROR);
            if (Strings.isNotBlank((String)failureCause)) {
                stackTrace = failureCause.length() < 2000 ? failureCause : failureCause.substring(0, 2000);
                message = failureCause.length() < 500 ? failureCause : failureCause.substring(0, 500);
            } else {
                stackTrace = null;
                message = null;
            }
            PreparedSql select = ((JobShardingRuntimeEntitySql.Select)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.Select)JobShardingRuntimeEntitySql.select().selectAll()).where().profile().eq((Object)profile)).sysId().eq((Object)sysId)).jobName().eq((Object)jobName)).shardingItem().eq((Object)shardingItem)).end()).toSqlNode().asPreparedSql();
            this.doRetryWithTransaction((Connection)conn, () -> {
                JobShardingRuntimeEntity entity = (JobShardingRuntimeEntity)Jdbcs.queryForObject((Connection)conn, (String)select.getText(), (Iterable)select.getBindings(), JobShardingRuntimeEntity.class);
                if (entity == null) {
                    entity = new JobShardingRuntimeEntity();
                    entity.setId(UUID.randomUUID().toString().replace("-", ""));
                    entity.setProfile(profile);
                    entity.setSysId(sysId);
                    entity.setVmProcessUid(vmProcessUid);
                    entity.setJobName(jobName);
                    entity.setShardingItem(shardingItem);
                    entity.setVmStartTime(vmStartTime);
                    entity.setJobState(jobState);
                    entity.setBeginTime(startTime);
                    entity.setEndTime(completeTime);
                    entity.setMessage(message);
                    entity.setStackTrace(stackTrace);
                    entity.setDeleted(false);
                    entity.setCrtDt(now);
                    entity.setUptDt(now);
                    Jdbcs.update((Connection)conn, (SqlNode)((JobShardingRuntimeEntitySql.Insert)JobShardingRuntimeEntitySql.insert().withEntity(entity)).toSqlNode());
                } else {
                    entity.setVmProcessUid(vmProcessUid);
                    entity.setJobState(jobState);
                    entity.setBeginTime(startTime);
                    entity.setEndTime(completeTime);
                    entity.setMessage(message);
                    entity.setStackTrace(stackTrace);
                    entity.setUptDt(now);
                    Jdbcs.update((Connection)conn, (SqlNode)((JobShardingRuntimeEntitySql.Update)((JobShardingRuntimeEntitySql.And)((JobShardingRuntimeEntitySql.Update)JobShardingRuntimeEntitySql.update().withEntity(entity)).where().byEntityId((Object)entity)).end()).toSqlNode());
                }
            });
        }));
    }

    @Override
    public void updateJobState(JobRuntimeEntity jobRuntime) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            log.debug("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001. {}", (Object)jobRuntime);
            this.doRetryWithTransaction((Connection)conn, () -> Jdbcs.update((Connection)conn, (SqlNode)((JobRuntimeEntitySql.Update)((JobRuntimeEntitySql.And)JobRuntimeEntitySql.update().jobState((Object)jobRuntime.getJobState()).message(jobRuntime.getMessage()).uptDt(new java.util.Date()).where().id().eq((Object)jobRuntime.getId())).end()).toSqlNode()));
        }));
    }

    @Override
    public void updateJobErrorState(JobRuntimeEntity jobRuntime) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            log.debug("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001. {}", (Object)jobRuntime);
            this.doRetryWithTransaction((Connection)conn, () -> Jdbcs.update((Connection)conn, (SqlNode)((JobRuntimeEntitySql.Update)((JobRuntimeEntitySql.And)JobRuntimeEntitySql.update().jobState((Object)jobRuntime.getJobState()).message(jobRuntime.getMessage()).stackTrace(jobRuntime.getStackTrace()).uptDt(new java.util.Date()).where().id().eq((Object)jobRuntime.getId())).end()).toSqlNode()));
        }));
    }

    @Override
    public void updateJobStateAndShardingItems(JobRuntimeEntity jobRuntime) {
        if (!this.existsTableJobRuntime) {
            return;
        }
        this.doWithConnection((ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            log.debug("\u66f4\u65b0\u4f5c\u4e1a\u72b6\u6001. {}", (Object)jobRuntime);
            this.doRetryWithTransaction((Connection)conn, () -> Jdbcs.update((Connection)conn, (SqlNode)((JobRuntimeEntitySql.Update)((JobRuntimeEntitySql.And)JobRuntimeEntitySql.update().jobState((Object)jobRuntime.getJobState()).message(jobRuntime.getMessage()).beginTime(jobRuntime.getBeginTime()).endTime(jobRuntime.getEndTime()).shardingItems(jobRuntime.getShardingItems()).uptDt(new java.util.Date()).where().id().eq((Object)jobRuntime.getId())).end()).toSqlNode()));
        }));
    }
}

