/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.repository;

import io.polaris.core.jdbc.Jdbcs;
import io.polaris.framework.toolkit.elasticjob.entity.JobCfgEntity;
import io.polaris.framework.toolkit.elasticjob.entity.JobEnvEntity;
import io.polaris.framework.toolkit.elasticjob.repository.BaseRepository;
import io.polaris.framework.toolkit.elasticjob.repository.InternalRdbRepository;
import io.polaris.framework.toolkit.elasticjob.repository.JobRepository;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbJobRepository
extends BaseRepository
implements JobRepository {
    private static final Logger log = LoggerFactory.getLogger(RdbJobRepository.class);
    private final InternalRdbRepository rdbRepository = (InternalRdbRepository)Jdbcs.createExecutor(InternalRdbRepository.class);
    private final boolean existsTableJobEnv = this.existsTable("CRM_JOB_ENV");
    private final boolean existsTableJobCfg = this.existsTable("CRM_JOB_CFG");

    public RdbJobRepository(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public JobEnvEntity getJobEnv(String profile, String sysId) {
        if (!this.existsTableJobEnv) {
            return null;
        }
        return (JobEnvEntity)this.doWithConnection(conn -> {
            log.debug("\u83b7\u53d6\u4f5c\u4e1a\u73af\u5883\u914d\u7f6e.profile={},sysId={}", (Object)profile, (Object)sysId);
            JobEnvEntity jobEnv = this.rdbRepository.getJobEnv((Connection)conn, profile, sysId);
            if (jobEnv == null && !"default".equals(profile)) {
                log.debug("\u83b7\u53d6\u4f5c\u4e1a\u73af\u5883\u914d\u7f6e.profile={},sysId={}", (Object)"default", (Object)sysId);
                jobEnv = this.rdbRepository.getJobEnv((Connection)conn, "default", sysId);
            }
            return jobEnv;
        });
    }

    @Override
    public List<JobCfgEntity> getAllJobInfoCfg(String profile, String sysId) {
        if (!this.existsTableJobCfg) {
            return Collections.emptyList();
        }
        return this.doWithConnection(conn -> {
            log.debug("\u67e5\u8be2\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f.profile={},sysId={}", (Object)profile, (Object)sysId);
            List<JobCfgEntity> list = this.rdbRepository.getAllJobCfg((Connection)conn, JobCfgEntity.builder().profile(profile).sysId(sysId).deleted(false).build());
            if (!"default".equals(profile)) {
                log.debug("\u67e5\u8be2\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f.profile={},sysId={}", (Object)"default", (Object)sysId);
                List<JobCfgEntity> additions = this.rdbRepository.getAllJobCfg((Connection)conn, JobCfgEntity.builder().profile("default").sysId(sysId).deleted(false).build());
                Set jobNames = list.stream().map(JobCfgEntity::getJobName).collect(Collectors.toSet());
                for (JobCfgEntity addition : additions) {
                    if (jobNames.contains(addition.getJobName())) continue;
                    list.add(addition);
                    jobNames.add(addition.getJobName());
                }
            }
            return list;
        }, Collections::emptyList);
    }

    @Override
    public JobCfgEntity getJobInfoCfg(String profile, String sysId, String jobName) {
        if (!this.existsTableJobCfg) {
            return null;
        }
        return (JobCfgEntity)this.doWithConnection(conn -> {
            log.debug("\u67e5\u8be2\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f.profile={},sysId={},jobName={}", new Object[]{profile, sysId, jobName});
            JobCfgEntity jobCfg = this.rdbRepository.getJobCfg((Connection)conn, profile, sysId, jobName);
            if (jobCfg == null && !"default".equals(profile)) {
                log.debug("\u67e5\u8be2\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f.profile={},sysId={},jobName={}", new Object[]{"default", sysId, jobName});
                jobCfg = this.rdbRepository.getJobCfg((Connection)conn, "default", sysId, jobName);
            }
            return jobCfg;
        });
    }
}

