/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.repository;

import io.polaris.core.annotation.Internal;
import io.polaris.core.function.CallableWithArgs1;
import io.polaris.core.function.Executable;
import io.polaris.core.function.ExecutableWithArgs1;
import io.polaris.core.jdbc.Jdbcs;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BaseRepository {
    private static final Logger log = LoggerFactory.getLogger(BaseRepository.class);
    public static final int RETRY = 10;
    public static final String PROFILE_DEFAULT = "default";
    protected final DataSource dataSource;

    public BaseRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected boolean existsTable(Connection conn, String tableName) throws SQLException {
        String catalog = conn.getCatalog();
        String schema = conn.getSchema();
        boolean exists = false;
        DatabaseMetaData dbMetaData = conn.getMetaData();
        try (ResultSet resultSet = dbMetaData.getTables(catalog, schema, tableName, new String[]{"TABLE"});){
            exists = resultSet.next();
        }
        return exists;
    }

    protected boolean existsTable(String tableName) {
        return Boolean.TRUE.equals(this.doWithConnection(conn -> this.existsTable((Connection)conn, tableName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWithConnection(ExecutableWithArgs1<Connection> consumer) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            consumer.execute((Object)conn);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Jdbcs.close((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V doWithConnection(CallableWithArgs1<V, Connection> consumer) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            Object object = consumer.call((Object)conn);
            return (V)object;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            V v = null;
            return v;
        }
        finally {
            Jdbcs.close((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V doWithConnection(CallableWithArgs1<V, Connection> consumer, Supplier<V> defaultSupplier) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            Object object = consumer.call((Object)conn);
            return (V)object;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            V v = defaultSupplier.get();
            return v;
        }
        finally {
            Jdbcs.close((Connection)conn);
        }
    }

    protected void doTransaction(Connection conn, Executable runnable) throws Exception {
        boolean autoCommit = conn.getAutoCommit();
        try {
            conn.setAutoCommit(false);
            runnable.execute();
            conn.commit();
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException ex) {
                log.error("", (Throwable)ex);
            }
            throw e;
        }
        finally {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (SQLException sQLException) {}
        }
    }

    protected void doRetryWithTransaction(Connection conn, Executable runnable) {
        this.doRetryWithTransaction(conn, runnable, 10);
    }

    protected void doRetryWithTransaction(Connection conn, Executable runnable, int retry) {
        for (int i = 0; i <= retry; ++i) {
            if (i > 0) {
                log.warn("\u4e8b\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c\u7b2c{}\u6b21\u91cd\u8bd5", (Object)i);
            }
            try {
                this.doTransaction(conn, runnable);
                break;
            }
            catch (Exception e) {
                if (i != retry) continue;
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
        }
    }
}

