/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.properties;

import io.polaris.framework.toolkit.elasticjob.properties.BasicProperties;
import io.polaris.framework.toolkit.elasticjob.properties.JobsProperties;
import io.polaris.framework.toolkit.elasticjob.properties.ZookeeperProperties;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="platform.elasticjob", ignoreUnknownFields=true)
public class ElasticJobProperties {
    private boolean enabled;
    private boolean enabledRdbEvent;
    @NestedConfigurationProperty
    private ZookeeperProperties zookeeper = new ZookeeperProperties();
    @NestedConfigurationProperty
    private JobsProperties jobs = new JobsProperties();
    @NestedConfigurationProperty
    private BasicProperties basic = new BasicProperties();

    @PostConstruct
    public void afterPropertiesSet() {
        this.jobs.getSimpleJobs().forEach((k, v) -> v.copyBasicProperties(this.basic));
        this.jobs.getDataflowJobs().forEach((k, v) -> v.copyBasicProperties(this.basic));
        this.jobs.getScriptJobs().forEach((k, v) -> v.copyBasicProperties(this.basic));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledRdbEvent() {
        return this.enabledRdbEvent;
    }

    public ZookeeperProperties getZookeeper() {
        return this.zookeeper;
    }

    public JobsProperties getJobs() {
        return this.jobs;
    }

    public BasicProperties getBasic() {
        return this.basic;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledRdbEvent(boolean enabledRdbEvent) {
        this.enabledRdbEvent = enabledRdbEvent;
    }

    public void setZookeeper(ZookeeperProperties zookeeper) {
        this.zookeeper = zookeeper;
    }

    public void setJobs(JobsProperties jobs) {
        this.jobs = jobs;
    }

    public void setBasic(BasicProperties basic) {
        this.basic = basic;
    }

    public String toString() {
        return "ElasticJobProperties(enabled=" + this.enabled + ", enabledRdbEvent=" + this.enabledRdbEvent + ", zookeeper=" + this.zookeeper + ", jobs=" + this.jobs + ", basic=" + this.basic + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticJobProperties)) {
            return false;
        }
        ElasticJobProperties other = (ElasticJobProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.enabledRdbEvent != other.enabledRdbEvent) {
            return false;
        }
        ZookeeperProperties this$zookeeper = this.zookeeper;
        ZookeeperProperties other$zookeeper = other.zookeeper;
        if (this$zookeeper == null ? other$zookeeper != null : !((Object)this$zookeeper).equals(other$zookeeper)) {
            return false;
        }
        JobsProperties this$jobs = this.jobs;
        JobsProperties other$jobs = other.jobs;
        if (this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs)) {
            return false;
        }
        BasicProperties this$basic = this.basic;
        BasicProperties other$basic = other.basic;
        return !(this$basic == null ? other$basic != null : !((Object)this$basic).equals(other$basic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticJobProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.enabled ? 79 : 97);
        result = result * 59 + (this.enabledRdbEvent ? 79 : 97);
        ZookeeperProperties $zookeeper = this.zookeeper;
        result = result * 59 + ($zookeeper == null ? 43 : ((Object)$zookeeper).hashCode());
        JobsProperties $jobs = this.jobs;
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        BasicProperties $basic = this.basic;
        result = result * 59 + ($basic == null ? 43 : ((Object)$basic).hashCode());
        return result;
    }
}

