/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.handler;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandler;
import com.dangdang.ddframe.job.util.concurrent.ExecutorServiceObject;
import io.polaris.framework.toolkit.elasticjob.context.JobCtx;
import io.polaris.framework.toolkit.elasticjob.context.JobCtxHolder;
import io.polaris.framework.toolkit.elasticjob.entity.JobRuntimeEntity;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicExecutorServiceHandler
implements ExecutorServiceHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicExecutorServiceHandler.class);
    public static final String EXECUTOR_POOL_SIZE = "executorPoolSize";

    public ExecutorService createExecutorService(String jobName) {
        JobRuntimeEntity jobRuntime;
        int threadPoolSize = 0;
        JobCtx jobCtx = JobCtxHolder.get();
        if (jobCtx != null && (jobRuntime = jobCtx.getJobRuntime(jobName)) != null) {
            Integer executorPoolSize = jobRuntime.getExecutorPoolSize();
            if (executorPoolSize != null) {
                threadPoolSize = executorPoolSize;
            } else if (StringUtils.isNotBlank((CharSequence)jobRuntime.getJobAttrs())) {
                try {
                    JSONObject attrs = JSON.parseObject((String)jobRuntime.getJobAttrs());
                    Integer integer = attrs.getInteger(EXECUTOR_POOL_SIZE);
                    if (integer != null && integer > 0) {
                        threadPoolSize = integer;
                    }
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (threadPoolSize <= 0) {
            threadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        }
        return new ExecutorServiceObject("elastic-job-" + jobName, threadPoolSize).createExecutorService();
    }
}

