/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.ext;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RoundServerJobShardingStrategy
implements JobShardingStrategy {
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        if (jobInstances.isEmpty()) {
            return Collections.emptyMap();
        }
        List<JobInstance> sortedList = this.sort(jobInstances);
        Map<JobInstance, List<Integer>> result = this.shardingAliquot(sortedList, shardingTotalCount);
        this.addAliquant(sortedList, shardingTotalCount, result);
        return result;
    }

    protected List<JobInstance> sort(List<JobInstance> jobInstances) {
        int instanceCount = jobInstances.size();
        LinkedHashMap<String, ArrayList<JobInstance>> map = new LinkedHashMap<String, ArrayList<JobInstance>>(instanceCount * 2);
        for (JobInstance each : jobInstances) {
            String ip = each.getIp();
            ArrayList<JobInstance> list = (ArrayList<JobInstance>)map.get(ip);
            if (list == null) {
                list = new ArrayList<JobInstance>(instanceCount);
                map.put(ip, list);
            }
            list.add(each);
        }
        ArrayList<JobInstance> sorted = new ArrayList<JobInstance>(instanceCount);
        int i = 0;
        while (i < instanceCount) {
            Iterator iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                List list = (List)entry.getValue();
                sorted.add((JobInstance)list.get(0));
                ++i;
                if (list.size() > 1) {
                    list.remove(0);
                    continue;
                }
                iter.remove();
            }
        }
        return sorted;
    }

    protected Map<JobInstance, List<Integer>> shardingAliquot(List<JobInstance> shardingUnits, int shardingTotalCount) {
        LinkedHashMap<JobInstance, List<Integer>> result = new LinkedHashMap<JobInstance, List<Integer>>(shardingTotalCount, 1.0f);
        int itemCountPerSharding = shardingTotalCount / shardingUnits.size();
        int count = 0;
        for (JobInstance each : shardingUnits) {
            ArrayList<Integer> shardingItems = new ArrayList<Integer>(itemCountPerSharding + 1);
            for (int i = count * itemCountPerSharding; i < (count + 1) * itemCountPerSharding; ++i) {
                shardingItems.add(i);
            }
            result.put(each, shardingItems);
            ++count;
        }
        return result;
    }

    protected void addAliquant(List<JobInstance> shardingUnits, int shardingTotalCount, Map<JobInstance, List<Integer>> shardingResults) {
        int aliquant = shardingTotalCount % shardingUnits.size();
        int count = 0;
        for (JobInstance shardingUnit : shardingUnits) {
            if (count < aliquant) {
                shardingResults.get(shardingUnit).add(shardingTotalCount / shardingUnits.size() * shardingUnits.size() + count);
            }
            ++count;
        }
    }
}

