/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.ext;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import io.polaris.framework.toolkit.elasticjob.ext.RoundServerJobShardingStrategy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class RotateServerNodeJobShardingStrategy
extends RoundServerJobShardingStrategy
implements JobShardingStrategy {
    private static final AtomicInteger rotateNumber = new AtomicInteger(0);

    @Override
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        if (jobInstances.isEmpty()) {
            return Collections.emptyMap();
        }
        List<JobInstance> sortedList = this.rotate(jobInstances);
        Map<JobInstance, List<Integer>> result = this.shardingAliquot(sortedList, shardingTotalCount);
        this.addAliquant(sortedList, shardingTotalCount, result);
        return result;
    }

    List<JobInstance> rotate(List<JobInstance> jobInstances) {
        List<JobInstance> sorted = this.sort(jobInstances);
        int instanceCount = sorted.size();
        int ipOffset = Math.abs(rotateNumber.getAndIncrement()) % instanceCount;
        Collections.rotate(sorted, -ipOffset);
        return sorted;
    }
}

