/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.ext;

import com.dangdang.ddframe.job.lite.api.strategy.JobInstance;
import com.dangdang.ddframe.job.lite.api.strategy.JobShardingStrategy;
import io.polaris.framework.toolkit.elasticjob.ext.RoundServerJobShardingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class RotateServerJobShardingStrategy
extends RoundServerJobShardingStrategy
implements JobShardingStrategy {
    private static final AtomicInteger rotateNumber = new AtomicInteger(0);

    @Override
    public Map<JobInstance, List<Integer>> sharding(List<JobInstance> jobInstances, String jobName, int shardingTotalCount) {
        if (jobInstances.isEmpty()) {
            return Collections.emptyMap();
        }
        List<JobInstance> sortedList = this.rotate(jobInstances);
        Map<JobInstance, List<Integer>> result = this.shardingAliquot(sortedList, shardingTotalCount);
        this.addAliquant(sortedList, shardingTotalCount, result);
        return result;
    }

    List<JobInstance> rotate(List<JobInstance> jobInstances) {
        int instanceCount = jobInstances.size();
        LinkedHashMap<String, ArrayList<JobInstance>> map = new LinkedHashMap<String, ArrayList<JobInstance>>(instanceCount * 2);
        for (JobInstance each : jobInstances) {
            String ip = each.getIp();
            ArrayList<JobInstance> list = (ArrayList<JobInstance>)map.get(ip);
            if (list == null) {
                list = new ArrayList<JobInstance>(instanceCount);
                map.put(ip, list);
            }
            list.add(each);
        }
        Set ipSet = map.keySet();
        int ipCount = ipSet.size();
        int ipOffset = Math.abs(rotateNumber.getAndIncrement()) % ipCount;
        Iterator ipIter = ipSet.iterator();
        String[] ipArray = new String[ipCount];
        for (int i = 0; i < ipCount; ++i) {
            String ip = (String)ipIter.next();
            int idx = i - ipOffset;
            if (idx >= 0) {
                ipArray[idx] = ip;
                continue;
            }
            ipArray[idx + ipCount] = ip;
        }
        ArrayList<JobInstance> sorted = new ArrayList<JobInstance>(instanceCount);
        int i = 0;
        while (i < instanceCount) {
            for (String ip : ipArray) {
                List list = (List)map.get(ip);
                if (list == null) continue;
                sorted.add((JobInstance)list.get(0));
                ++i;
                if (list.size() > 1) {
                    list.remove(0);
                    continue;
                }
                map.remove(ip);
            }
        }
        return sorted;
    }
}

