/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.ext;

import com.dangdang.ddframe.job.context.ExecutionType;
import com.dangdang.ddframe.job.event.rdb.DatabaseType;
import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import com.dangdang.ddframe.job.event.type.JobStatusTraceEvent;
import io.polaris.core.function.ExecutableWithArgs1;
import io.polaris.core.jdbc.Jdbcs;
import io.polaris.core.string.Strings;
import io.polaris.framework.toolkit.elasticjob.repository.BaseRepository;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEventRdbStorage
extends BaseRepository {
    private static final Logger log = LoggerFactory.getLogger(JobEventRdbStorage.class);
    private static final String TABLE_JOB_EXECUTION_LOG = "CRM_JOB_EXECUTION_LOG";
    private static final String TABLE_JOB_STATUS_TRACE_LOG = "CRM_JOB_STATUS_TRACE_LOG";
    private DatabaseType databaseType;
    private boolean tableJobExecutionLogExists = false;
    private boolean tableJobStatusTraceLogExists = false;

    JobEventRdbStorage(DataSource dataSource) {
        super(dataSource);
        this.checkRdbTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRdbTables() {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            try {
                this.databaseType = DatabaseType.valueFrom((String)dbMetaData.getDatabaseProductName());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                this.databaseType = null;
            }
            this.tableJobExecutionLogExists = this.existsTable(conn, TABLE_JOB_EXECUTION_LOG);
            this.tableJobStatusTraceLogExists = this.existsTable(conn, TABLE_JOB_STATUS_TRACE_LOG);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            Jdbcs.close((Connection)conn);
        }
    }

    private boolean isDuplicateRecord(SQLException ex) {
        return DatabaseType.MySQL.equals((Object)this.databaseType) && 1062 == ex.getErrorCode() || DatabaseType.H2.equals((Object)this.databaseType) && 23505 == ex.getErrorCode() || DatabaseType.SQLServer.equals((Object)this.databaseType) && 1 == ex.getErrorCode() || DatabaseType.DB2.equals((Object)this.databaseType) && -803 == ex.getErrorCode() || DatabaseType.PostgreSQL.equals((Object)this.databaseType) && 0 == ex.getErrorCode() || DatabaseType.Oracle.equals((Object)this.databaseType) && 1 == ex.getErrorCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWithConnection(boolean insert, ExecutableWithArgs1<Connection> consumer) {
        Connection conn = null;
        boolean autoCommit = true;
        try {
            conn = this.dataSource.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            consumer.execute((Object)conn);
            conn.commit();
        }
        catch (SQLException e) {
            if (insert) {
                if (this.isDuplicateRecord(e)) {
                    log.error("", (Throwable)e);
                }
            } else {
                log.error("", (Throwable)e);
            }
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                log.error("", (Throwable)ex);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException ex) {
                log.error("", (Throwable)ex);
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {}
            Jdbcs.close((Connection)conn);
        }
    }

    private int insert(String sql, Object ... params) {
        int[] rows = new int[]{0};
        this.doWithConnection(true, (ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            rows[0] = Jdbcs.update((Connection)conn, (String)sql, (Object[])params);
        }));
        return rows[0];
    }

    private int update(String sql, Object ... params) {
        int[] rows = new int[]{0};
        this.doWithConnection(false, (ExecutableWithArgs1<Connection>)((ExecutableWithArgs1)conn -> {
            rows[0] = Jdbcs.update((Connection)conn, (String)sql, (Object[])params);
        }));
        return rows[0];
    }

    void addJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        if (null == jobExecutionEvent.getCompleteTime()) {
            this.insertJobExecutionEvent(jobExecutionEvent);
        } else if (jobExecutionEvent.isSuccess()) {
            this.updateJobExecutionEventWhenSuccess(jobExecutionEvent);
        } else {
            this.updateJobExecutionEventFailure(jobExecutionEvent);
        }
    }

    private void insertJobExecutionEvent(JobExecutionEvent jobExecutionEvent) {
        if (this.tableJobExecutionLogExists) {
            String sql = "insert into CRM_JOB_EXECUTION_LOG (id, job_name, task_id, hostname, ip, sharding_item, execution_source, is_success, start_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.insert(sql, jobExecutionEvent.getId(), jobExecutionEvent.getJobName(), jobExecutionEvent.getTaskId(), jobExecutionEvent.getHostname(), jobExecutionEvent.getIp(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource().toString(), jobExecutionEvent.isSuccess(), new Timestamp(jobExecutionEvent.getStartTime().getTime()));
        }
    }

    private void updateJobExecutionEventWhenSuccess(JobExecutionEvent jobExecutionEvent) {
        if (this.tableJobExecutionLogExists) {
            String sql = "UPDATE CRM_JOB_EXECUTION_LOG SET is_success = ?, complete_time = ? WHERE id = ?";
            this.update(sql, jobExecutionEvent.isSuccess(), new Timestamp(jobExecutionEvent.getCompleteTime().getTime()), jobExecutionEvent.getId());
        }
    }

    private void insertJobExecutionEventWhenSuccess(JobExecutionEvent jobExecutionEvent) {
        if (this.tableJobExecutionLogExists) {
            String sql = "insert into CRM_JOB_EXECUTION_LOG (id, job_name, task_id, hostname, ip, sharding_item, execution_source, is_success, start_time, complete_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            this.insert(sql, jobExecutionEvent.getId(), jobExecutionEvent.getJobName(), jobExecutionEvent.getTaskId(), jobExecutionEvent.getHostname(), jobExecutionEvent.getIp(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource().toString(), jobExecutionEvent.isSuccess(), new Timestamp(jobExecutionEvent.getStartTime().getTime()), new Timestamp(jobExecutionEvent.getCompleteTime().getTime()));
        }
    }

    private void updateJobExecutionEventFailure(JobExecutionEvent jobExecutionEvent) {
        if (this.tableJobExecutionLogExists) {
            String sqlUpdate = "update CRM_JOB_EXECUTION_LOG set is_success = ?, complete_time = ?, failure_cause = ? where id = ?";
            int rows = this.update(sqlUpdate, jobExecutionEvent.isSuccess(), new Timestamp(jobExecutionEvent.getCompleteTime().getTime()), Strings.truncate((String)jobExecutionEvent.getFailureCause(), (int)2000), jobExecutionEvent.getId());
            if (rows == 0) {
                String sql = "insert into CRM_JOB_EXECUTION_LOG (id, job_name, task_id, hostname, ip, sharding_item, execution_source, failure_cause, is_success, start_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                this.insert(sql, jobExecutionEvent.getId(), jobExecutionEvent.getJobName(), jobExecutionEvent.getTaskId(), jobExecutionEvent.getHostname(), jobExecutionEvent.getIp(), jobExecutionEvent.getShardingItem(), jobExecutionEvent.getSource().toString(), Strings.truncate((String)jobExecutionEvent.getFailureCause(), (int)2000), jobExecutionEvent.isSuccess(), new Timestamp(jobExecutionEvent.getStartTime().getTime()));
            }
        }
    }

    void addJobStatusTraceEvent(JobStatusTraceEvent jobStatusTraceEvent) {
        if (this.tableJobStatusTraceLogExists) {
            String sql = "insert into CRM_JOB_STATUS_TRACE_LOG (id, job_name, original_task_id, task_id, slave_id, source, execution_type, sharding_item,  state, message, creation_time) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String originalTaskId = jobStatusTraceEvent.getOriginalTaskId();
            if (JobStatusTraceEvent.State.TASK_STAGING != jobStatusTraceEvent.getState()) {
                originalTaskId = this.getOriginalTaskId(jobStatusTraceEvent.getTaskId());
            }
            this.insert(sql, UUID.randomUUID().toString(), jobStatusTraceEvent.getJobName(), originalTaskId, jobStatusTraceEvent.getTaskId(), jobStatusTraceEvent.getSlaveId(), jobStatusTraceEvent.getSource().toString(), jobStatusTraceEvent.getExecutionType().name(), jobStatusTraceEvent.getShardingItems(), jobStatusTraceEvent.getState().toString(), Strings.truncate((String)jobStatusTraceEvent.getMessage(), (int)2000), new Timestamp(jobStatusTraceEvent.getCreationTime().getTime()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getOriginalTaskId(String taskId) {
        String sql = String.format("SELECT original_task_id FROM %s WHERE task_id = '%s' and state='%s'", TABLE_JOB_STATUS_TRACE_LOG, taskId, JobStatusTraceEvent.State.TASK_STAGING);
        String result = "";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement preparedStatement = conn.prepareStatement(sql);
             ResultSet resultSet = preparedStatement.executeQuery();){
            if (!resultSet.next()) return result;
            String string = resultSet.getString("original_task_id");
            return string;
        }
        catch (SQLException ex) {
            log.error(ex.getMessage());
        }
        return result;
    }

    List<JobStatusTraceEvent> getJobStatusTraceEvents(String taskId) {
        ArrayList<JobStatusTraceEvent> result = new ArrayList<JobStatusTraceEvent>();
        if (this.tableJobStatusTraceLogExists) {
            String sql = String.format("SELECT * FROM %s WHERE task_id = '%s'", TABLE_JOB_STATUS_TRACE_LOG, taskId);
            try (Connection conn = this.dataSource.getConnection();
                 PreparedStatement preparedStatement = conn.prepareStatement(sql);
                 ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    JobStatusTraceEvent jobStatusTraceEvent = new JobStatusTraceEvent(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), JobStatusTraceEvent.Source.valueOf((String)resultSet.getString(6)), ExecutionType.valueOf((String)resultSet.getString(7)), resultSet.getString(8), JobStatusTraceEvent.State.valueOf((String)resultSet.getString(9)), resultSet.getString(10), new SimpleDateFormat("yyyy-mm-dd HH:MM:SS").parse(resultSet.getString(11)));
                    result.add(jobStatusTraceEvent);
                }
            }
            catch (SQLException | ParseException ex) {
                log.error(ex.getMessage());
            }
        }
        return result;
    }
}

