/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.ext;

import com.dangdang.ddframe.job.event.JobEventListener;
import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import com.dangdang.ddframe.job.event.type.JobStatusTraceEvent;
import io.polaris.framework.toolkit.elasticjob.context.JobCtx;
import io.polaris.framework.toolkit.elasticjob.ext.JobEventRdbIdentity;
import io.polaris.framework.toolkit.elasticjob.ext.JobEventRdbStorage;
import io.polaris.framework.toolkit.elasticjob.repository.JobRuntimeRepository;

public class JobEventRdbListener
extends JobEventRdbIdentity
implements JobEventListener {
    private final transient JobCtx jobCtx;
    private final JobEventRdbStorage jobEventRdbStorage;
    private final JobRuntimeRepository jobRuntimeRepository;

    public JobEventRdbListener(JobCtx jobCtx) {
        this.jobCtx = jobCtx;
        if (jobCtx.isEnabledRdbEvent()) {
            this.jobEventRdbStorage = new JobEventRdbStorage(jobCtx.getDataSource());
            this.jobRuntimeRepository = jobCtx.getJobRuntimeRepository();
        } else {
            this.jobEventRdbStorage = null;
            this.jobRuntimeRepository = null;
        }
    }

    public void listen(JobExecutionEvent executionEvent) {
        if (this.jobEventRdbStorage != null) {
            this.jobEventRdbStorage.addJobExecutionEvent(executionEvent);
            this.jobRuntimeRepository.saveJobShardingRuntime(this.jobCtx.getProfile(), this.jobCtx.getSysId(), this.jobCtx.getVmProcessUid(), executionEvent);
        }
    }

    public void listen(JobStatusTraceEvent jobStatusTraceEvent) {
        if (this.jobEventRdbStorage != null) {
            this.jobEventRdbStorage.addJobStatusTraceEvent(jobStatusTraceEvent);
        }
    }
}

