/*
 * Decompiled with CFR 0.152.
 */
package io.polaris.framework.toolkit.elasticjob.entity;

import com.dangdang.ddframe.job.api.JobType;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandler;
import com.dangdang.ddframe.job.executor.handler.JobExceptionHandler;
import io.polaris.core.jdbc.annotation.Column;
import io.polaris.core.jdbc.annotation.Id;
import io.polaris.core.jdbc.annotation.Table;
import io.polaris.core.lang.copier.Copiers;
import io.polaris.framework.toolkit.elasticjob.context.JobState;
import io.polaris.framework.toolkit.elasticjob.entity.JobCfgEntity;
import io.polaris.framework.toolkit.elasticjob.err.JobException;
import io.polaris.framework.toolkit.elasticjob.properties.DataflowJobProperties;
import io.polaris.framework.toolkit.elasticjob.properties.JobCoreProperties;
import io.polaris.framework.toolkit.elasticjob.properties.ScriptJobProperties;
import io.polaris.framework.toolkit.elasticjob.properties.SimpleJobProperties;
import io.polaris.validation.group.Create;
import io.polaris.validation.group.Delete;
import io.polaris.validation.group.Retrieve;
import io.polaris.validation.group.Update;
import io.polaris.validation.group.UpdateEntire;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Table(value="CRM_JOB_RUNTIME")
public class JobRuntimeEntity
implements Serializable,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(JobRuntimeEntity.class);
    private static final long serialVersionUID = 1L;
    public static final String TABLE = "CRM_JOB_RUNTIME";
    @Schema(description="ID")
    @Id
    @Column(value="ID")
    @NotNull(groups={Create.class, Update.class, Delete.class, Retrieve.class, UpdateEntire.class}, message="ID[id]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, Update.class, Delete.class, Retrieve.class, UpdateEntire.class}, message="ID[id]\u4e0d\u80fd\u4e3a\u7a7a") String id;
    @Schema(description="\u73af\u5883")
    @Column(value="PROFILE")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u73af\u5883[profile]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u73af\u5883[profile]\u4e0d\u80fd\u4e3a\u7a7a") String profile;
    @Schema(description="\u5e94\u7528\u6807\u8bc6")
    @Column(value="SYS_ID")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u5e94\u7528\u6807\u8bc6[sysId]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u5e94\u7528\u6807\u8bc6[sysId]\u4e0d\u80fd\u4e3a\u7a7a") String sysId;
    @Schema(description="\u4f5c\u4e1a\u4efb\u52a1\u540d")
    @Column(value="JOB_NAME")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u4efb\u52a1\u540d[jobName]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u4efb\u52a1\u540d[jobName]\u4e0d\u80fd\u4e3a\u7a7a") String jobName;
    @Schema(description="\u4f5c\u4e1a\u7c7b\u578b")
    @Column(value="JOB_TYPE")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u7c7b\u578b[jobType]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u7c7b\u578b[jobType]\u4e0d\u80fd\u4e3a\u7a7a") JobType jobType;
    @Schema(description="\u4f5c\u4e1a\u63cf\u8ff0\u4fe1\u606f")
    @Column(value="DESCRIPTION")
    private String description = "";
    @Schema(description="\u4f5c\u4e1a\u81ea\u5b9a\u4e49\u53c2\u6570")
    @Column(value="JOB_PARAMETER")
    private String jobParameter;
    @Schema(description="SHARDING_ITEMS")
    @Column(value="SHARDING_ITEMS")
    private String shardingItems;
    @Schema(description="\u4e3b\u673aIP\u4e0e\u8fdb\u7a0b\u53f7")
    @Column(value="VM_PROCESS_UID")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4e3b\u673aIP\u4e0e\u8fdb\u7a0b\u53f7[vmProcessUid]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4e3b\u673aIP\u4e0e\u8fdb\u7a0b\u53f7[vmProcessUid]\u4e0d\u80fd\u4e3a\u7a7a") String vmProcessUid;
    @Schema(description="\u865a\u62df\u673a\u542f\u52a8\u65f6\u95f4")
    @Column(value="VM_START_TIME")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u865a\u62df\u673a\u542f\u52a8\u65f6\u95f4[vmStartTime]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u865a\u62df\u673a\u542f\u52a8\u65f6\u95f4[vmStartTime]\u4e0d\u80fd\u4e3a\u7a7a") Date vmStartTime;
    @Schema(description="\u7ebf\u7a0b\u53f7")
    @Column(value="VM_THREAD_ID")
    private String vmThreadId;
    @Schema(description="\u7ebf\u7a0b\u540d")
    @Column(value="VM_THREAD_NAME")
    private String vmThreadName;
    @Schema(description="\u4f5c\u4e1a\u72b6\u6001")
    @Column(value="JOB_STATE")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u72b6\u6001[jobState]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u72b6\u6001[jobState]\u4e0d\u80fd\u4e3a\u7a7a") JobState jobState;
    @Schema(description="\u5f00\u59cb\u65f6\u95f4")
    @Column(value="BEGIN_TIME")
    private Date beginTime;
    @Schema(description="\u7ed3\u675f\u65f6\u95f4")
    @Column(value="END_TIME")
    private Date endTime;
    @Schema(description="\u72b6\u6001\u4fe1\u606f")
    @Column(value="MESSAGE")
    private String message;
    @Schema(description="\u5f02\u5e38\u5806\u6808")
    @Column(value="STACK_TRACE")
    private String stackTrace;
    @Schema(description="\u4f5c\u4e1a\u6267\u884c\u5668")
    @Column(value="JOB_EXECUTOR")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u6267\u884c\u5668[jobExecutor]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u6267\u884c\u5668[jobExecutor]\u4e0d\u80fd\u4e3a\u7a7a") String jobExecutor;
    @Schema(description="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f")
    @Column(value="JOB_CRON")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f[jobCron]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u542f\u52a8\u65f6\u95f4\u7684cron\u8868\u8fbe\u5f0f[jobCron]\u4e0d\u80fd\u4e3a\u7a7a") String jobCron;
    @Schema(description="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a")
    @Column(value="SHARDING_ENABLED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a[shardingEnabled]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u542f\u52a8\u5206\u7247\u4f5c\u4e1a[shardingEnabled]\u4e0d\u80fd\u4e3a\u7a7a") Boolean shardingEnabled = true;
    @Schema(description="\u4f5c\u4e1a\u5206\u7247\u603b\u6570")
    @Column(value="SHARDING_TOTAL_COUNT")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u5206\u7247\u603b\u6570[shardingTotalCount]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u5206\u7247\u603b\u6570[shardingTotalCount]\u4e0d\u80fd\u4e3a\u7a7a") Integer shardingTotalCount;
    @Schema(description="\u5206\u7247\u5e8f\u5217\u53f7\u548c\u4e2a\u6027\u5316\u53c2\u6570\u5bf9\u7167\u8868")
    @Column(value="SHARDING_ITEM_PARAMETERS")
    private String shardingItemParameters;
    @Schema(description="\u662f\u5426\u5f00\u542f\u5931\u6548\u8f6c\u79fb")
    @Column(value="FAILOVER")
    private Boolean failover;
    @Schema(description="\u662f\u5426\u5f00\u542f\u9519\u8fc7\u4f5c\u4e1a\u91cd\u65b0\u6267\u884c")
    @Column(value="MISFIRE")
    private Boolean misfire;
    @Schema(description="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e")
    @Column(value="STREAMING_PROCESS")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e[streamingProcess]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u6d41\u5f0f\u5904\u7406\u6570\u636e[streamingProcess]\u4e0d\u80fd\u4e3a\u7a7a") Boolean streamingProcess;
    @Schema(description="\u76d1\u63a7\u4f5c\u4e1a\u6267\u884c\u65f6\u72b6\u6001")
    @Column(value="MONITOR_EXECUTION")
    private Boolean monitorExecution;
    @Schema(description="\u6700\u5927\u5bb9\u5fcd\u7684\u672c\u673a\u4e0e\u6ce8\u518c\u4e2d\u5fc3\u7684\u65f6\u95f4\u8bef\u5dee\u79d2\u6570")
    @Column(value="MAX_TIME_DIFF_SECONDS")
    private Integer maxTimeDiffSeconds;
    @Schema(description="\u4f5c\u4e1a\u8f85\u52a9\u76d1\u63a7\u7aef\u53e3")
    @Column(value="MONITOR_PORT")
    private Integer monitorPort;
    @Schema(description="\u4f5c\u4e1a\u5206\u7247\u7b56\u7565\u5b9e\u73b0\u7c7b\u5168\u8def\u5f84")
    @Column(value="JOB_SHARDING_STRATEGY")
    private String jobShardingStrategy;
    @Schema(description="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62")
    @Column(value="DISABLED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62[disabled]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4f5c\u4e1a\u662f\u5426\u542f\u52a8\u65f6\u7981\u6b62[disabled]\u4e0d\u80fd\u4e3a\u7a7a") Boolean disabled;
    @Schema(description="\u672c\u5730\u914d\u7f6e\u662f\u5426\u53ef\u8986\u76d6\u6ce8\u518c\u4e2d\u5fc3\u914d\u7f6e")
    @Column(value="OVERWRITE")
    private Boolean overwrite;
    @Column(value="RECONCILE_INTERVAL_MINUTES")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u590d\u4f5c\u4e1a\u670d\u52a1\u5668\u4e0d\u4e00\u81f4\u72b6\u6001\u670d\u52a1\u6267\u884c\u95f4\u9694\u5206\u949f\u6570[reconcileIntervalMinutes]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u590d\u4f5c\u4e1a\u670d\u52a1\u5668\u4e0d\u4e00\u81f4\u72b6\u6001\u670d\u52a1\u6267\u884c\u95f4\u9694\u5206\u949f\u6570[reconcileIntervalMinutes]\u4e0d\u80fd\u4e3a\u7a7a") Integer reconcileIntervalMinutes;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027")
    @Column(value="JOB_ATTRS")
    private String jobAttrs;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u4f5c\u4e1a\u5f02\u5e38\u5904\u7406\u5668")
    @Column(value="JOB_EXCEPTION_HANDLER")
    private String jobExceptionHandler;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668")
    @Column(value="EXECUTOR_SERVICE_HANDLER")
    private String executorServiceHandler;
    @Schema(description="\u4f5c\u4e1a\u5c5e\u6027-\u91c7\u7528\u52a8\u6001\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668\u7684\u671f\u671b\u7ebf\u7a0b\u6c60\u5927\u5c0f")
    @Column(value="EXECUTOR_POOL_SIZE")
    private Integer executorPoolSize;
    @Schema(description="\u662f\u5426\u5220\u9664")
    @Column(value="DELETED")
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u5220\u9664[deleted]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u662f\u5426\u5220\u9664[deleted]\u4e0d\u80fd\u4e3a\u7a7a") Boolean deleted;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    @Column(value="CRT_DT", updatable=false, createTime=true)
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u521b\u5efa\u65f6\u95f4[crtDt]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u521b\u5efa\u65f6\u95f4[crtDt]\u4e0d\u80fd\u4e3a\u7a7a") Date crtDt;
    @Schema(description="\u4fee\u6539\u65f6\u95f4")
    @Column(value="UPT_DT", updateTime=true)
    @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u6539\u65f6\u95f4[uptDt]\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(groups={Create.class, UpdateEntire.class}, message="\u4fee\u6539\u65f6\u95f4[uptDt]\u4e0d\u80fd\u4e3a\u7a7a") Date uptDt;
    @Column(ignored=true)
    private Class<?> jobExecutorClass;
    @Column(ignored=true)
    private Class<?> executorServiceHandlerClass;
    @Column(ignored=true)
    private Class<?> jobExceptionHandlerClass;
    @Column(ignored=true)
    private Class<?> jobShardingStrategyClass;

    public static JobRuntimeEntity newEntity(JobCfgEntity jobCfg) {
        JobRuntimeEntity jobRuntime = new JobRuntimeEntity();
        Copiers.fastCopyBeanToBean((Object)jobCfg, (Object)jobRuntime);
        jobRuntime.setId(null);
        return jobRuntime;
    }

    public static JobRuntimeEntity newEntity(JobCoreProperties properties) {
        JobRuntimeEntity entity = new JobRuntimeEntity();
        entity.setShardingEnabled(true);
        entity.setDeleted(!properties.isEnabled());
        if (properties instanceof DataflowJobProperties) {
            entity.setJobType(JobType.DATAFLOW);
            entity.setJobExecutorClass(((DataflowJobProperties)properties).getJobClass());
            entity.setStreamingProcess(((DataflowJobProperties)properties).isStreamingProcess());
        } else if (properties instanceof ScriptJobProperties) {
            entity.setJobType(JobType.SCRIPT);
            entity.setJobExecutor(((ScriptJobProperties)properties).getScriptCommandLine());
        } else {
            entity.setJobType(JobType.SIMPLE);
            entity.setJobExecutorClass(((SimpleJobProperties)properties).getJobClass());
        }
        entity.setDescription(properties.getDescription());
        entity.setJobParameter(properties.getJobParameter());
        entity.setJobCron(properties.getCron());
        entity.setShardingTotalCount(properties.getShardingTotalCount());
        entity.setShardingItemParameters(properties.getShardingItemParameters());
        entity.setFailover(properties.isFailover());
        entity.setMisfire(properties.isMisfire());
        entity.setMonitorExecution(properties.isMonitorExecution());
        entity.setMaxTimeDiffSeconds(properties.getMaxTimeDiffSeconds());
        entity.setMonitorPort(properties.getMonitorPort());
        entity.setJobShardingStrategyClass(properties.getJobShardingStrategyClass());
        entity.setDisabled(properties.isDisabled());
        entity.setOverwrite(properties.isOverwrite());
        entity.setReconcileIntervalMinutes(properties.getReconcileIntervalMinutes());
        entity.setJobExceptionHandlerClass(properties.getJobExceptionHandler());
        entity.setExecutorServiceHandlerClass(properties.getExecutorServiceHandler());
        entity.setExecutorPoolSize(0);
        return entity;
    }

    public JobRuntimeEntity clone() {
        try {
            JobRuntimeEntity clone = (JobRuntimeEntity)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public Class<?> getJobExecutorClass() {
        if (this.jobExecutorClass == null) {
            if (this.jobExecutor == null) {
                return null;
            }
            try {
                this.jobExecutorClass = Class.forName(this.jobExecutor);
            }
            catch (ClassNotFoundException e) {
                throw new JobException("\u4f5c\u4e1a\u6267\u884c\u5668\u7c7b\u4e0d\u5b58\u5728" + this.jobExecutor, e);
            }
        }
        return this.jobExecutorClass;
    }

    public void setJobExecutorClass(Class<?> jobExecutorClass) {
        this.jobExecutorClass = jobExecutorClass;
        this.jobExecutor = jobExecutorClass == null ? null : jobExecutorClass.getCanonicalName();
    }

    public Class<?> getExecutorServiceHandlerClass() {
        if (this.executorServiceHandlerClass == null) {
            if (this.executorServiceHandler == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(this.executorServiceHandler);
                if (ExecutorServiceHandler.class.isAssignableFrom(clazz)) {
                    this.executorServiceHandlerClass = clazz;
                } else {
                    this.executorServiceHandler = null;
                    log.error("\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668\u7c7b\u578b\u6709\u8bef\uff1a" + this.executorServiceHandler);
                }
            }
            catch (ClassNotFoundException e) {
                this.executorServiceHandler = null;
                log.error("\u7ebf\u7a0b\u6c60\u670d\u52a1\u5904\u7406\u5668\u7c7b\u4e0d\u5b58\u5728\uff1a" + this.executorServiceHandler, (Throwable)e);
            }
        }
        return this.executorServiceHandlerClass;
    }

    public void setExecutorServiceHandlerClass(Class<?> executorServiceHandlerClass) {
        this.executorServiceHandlerClass = executorServiceHandlerClass;
        this.executorServiceHandler = executorServiceHandlerClass == null ? null : executorServiceHandlerClass.getCanonicalName();
    }

    public Class<?> getJobExceptionHandlerClass() {
        if (this.jobExceptionHandlerClass == null) {
            if (this.jobExceptionHandler == null) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(this.jobExceptionHandler);
                if (JobExceptionHandler.class.isAssignableFrom(clazz)) {
                    this.jobExceptionHandlerClass = clazz;
                } else {
                    this.jobExceptionHandler = null;
                    log.error("\u4f5c\u4e1a\u5f02\u5e38\u5904\u7406\u5668\u7c7b\u578b\u6709\u8bef\uff1a" + this.jobExceptionHandler);
                }
            }
            catch (ClassNotFoundException e) {
                this.jobExceptionHandler = null;
                log.error("\u4f5c\u4e1a\u5f02\u5e38\u5904\u7406\u5668\u7c7b\u4e0d\u5b58\u5728\uff1a" + this.jobExceptionHandler, (Throwable)e);
            }
        }
        return this.jobExceptionHandlerClass;
    }

    public void setJobExceptionHandlerClass(Class<?> jobExceptionHandlerClass) {
        this.jobExceptionHandlerClass = jobExceptionHandlerClass;
        this.jobExceptionHandler = jobExceptionHandlerClass == null ? null : jobExceptionHandlerClass.getCanonicalName();
    }

    public Class<?> getJobShardingStrategyClass() {
        if (this.jobShardingStrategyClass == null) {
            if (this.jobShardingStrategy == null) {
                return null;
            }
            try {
                this.jobShardingStrategyClass = Class.forName(this.jobShardingStrategy);
            }
            catch (ClassNotFoundException e) {
                throw new JobException("\u4f5c\u4e1a\u5206\u7247\u7b56\u7565\u5b9e\u73b0\u7c7b\u4e0d\u5b58\u5728" + this.jobShardingStrategy, e);
            }
        }
        return this.jobShardingStrategyClass;
    }

    public void setJobShardingStrategyClass(Class<?> jobShardingStrategyClass) {
        this.jobShardingStrategyClass = jobShardingStrategyClass;
        this.jobShardingStrategy = jobShardingStrategyClass == null ? null : jobShardingStrategyClass.getCanonicalName();
    }

    public String getStackTrace() {
        return StringUtils.trimToEmpty((String)this.stackTrace);
    }

    private static String $default$jobParameter() {
        return "";
    }

    private static String $default$shardingItemParameters() {
        return "";
    }

    private static Boolean $default$misfire() {
        return true;
    }

    private static Boolean $default$streamingProcess() {
        return true;
    }

    private static Boolean $default$monitorExecution() {
        return true;
    }

    private static Integer $default$maxTimeDiffSeconds() {
        return -1;
    }

    private static Integer $default$monitorPort() {
        return -1;
    }

    private static String $default$jobShardingStrategy() {
        return "";
    }

    private static Integer $default$reconcileIntervalMinutes() {
        return 10;
    }

    public static JobRuntimeEntityBuilder builder() {
        return new JobRuntimeEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getSysId() {
        return this.sysId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJobParameter() {
        return this.jobParameter;
    }

    public String getShardingItems() {
        return this.shardingItems;
    }

    public String getVmProcessUid() {
        return this.vmProcessUid;
    }

    public Date getVmStartTime() {
        return this.vmStartTime;
    }

    public String getVmThreadId() {
        return this.vmThreadId;
    }

    public String getVmThreadName() {
        return this.vmThreadName;
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getMessage() {
        return this.message;
    }

    public String getJobExecutor() {
        return this.jobExecutor;
    }

    public String getJobCron() {
        return this.jobCron;
    }

    public Boolean getShardingEnabled() {
        return this.shardingEnabled;
    }

    public Integer getShardingTotalCount() {
        return this.shardingTotalCount;
    }

    public String getShardingItemParameters() {
        return this.shardingItemParameters;
    }

    public Boolean getFailover() {
        return this.failover;
    }

    public Boolean getMisfire() {
        return this.misfire;
    }

    public Boolean getStreamingProcess() {
        return this.streamingProcess;
    }

    public Boolean getMonitorExecution() {
        return this.monitorExecution;
    }

    public Integer getMaxTimeDiffSeconds() {
        return this.maxTimeDiffSeconds;
    }

    public Integer getMonitorPort() {
        return this.monitorPort;
    }

    public String getJobShardingStrategy() {
        return this.jobShardingStrategy;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Boolean getOverwrite() {
        return this.overwrite;
    }

    public Integer getReconcileIntervalMinutes() {
        return this.reconcileIntervalMinutes;
    }

    public String getJobAttrs() {
        return this.jobAttrs;
    }

    public String getJobExceptionHandler() {
        return this.jobExceptionHandler;
    }

    public String getExecutorServiceHandler() {
        return this.executorServiceHandler;
    }

    public Integer getExecutorPoolSize() {
        return this.executorPoolSize;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public Date getCrtDt() {
        return this.crtDt;
    }

    public Date getUptDt() {
        return this.uptDt;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setJobParameter(String jobParameter) {
        this.jobParameter = jobParameter;
    }

    public void setShardingItems(String shardingItems) {
        this.shardingItems = shardingItems;
    }

    public void setVmProcessUid(String vmProcessUid) {
        this.vmProcessUid = vmProcessUid;
    }

    public void setVmStartTime(Date vmStartTime) {
        this.vmStartTime = vmStartTime;
    }

    public void setVmThreadId(String vmThreadId) {
        this.vmThreadId = vmThreadId;
    }

    public void setVmThreadName(String vmThreadName) {
        this.vmThreadName = vmThreadName;
    }

    public void setJobState(JobState jobState) {
        this.jobState = jobState;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public void setJobExecutor(String jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    public void setJobCron(String jobCron) {
        this.jobCron = jobCron;
    }

    public void setShardingEnabled(Boolean shardingEnabled) {
        this.shardingEnabled = shardingEnabled;
    }

    public void setShardingTotalCount(Integer shardingTotalCount) {
        this.shardingTotalCount = shardingTotalCount;
    }

    public void setShardingItemParameters(String shardingItemParameters) {
        this.shardingItemParameters = shardingItemParameters;
    }

    public void setFailover(Boolean failover) {
        this.failover = failover;
    }

    public void setMisfire(Boolean misfire) {
        this.misfire = misfire;
    }

    public void setStreamingProcess(Boolean streamingProcess) {
        this.streamingProcess = streamingProcess;
    }

    public void setMonitorExecution(Boolean monitorExecution) {
        this.monitorExecution = monitorExecution;
    }

    public void setMaxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
    }

    public void setMonitorPort(Integer monitorPort) {
        this.monitorPort = monitorPort;
    }

    public void setJobShardingStrategy(String jobShardingStrategy) {
        this.jobShardingStrategy = jobShardingStrategy;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setReconcileIntervalMinutes(Integer reconcileIntervalMinutes) {
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
    }

    public void setJobAttrs(String jobAttrs) {
        this.jobAttrs = jobAttrs;
    }

    public void setJobExceptionHandler(String jobExceptionHandler) {
        this.jobExceptionHandler = jobExceptionHandler;
    }

    public void setExecutorServiceHandler(String executorServiceHandler) {
        this.executorServiceHandler = executorServiceHandler;
    }

    public void setExecutorPoolSize(Integer executorPoolSize) {
        this.executorPoolSize = executorPoolSize;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public void setCrtDt(Date crtDt) {
        this.crtDt = crtDt;
    }

    public void setUptDt(Date uptDt) {
        this.uptDt = uptDt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobRuntimeEntity)) {
            return false;
        }
        JobRuntimeEntity other = (JobRuntimeEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$shardingEnabled = this.shardingEnabled;
        Boolean other$shardingEnabled = other.shardingEnabled;
        if (this$shardingEnabled == null ? other$shardingEnabled != null : !((Object)this$shardingEnabled).equals(other$shardingEnabled)) {
            return false;
        }
        Integer this$shardingTotalCount = this.shardingTotalCount;
        Integer other$shardingTotalCount = other.shardingTotalCount;
        if (this$shardingTotalCount == null ? other$shardingTotalCount != null : !((Object)this$shardingTotalCount).equals(other$shardingTotalCount)) {
            return false;
        }
        Boolean this$failover = this.failover;
        Boolean other$failover = other.failover;
        if (this$failover == null ? other$failover != null : !((Object)this$failover).equals(other$failover)) {
            return false;
        }
        Boolean this$misfire = this.misfire;
        Boolean other$misfire = other.misfire;
        if (this$misfire == null ? other$misfire != null : !((Object)this$misfire).equals(other$misfire)) {
            return false;
        }
        Boolean this$streamingProcess = this.streamingProcess;
        Boolean other$streamingProcess = other.streamingProcess;
        if (this$streamingProcess == null ? other$streamingProcess != null : !((Object)this$streamingProcess).equals(other$streamingProcess)) {
            return false;
        }
        Boolean this$monitorExecution = this.monitorExecution;
        Boolean other$monitorExecution = other.monitorExecution;
        if (this$monitorExecution == null ? other$monitorExecution != null : !((Object)this$monitorExecution).equals(other$monitorExecution)) {
            return false;
        }
        Integer this$maxTimeDiffSeconds = this.maxTimeDiffSeconds;
        Integer other$maxTimeDiffSeconds = other.maxTimeDiffSeconds;
        if (this$maxTimeDiffSeconds == null ? other$maxTimeDiffSeconds != null : !((Object)this$maxTimeDiffSeconds).equals(other$maxTimeDiffSeconds)) {
            return false;
        }
        Integer this$monitorPort = this.monitorPort;
        Integer other$monitorPort = other.monitorPort;
        if (this$monitorPort == null ? other$monitorPort != null : !((Object)this$monitorPort).equals(other$monitorPort)) {
            return false;
        }
        Boolean this$disabled = this.disabled;
        Boolean other$disabled = other.disabled;
        if (this$disabled == null ? other$disabled != null : !((Object)this$disabled).equals(other$disabled)) {
            return false;
        }
        Boolean this$overwrite = this.overwrite;
        Boolean other$overwrite = other.overwrite;
        if (this$overwrite == null ? other$overwrite != null : !((Object)this$overwrite).equals(other$overwrite)) {
            return false;
        }
        Integer this$reconcileIntervalMinutes = this.reconcileIntervalMinutes;
        Integer other$reconcileIntervalMinutes = other.reconcileIntervalMinutes;
        if (this$reconcileIntervalMinutes == null ? other$reconcileIntervalMinutes != null : !((Object)this$reconcileIntervalMinutes).equals(other$reconcileIntervalMinutes)) {
            return false;
        }
        Integer this$executorPoolSize = this.executorPoolSize;
        Integer other$executorPoolSize = other.executorPoolSize;
        if (this$executorPoolSize == null ? other$executorPoolSize != null : !((Object)this$executorPoolSize).equals(other$executorPoolSize)) {
            return false;
        }
        Boolean this$deleted = this.deleted;
        Boolean other$deleted = other.deleted;
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$profile = this.profile;
        String other$profile = other.profile;
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        String this$sysId = this.sysId;
        String other$sysId = other.sysId;
        if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
            return false;
        }
        String this$jobName = this.jobName;
        String other$jobName = other.jobName;
        if (this$jobName == null ? other$jobName != null : !this$jobName.equals(other$jobName)) {
            return false;
        }
        JobType this$jobType = this.jobType;
        JobType other$jobType = other.jobType;
        if (this$jobType == null ? other$jobType != null : !this$jobType.equals(other$jobType)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$jobParameter = this.jobParameter;
        String other$jobParameter = other.jobParameter;
        if (this$jobParameter == null ? other$jobParameter != null : !this$jobParameter.equals(other$jobParameter)) {
            return false;
        }
        String this$shardingItems = this.shardingItems;
        String other$shardingItems = other.shardingItems;
        if (this$shardingItems == null ? other$shardingItems != null : !this$shardingItems.equals(other$shardingItems)) {
            return false;
        }
        String this$vmProcessUid = this.vmProcessUid;
        String other$vmProcessUid = other.vmProcessUid;
        if (this$vmProcessUid == null ? other$vmProcessUid != null : !this$vmProcessUid.equals(other$vmProcessUid)) {
            return false;
        }
        Date this$vmStartTime = this.vmStartTime;
        Date other$vmStartTime = other.vmStartTime;
        if (this$vmStartTime == null ? other$vmStartTime != null : !((Object)this$vmStartTime).equals(other$vmStartTime)) {
            return false;
        }
        String this$vmThreadId = this.vmThreadId;
        String other$vmThreadId = other.vmThreadId;
        if (this$vmThreadId == null ? other$vmThreadId != null : !this$vmThreadId.equals(other$vmThreadId)) {
            return false;
        }
        String this$vmThreadName = this.vmThreadName;
        String other$vmThreadName = other.vmThreadName;
        if (this$vmThreadName == null ? other$vmThreadName != null : !this$vmThreadName.equals(other$vmThreadName)) {
            return false;
        }
        JobState this$jobState = this.jobState;
        JobState other$jobState = other.jobState;
        if (this$jobState == null ? other$jobState != null : !((Object)((Object)this$jobState)).equals((Object)other$jobState)) {
            return false;
        }
        Date this$beginTime = this.beginTime;
        Date other$beginTime = other.beginTime;
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Date this$endTime = this.endTime;
        Date other$endTime = other.endTime;
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$message = this.message;
        String other$message = other.message;
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$stackTrace = this.stackTrace;
        String other$stackTrace = other.stackTrace;
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        String this$jobExecutor = this.jobExecutor;
        String other$jobExecutor = other.jobExecutor;
        if (this$jobExecutor == null ? other$jobExecutor != null : !this$jobExecutor.equals(other$jobExecutor)) {
            return false;
        }
        String this$jobCron = this.jobCron;
        String other$jobCron = other.jobCron;
        if (this$jobCron == null ? other$jobCron != null : !this$jobCron.equals(other$jobCron)) {
            return false;
        }
        String this$shardingItemParameters = this.shardingItemParameters;
        String other$shardingItemParameters = other.shardingItemParameters;
        if (this$shardingItemParameters == null ? other$shardingItemParameters != null : !this$shardingItemParameters.equals(other$shardingItemParameters)) {
            return false;
        }
        String this$jobShardingStrategy = this.jobShardingStrategy;
        String other$jobShardingStrategy = other.jobShardingStrategy;
        if (this$jobShardingStrategy == null ? other$jobShardingStrategy != null : !this$jobShardingStrategy.equals(other$jobShardingStrategy)) {
            return false;
        }
        String this$jobAttrs = this.jobAttrs;
        String other$jobAttrs = other.jobAttrs;
        if (this$jobAttrs == null ? other$jobAttrs != null : !this$jobAttrs.equals(other$jobAttrs)) {
            return false;
        }
        String this$jobExceptionHandler = this.jobExceptionHandler;
        String other$jobExceptionHandler = other.jobExceptionHandler;
        if (this$jobExceptionHandler == null ? other$jobExceptionHandler != null : !this$jobExceptionHandler.equals(other$jobExceptionHandler)) {
            return false;
        }
        String this$executorServiceHandler = this.executorServiceHandler;
        String other$executorServiceHandler = other.executorServiceHandler;
        if (this$executorServiceHandler == null ? other$executorServiceHandler != null : !this$executorServiceHandler.equals(other$executorServiceHandler)) {
            return false;
        }
        Date this$crtDt = this.crtDt;
        Date other$crtDt = other.crtDt;
        if (this$crtDt == null ? other$crtDt != null : !((Object)this$crtDt).equals(other$crtDt)) {
            return false;
        }
        Date this$uptDt = this.uptDt;
        Date other$uptDt = other.uptDt;
        if (this$uptDt == null ? other$uptDt != null : !((Object)this$uptDt).equals(other$uptDt)) {
            return false;
        }
        Class<?> this$jobExecutorClass = this.jobExecutorClass;
        Class<?> other$jobExecutorClass = other.jobExecutorClass;
        if (this$jobExecutorClass == null ? other$jobExecutorClass != null : !this$jobExecutorClass.equals(other$jobExecutorClass)) {
            return false;
        }
        Class<?> this$executorServiceHandlerClass = this.executorServiceHandlerClass;
        Class<?> other$executorServiceHandlerClass = other.executorServiceHandlerClass;
        if (this$executorServiceHandlerClass == null ? other$executorServiceHandlerClass != null : !this$executorServiceHandlerClass.equals(other$executorServiceHandlerClass)) {
            return false;
        }
        Class<?> this$jobExceptionHandlerClass = this.jobExceptionHandlerClass;
        Class<?> other$jobExceptionHandlerClass = other.jobExceptionHandlerClass;
        if (this$jobExceptionHandlerClass == null ? other$jobExceptionHandlerClass != null : !this$jobExceptionHandlerClass.equals(other$jobExceptionHandlerClass)) {
            return false;
        }
        Class<?> this$jobShardingStrategyClass = this.jobShardingStrategyClass;
        Class<?> other$jobShardingStrategyClass = other.jobShardingStrategyClass;
        return !(this$jobShardingStrategyClass == null ? other$jobShardingStrategyClass != null : !this$jobShardingStrategyClass.equals(other$jobShardingStrategyClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobRuntimeEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $shardingEnabled = this.shardingEnabled;
        result = result * 59 + ($shardingEnabled == null ? 43 : ((Object)$shardingEnabled).hashCode());
        Integer $shardingTotalCount = this.shardingTotalCount;
        result = result * 59 + ($shardingTotalCount == null ? 43 : ((Object)$shardingTotalCount).hashCode());
        Boolean $failover = this.failover;
        result = result * 59 + ($failover == null ? 43 : ((Object)$failover).hashCode());
        Boolean $misfire = this.misfire;
        result = result * 59 + ($misfire == null ? 43 : ((Object)$misfire).hashCode());
        Boolean $streamingProcess = this.streamingProcess;
        result = result * 59 + ($streamingProcess == null ? 43 : ((Object)$streamingProcess).hashCode());
        Boolean $monitorExecution = this.monitorExecution;
        result = result * 59 + ($monitorExecution == null ? 43 : ((Object)$monitorExecution).hashCode());
        Integer $maxTimeDiffSeconds = this.maxTimeDiffSeconds;
        result = result * 59 + ($maxTimeDiffSeconds == null ? 43 : ((Object)$maxTimeDiffSeconds).hashCode());
        Integer $monitorPort = this.monitorPort;
        result = result * 59 + ($monitorPort == null ? 43 : ((Object)$monitorPort).hashCode());
        Boolean $disabled = this.disabled;
        result = result * 59 + ($disabled == null ? 43 : ((Object)$disabled).hashCode());
        Boolean $overwrite = this.overwrite;
        result = result * 59 + ($overwrite == null ? 43 : ((Object)$overwrite).hashCode());
        Integer $reconcileIntervalMinutes = this.reconcileIntervalMinutes;
        result = result * 59 + ($reconcileIntervalMinutes == null ? 43 : ((Object)$reconcileIntervalMinutes).hashCode());
        Integer $executorPoolSize = this.executorPoolSize;
        result = result * 59 + ($executorPoolSize == null ? 43 : ((Object)$executorPoolSize).hashCode());
        Boolean $deleted = this.deleted;
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $profile = this.profile;
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        String $sysId = this.sysId;
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        String $jobName = this.jobName;
        result = result * 59 + ($jobName == null ? 43 : $jobName.hashCode());
        JobType $jobType = this.jobType;
        result = result * 59 + ($jobType == null ? 43 : $jobType.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $jobParameter = this.jobParameter;
        result = result * 59 + ($jobParameter == null ? 43 : $jobParameter.hashCode());
        String $shardingItems = this.shardingItems;
        result = result * 59 + ($shardingItems == null ? 43 : $shardingItems.hashCode());
        String $vmProcessUid = this.vmProcessUid;
        result = result * 59 + ($vmProcessUid == null ? 43 : $vmProcessUid.hashCode());
        Date $vmStartTime = this.vmStartTime;
        result = result * 59 + ($vmStartTime == null ? 43 : ((Object)$vmStartTime).hashCode());
        String $vmThreadId = this.vmThreadId;
        result = result * 59 + ($vmThreadId == null ? 43 : $vmThreadId.hashCode());
        String $vmThreadName = this.vmThreadName;
        result = result * 59 + ($vmThreadName == null ? 43 : $vmThreadName.hashCode());
        JobState $jobState = this.jobState;
        result = result * 59 + ($jobState == null ? 43 : ((Object)((Object)$jobState)).hashCode());
        Date $beginTime = this.beginTime;
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Date $endTime = this.endTime;
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $message = this.message;
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $stackTrace = this.stackTrace;
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        String $jobExecutor = this.jobExecutor;
        result = result * 59 + ($jobExecutor == null ? 43 : $jobExecutor.hashCode());
        String $jobCron = this.jobCron;
        result = result * 59 + ($jobCron == null ? 43 : $jobCron.hashCode());
        String $shardingItemParameters = this.shardingItemParameters;
        result = result * 59 + ($shardingItemParameters == null ? 43 : $shardingItemParameters.hashCode());
        String $jobShardingStrategy = this.jobShardingStrategy;
        result = result * 59 + ($jobShardingStrategy == null ? 43 : $jobShardingStrategy.hashCode());
        String $jobAttrs = this.jobAttrs;
        result = result * 59 + ($jobAttrs == null ? 43 : $jobAttrs.hashCode());
        String $jobExceptionHandler = this.jobExceptionHandler;
        result = result * 59 + ($jobExceptionHandler == null ? 43 : $jobExceptionHandler.hashCode());
        String $executorServiceHandler = this.executorServiceHandler;
        result = result * 59 + ($executorServiceHandler == null ? 43 : $executorServiceHandler.hashCode());
        Date $crtDt = this.crtDt;
        result = result * 59 + ($crtDt == null ? 43 : ((Object)$crtDt).hashCode());
        Date $uptDt = this.uptDt;
        result = result * 59 + ($uptDt == null ? 43 : ((Object)$uptDt).hashCode());
        Class<?> $jobExecutorClass = this.jobExecutorClass;
        result = result * 59 + ($jobExecutorClass == null ? 43 : $jobExecutorClass.hashCode());
        Class<?> $executorServiceHandlerClass = this.executorServiceHandlerClass;
        result = result * 59 + ($executorServiceHandlerClass == null ? 43 : $executorServiceHandlerClass.hashCode());
        Class<?> $jobExceptionHandlerClass = this.jobExceptionHandlerClass;
        result = result * 59 + ($jobExceptionHandlerClass == null ? 43 : $jobExceptionHandlerClass.hashCode());
        Class<?> $jobShardingStrategyClass = this.jobShardingStrategyClass;
        result = result * 59 + ($jobShardingStrategyClass == null ? 43 : $jobShardingStrategyClass.hashCode());
        return result;
    }

    public String toString() {
        return "JobRuntimeEntity(id=" + this.id + ", profile=" + this.profile + ", sysId=" + this.sysId + ", jobName=" + this.jobName + ", jobType=" + this.jobType + ", description=" + this.description + ", jobParameter=" + this.jobParameter + ", shardingItems=" + this.shardingItems + ", vmProcessUid=" + this.vmProcessUid + ", vmStartTime=" + this.vmStartTime + ", vmThreadId=" + this.vmThreadId + ", vmThreadName=" + this.vmThreadName + ", jobState=" + (Object)((Object)this.jobState) + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", message=" + this.message + ", stackTrace=" + this.stackTrace + ", jobExecutor=" + this.jobExecutor + ", jobCron=" + this.jobCron + ", shardingEnabled=" + this.shardingEnabled + ", shardingTotalCount=" + this.shardingTotalCount + ", shardingItemParameters=" + this.shardingItemParameters + ", failover=" + this.failover + ", misfire=" + this.misfire + ", streamingProcess=" + this.streamingProcess + ", monitorExecution=" + this.monitorExecution + ", maxTimeDiffSeconds=" + this.maxTimeDiffSeconds + ", monitorPort=" + this.monitorPort + ", jobShardingStrategy=" + this.jobShardingStrategy + ", disabled=" + this.disabled + ", overwrite=" + this.overwrite + ", reconcileIntervalMinutes=" + this.reconcileIntervalMinutes + ", jobAttrs=" + this.jobAttrs + ", jobExceptionHandler=" + this.jobExceptionHandler + ", executorServiceHandler=" + this.executorServiceHandler + ", executorPoolSize=" + this.executorPoolSize + ", deleted=" + this.deleted + ", crtDt=" + this.crtDt + ", uptDt=" + this.uptDt + ", jobExecutorClass=" + this.jobExecutorClass + ", executorServiceHandlerClass=" + this.executorServiceHandlerClass + ", jobExceptionHandlerClass=" + this.jobExceptionHandlerClass + ", jobShardingStrategyClass=" + this.jobShardingStrategyClass + ")";
    }

    public JobRuntimeEntity(String id, String profile, String sysId, String jobName, JobType jobType, String description, String jobParameter, String shardingItems, String vmProcessUid, Date vmStartTime, String vmThreadId, String vmThreadName, JobState jobState, Date beginTime, Date endTime, String message, String stackTrace, String jobExecutor, String jobCron, Boolean shardingEnabled, Integer shardingTotalCount, String shardingItemParameters, Boolean failover, Boolean misfire, Boolean streamingProcess, Boolean monitorExecution, Integer maxTimeDiffSeconds, Integer monitorPort, String jobShardingStrategy, Boolean disabled, Boolean overwrite, Integer reconcileIntervalMinutes, String jobAttrs, String jobExceptionHandler, String executorServiceHandler, Integer executorPoolSize, Boolean deleted, Date crtDt, Date uptDt, Class<?> jobExecutorClass, Class<?> executorServiceHandlerClass, Class<?> jobExceptionHandlerClass, Class<?> jobShardingStrategyClass) {
        this.id = id;
        this.profile = profile;
        this.sysId = sysId;
        this.jobName = jobName;
        this.jobType = jobType;
        this.description = description;
        this.jobParameter = jobParameter;
        this.shardingItems = shardingItems;
        this.vmProcessUid = vmProcessUid;
        this.vmStartTime = vmStartTime;
        this.vmThreadId = vmThreadId;
        this.vmThreadName = vmThreadName;
        this.jobState = jobState;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.message = message;
        this.stackTrace = stackTrace;
        this.jobExecutor = jobExecutor;
        this.jobCron = jobCron;
        this.shardingEnabled = shardingEnabled;
        this.shardingTotalCount = shardingTotalCount;
        this.shardingItemParameters = shardingItemParameters;
        this.failover = failover;
        this.misfire = misfire;
        this.streamingProcess = streamingProcess;
        this.monitorExecution = monitorExecution;
        this.maxTimeDiffSeconds = maxTimeDiffSeconds;
        this.monitorPort = monitorPort;
        this.jobShardingStrategy = jobShardingStrategy;
        this.disabled = disabled;
        this.overwrite = overwrite;
        this.reconcileIntervalMinutes = reconcileIntervalMinutes;
        this.jobAttrs = jobAttrs;
        this.jobExceptionHandler = jobExceptionHandler;
        this.executorServiceHandler = executorServiceHandler;
        this.executorPoolSize = executorPoolSize;
        this.deleted = deleted;
        this.crtDt = crtDt;
        this.uptDt = uptDt;
        this.jobExecutorClass = jobExecutorClass;
        this.executorServiceHandlerClass = executorServiceHandlerClass;
        this.jobExceptionHandlerClass = jobExceptionHandlerClass;
        this.jobShardingStrategyClass = jobShardingStrategyClass;
    }

    public JobRuntimeEntity() {
        this.jobParameter = JobRuntimeEntity.$default$jobParameter();
        this.shardingItemParameters = JobRuntimeEntity.$default$shardingItemParameters();
        this.misfire = JobRuntimeEntity.$default$misfire();
        this.streamingProcess = JobRuntimeEntity.$default$streamingProcess();
        this.monitorExecution = JobRuntimeEntity.$default$monitorExecution();
        this.maxTimeDiffSeconds = JobRuntimeEntity.$default$maxTimeDiffSeconds();
        this.monitorPort = JobRuntimeEntity.$default$monitorPort();
        this.jobShardingStrategy = JobRuntimeEntity.$default$jobShardingStrategy();
        this.reconcileIntervalMinutes = JobRuntimeEntity.$default$reconcileIntervalMinutes();
    }

    public static final class Fields {
        public static final String id = "id";
        public static final String profile = "profile";
        public static final String sysId = "sysId";
        public static final String jobName = "jobName";
        public static final String jobType = "jobType";
        public static final String description = "description";
        public static final String jobParameter = "jobParameter";
        public static final String shardingItems = "shardingItems";
        public static final String vmProcessUid = "vmProcessUid";
        public static final String vmStartTime = "vmStartTime";
        public static final String vmThreadId = "vmThreadId";
        public static final String vmThreadName = "vmThreadName";
        public static final String jobState = "jobState";
        public static final String beginTime = "beginTime";
        public static final String endTime = "endTime";
        public static final String message = "message";
        public static final String stackTrace = "stackTrace";
        public static final String jobExecutor = "jobExecutor";
        public static final String jobCron = "jobCron";
        public static final String shardingEnabled = "shardingEnabled";
        public static final String shardingTotalCount = "shardingTotalCount";
        public static final String shardingItemParameters = "shardingItemParameters";
        public static final String failover = "failover";
        public static final String misfire = "misfire";
        public static final String streamingProcess = "streamingProcess";
        public static final String monitorExecution = "monitorExecution";
        public static final String maxTimeDiffSeconds = "maxTimeDiffSeconds";
        public static final String monitorPort = "monitorPort";
        public static final String jobShardingStrategy = "jobShardingStrategy";
        public static final String disabled = "disabled";
        public static final String overwrite = "overwrite";
        public static final String reconcileIntervalMinutes = "reconcileIntervalMinutes";
        public static final String jobAttrs = "jobAttrs";
        public static final String jobExceptionHandler = "jobExceptionHandler";
        public static final String executorServiceHandler = "executorServiceHandler";
        public static final String executorPoolSize = "executorPoolSize";
        public static final String deleted = "deleted";
        public static final String crtDt = "crtDt";
        public static final String uptDt = "uptDt";
        public static final String jobExecutorClass = "jobExecutorClass";
        public static final String executorServiceHandlerClass = "executorServiceHandlerClass";
        public static final String jobExceptionHandlerClass = "jobExceptionHandlerClass";
        public static final String jobShardingStrategyClass = "jobShardingStrategyClass";

        private Fields() {
        }
    }

    public static class JobRuntimeEntityBuilder {
        private String id;
        private String profile;
        private String sysId;
        private String jobName;
        private JobType jobType;
        private String description;
        private boolean jobParameter$set;
        private String jobParameter$value;
        private String shardingItems;
        private String vmProcessUid;
        private Date vmStartTime;
        private String vmThreadId;
        private String vmThreadName;
        private JobState jobState;
        private Date beginTime;
        private Date endTime;
        private String message;
        private String stackTrace;
        private String jobExecutor;
        private String jobCron;
        private Boolean shardingEnabled;
        private Integer shardingTotalCount;
        private boolean shardingItemParameters$set;
        private String shardingItemParameters$value;
        private Boolean failover;
        private boolean misfire$set;
        private Boolean misfire$value;
        private boolean streamingProcess$set;
        private Boolean streamingProcess$value;
        private boolean monitorExecution$set;
        private Boolean monitorExecution$value;
        private boolean maxTimeDiffSeconds$set;
        private Integer maxTimeDiffSeconds$value;
        private boolean monitorPort$set;
        private Integer monitorPort$value;
        private boolean jobShardingStrategy$set;
        private String jobShardingStrategy$value;
        private Boolean disabled;
        private Boolean overwrite;
        private boolean reconcileIntervalMinutes$set;
        private Integer reconcileIntervalMinutes$value;
        private String jobAttrs;
        private String jobExceptionHandler;
        private String executorServiceHandler;
        private Integer executorPoolSize;
        private Boolean deleted;
        private Date crtDt;
        private Date uptDt;
        private Class<?> jobExecutorClass;
        private Class<?> executorServiceHandlerClass;
        private Class<?> jobExceptionHandlerClass;
        private Class<?> jobShardingStrategyClass;

        JobRuntimeEntityBuilder() {
        }

        public JobRuntimeEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public JobRuntimeEntityBuilder profile(String profile) {
            this.profile = profile;
            return this;
        }

        public JobRuntimeEntityBuilder sysId(String sysId) {
            this.sysId = sysId;
            return this;
        }

        public JobRuntimeEntityBuilder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public JobRuntimeEntityBuilder jobType(JobType jobType) {
            this.jobType = jobType;
            return this;
        }

        public JobRuntimeEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        public JobRuntimeEntityBuilder jobParameter(String jobParameter) {
            this.jobParameter$value = jobParameter;
            this.jobParameter$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder shardingItems(String shardingItems) {
            this.shardingItems = shardingItems;
            return this;
        }

        public JobRuntimeEntityBuilder vmProcessUid(String vmProcessUid) {
            this.vmProcessUid = vmProcessUid;
            return this;
        }

        public JobRuntimeEntityBuilder vmStartTime(Date vmStartTime) {
            this.vmStartTime = vmStartTime;
            return this;
        }

        public JobRuntimeEntityBuilder vmThreadId(String vmThreadId) {
            this.vmThreadId = vmThreadId;
            return this;
        }

        public JobRuntimeEntityBuilder vmThreadName(String vmThreadName) {
            this.vmThreadName = vmThreadName;
            return this;
        }

        public JobRuntimeEntityBuilder jobState(JobState jobState) {
            this.jobState = jobState;
            return this;
        }

        public JobRuntimeEntityBuilder beginTime(Date beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public JobRuntimeEntityBuilder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        public JobRuntimeEntityBuilder message(String message) {
            this.message = message;
            return this;
        }

        public JobRuntimeEntityBuilder stackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public JobRuntimeEntityBuilder jobExecutor(String jobExecutor) {
            this.jobExecutor = jobExecutor;
            return this;
        }

        public JobRuntimeEntityBuilder jobCron(String jobCron) {
            this.jobCron = jobCron;
            return this;
        }

        public JobRuntimeEntityBuilder shardingEnabled(Boolean shardingEnabled) {
            this.shardingEnabled = shardingEnabled;
            return this;
        }

        public JobRuntimeEntityBuilder shardingTotalCount(Integer shardingTotalCount) {
            this.shardingTotalCount = shardingTotalCount;
            return this;
        }

        public JobRuntimeEntityBuilder shardingItemParameters(String shardingItemParameters) {
            this.shardingItemParameters$value = shardingItemParameters;
            this.shardingItemParameters$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder failover(Boolean failover) {
            this.failover = failover;
            return this;
        }

        public JobRuntimeEntityBuilder misfire(Boolean misfire) {
            this.misfire$value = misfire;
            this.misfire$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder streamingProcess(Boolean streamingProcess) {
            this.streamingProcess$value = streamingProcess;
            this.streamingProcess$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder monitorExecution(Boolean monitorExecution) {
            this.monitorExecution$value = monitorExecution;
            this.monitorExecution$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder maxTimeDiffSeconds(Integer maxTimeDiffSeconds) {
            this.maxTimeDiffSeconds$value = maxTimeDiffSeconds;
            this.maxTimeDiffSeconds$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder monitorPort(Integer monitorPort) {
            this.monitorPort$value = monitorPort;
            this.monitorPort$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder jobShardingStrategy(String jobShardingStrategy) {
            this.jobShardingStrategy$value = jobShardingStrategy;
            this.jobShardingStrategy$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public JobRuntimeEntityBuilder overwrite(Boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public JobRuntimeEntityBuilder reconcileIntervalMinutes(Integer reconcileIntervalMinutes) {
            this.reconcileIntervalMinutes$value = reconcileIntervalMinutes;
            this.reconcileIntervalMinutes$set = true;
            return this;
        }

        public JobRuntimeEntityBuilder jobAttrs(String jobAttrs) {
            this.jobAttrs = jobAttrs;
            return this;
        }

        public JobRuntimeEntityBuilder jobExceptionHandler(String jobExceptionHandler) {
            this.jobExceptionHandler = jobExceptionHandler;
            return this;
        }

        public JobRuntimeEntityBuilder executorServiceHandler(String executorServiceHandler) {
            this.executorServiceHandler = executorServiceHandler;
            return this;
        }

        public JobRuntimeEntityBuilder executorPoolSize(Integer executorPoolSize) {
            this.executorPoolSize = executorPoolSize;
            return this;
        }

        public JobRuntimeEntityBuilder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public JobRuntimeEntityBuilder crtDt(Date crtDt) {
            this.crtDt = crtDt;
            return this;
        }

        public JobRuntimeEntityBuilder uptDt(Date uptDt) {
            this.uptDt = uptDt;
            return this;
        }

        public JobRuntimeEntityBuilder jobExecutorClass(Class<?> jobExecutorClass) {
            this.jobExecutorClass = jobExecutorClass;
            return this;
        }

        public JobRuntimeEntityBuilder executorServiceHandlerClass(Class<?> executorServiceHandlerClass) {
            this.executorServiceHandlerClass = executorServiceHandlerClass;
            return this;
        }

        public JobRuntimeEntityBuilder jobExceptionHandlerClass(Class<?> jobExceptionHandlerClass) {
            this.jobExceptionHandlerClass = jobExceptionHandlerClass;
            return this;
        }

        public JobRuntimeEntityBuilder jobShardingStrategyClass(Class<?> jobShardingStrategyClass) {
            this.jobShardingStrategyClass = jobShardingStrategyClass;
            return this;
        }

        public JobRuntimeEntity build() {
            String jobParameter$value = this.jobParameter$value;
            if (!this.jobParameter$set) {
                jobParameter$value = JobRuntimeEntity.$default$jobParameter();
            }
            String shardingItemParameters$value = this.shardingItemParameters$value;
            if (!this.shardingItemParameters$set) {
                shardingItemParameters$value = JobRuntimeEntity.$default$shardingItemParameters();
            }
            Boolean misfire$value = this.misfire$value;
            if (!this.misfire$set) {
                misfire$value = JobRuntimeEntity.$default$misfire();
            }
            Boolean streamingProcess$value = this.streamingProcess$value;
            if (!this.streamingProcess$set) {
                streamingProcess$value = JobRuntimeEntity.$default$streamingProcess();
            }
            Boolean monitorExecution$value = this.monitorExecution$value;
            if (!this.monitorExecution$set) {
                monitorExecution$value = JobRuntimeEntity.$default$monitorExecution();
            }
            Integer maxTimeDiffSeconds$value = this.maxTimeDiffSeconds$value;
            if (!this.maxTimeDiffSeconds$set) {
                maxTimeDiffSeconds$value = JobRuntimeEntity.$default$maxTimeDiffSeconds();
            }
            Integer monitorPort$value = this.monitorPort$value;
            if (!this.monitorPort$set) {
                monitorPort$value = JobRuntimeEntity.$default$monitorPort();
            }
            String jobShardingStrategy$value = this.jobShardingStrategy$value;
            if (!this.jobShardingStrategy$set) {
                jobShardingStrategy$value = JobRuntimeEntity.$default$jobShardingStrategy();
            }
            Integer reconcileIntervalMinutes$value = this.reconcileIntervalMinutes$value;
            if (!this.reconcileIntervalMinutes$set) {
                reconcileIntervalMinutes$value = JobRuntimeEntity.$default$reconcileIntervalMinutes();
            }
            return new JobRuntimeEntity(this.id, this.profile, this.sysId, this.jobName, this.jobType, this.description, jobParameter$value, this.shardingItems, this.vmProcessUid, this.vmStartTime, this.vmThreadId, this.vmThreadName, this.jobState, this.beginTime, this.endTime, this.message, this.stackTrace, this.jobExecutor, this.jobCron, this.shardingEnabled, this.shardingTotalCount, shardingItemParameters$value, this.failover, misfire$value, streamingProcess$value, monitorExecution$value, maxTimeDiffSeconds$value, monitorPort$value, jobShardingStrategy$value, this.disabled, this.overwrite, reconcileIntervalMinutes$value, this.jobAttrs, this.jobExceptionHandler, this.executorServiceHandler, this.executorPoolSize, this.deleted, this.crtDt, this.uptDt, this.jobExecutorClass, this.executorServiceHandlerClass, this.jobExceptionHandlerClass, this.jobShardingStrategyClass);
        }

        public String toString() {
            return "JobRuntimeEntity.JobRuntimeEntityBuilder(id=" + this.id + ", profile=" + this.profile + ", sysId=" + this.sysId + ", jobName=" + this.jobName + ", jobType=" + this.jobType + ", description=" + this.description + ", jobParameter$value=" + this.jobParameter$value + ", shardingItems=" + this.shardingItems + ", vmProcessUid=" + this.vmProcessUid + ", vmStartTime=" + this.vmStartTime + ", vmThreadId=" + this.vmThreadId + ", vmThreadName=" + this.vmThreadName + ", jobState=" + (Object)((Object)this.jobState) + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", message=" + this.message + ", stackTrace=" + this.stackTrace + ", jobExecutor=" + this.jobExecutor + ", jobCron=" + this.jobCron + ", shardingEnabled=" + this.shardingEnabled + ", shardingTotalCount=" + this.shardingTotalCount + ", shardingItemParameters$value=" + this.shardingItemParameters$value + ", failover=" + this.failover + ", misfire$value=" + this.misfire$value + ", streamingProcess$value=" + this.streamingProcess$value + ", monitorExecution$value=" + this.monitorExecution$value + ", maxTimeDiffSeconds$value=" + this.maxTimeDiffSeconds$value + ", monitorPort$value=" + this.monitorPort$value + ", jobShardingStrategy$value=" + this.jobShardingStrategy$value + ", disabled=" + this.disabled + ", overwrite=" + this.overwrite + ", reconcileIntervalMinutes$value=" + this.reconcileIntervalMinutes$value + ", jobAttrs=" + this.jobAttrs + ", jobExceptionHandler=" + this.jobExceptionHandler + ", executorServiceHandler=" + this.executorServiceHandler + ", executorPoolSize=" + this.executorPoolSize + ", deleted=" + this.deleted + ", crtDt=" + this.crtDt + ", uptDt=" + this.uptDt + ", jobExecutorClass=" + this.jobExecutorClass + ", executorServiceHandlerClass=" + this.executorServiceHandlerClass + ", jobExceptionHandlerClass=" + this.jobExceptionHandlerClass + ", jobShardingStrategyClass=" + this.jobShardingStrategyClass + ")";
        }
    }
}

